/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.synchronize.update.action;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IResource;
import org.eclipse.team.core.synchronize.FastSyncInfoFilter;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.modelbus.team.eclipse.core.IStateFilter;
import org.modelbus.team.eclipse.core.connector.ModelBusRevision;
import org.modelbus.team.eclipse.core.operation.CompositeOperation;
import org.modelbus.team.eclipse.core.operation.IActionOperation;
import org.modelbus.team.eclipse.core.operation.local.ClearLocalStatusesOperation;
import org.modelbus.team.eclipse.core.operation.local.RefreshResourcesOperation;
import org.modelbus.team.eclipse.core.operation.local.RemoveNonVersionedResourcesOperation;
import org.modelbus.team.eclipse.core.operation.local.RestoreProjectMetaOperation;
import org.modelbus.team.eclipse.core.operation.local.RevertOperation;
import org.modelbus.team.eclipse.core.operation.local.SaveProjectMetaOperation;
import org.modelbus.team.eclipse.core.operation.local.UpdateOperation;
import org.modelbus.team.eclipse.core.resource.ILocalResource;
import org.modelbus.team.eclipse.core.resource.IResourceProvider;
import org.modelbus.team.eclipse.core.utility.FileUtility;
import org.modelbus.team.eclipse.ui.dialog.DefaultDialog;
import org.modelbus.team.eclipse.ui.operation.ClearUpdateStatusesOperation;
import org.modelbus.team.eclipse.ui.panel.local.OverrideResourcesPanel;
import org.modelbus.team.eclipse.ui.synchronize.action.AbstractSynchronizeModelAction;
import org.modelbus.team.eclipse.ui.synchronize.action.ISyncStateFilter;
import org.modelbus.team.eclipse.ui.synchronize.update.action.UpdateAction;
import org.modelbus.team.eclipse.ui.utility.UnacceptableOperationNotificator;

public class OverrideAndUpdateAction
extends AbstractSynchronizeModelAction {
    public OverrideAndUpdateAction(String text, ISynchronizePageConfiguration configuration) {
        super(text, configuration);
    }

    protected FastSyncInfoFilter getSyncInfoFilter() {
        return new FastSyncInfoFilter.SyncInfoDirectionFilter(new int[]{4, 8, 12});
    }

    @Override
    protected IActionOperation getOperation(ISynchronizePageConfiguration configuration, IDiffElement[] elements) {
        IResource[][] resources = new IResource[1][];
        IResource[] obstructedResources = this.syncInfoSelector.getSelectedResourcesRecursive(IStateFilter.SF_OBSTRUCTED);
        obstructedResources = FileUtility.addOperableParents((IResource[])obstructedResources, (IStateFilter)IStateFilter.SF_OBSTRUCTED);
        HashSet<IResource> allResources = new HashSet<IResource>(Arrays.asList(obstructedResources));
        IResource[] changedResources = this.syncInfoSelector.getSelectedResourcesRecursive(ISyncStateFilter.SF_OVERRIDE);
        changedResources = UnacceptableOperationNotificator.shrinkResourcesWithNotOnRespositoryParents(configuration.getSite().getShell(), changedResources);
        if (changedResources != null) {
            changedResources = FileUtility.addOperableParents((IResource[])changedResources, (IStateFilter)IStateFilter.SF_NOTONREPOSITORY);
            allResources.addAll(Arrays.asList(changedResources));
        }
        if (allResources.size() > 0) {
            IResource[] fullSet = allResources.toArray(new IResource[allResources.size()]);
            OverrideResourcesPanel panel = new OverrideResourcesPanel(fullSet, fullSet, 1);
            DefaultDialog dialog = new DefaultDialog(configuration.getSite().getShell(), panel);
            if (dialog.open() != 0) {
                return null;
            }
            resources[0] = panel.getSelectedResources();
        }
        CompositeOperation op = new CompositeOperation("Operation.UOverrideAndUpdate");
        SaveProjectMetaOperation saveOp = new SaveProjectMetaOperation(resources[0]);
        op.add((IActionOperation)saveOp);
        RevertOperation revertOp = new RevertOperation(FileUtility.getResourcesRecursive((IResource[])resources[0], (IStateFilter)IStateFilter.SF_REVERTABLE, (int)0), true);
        op.add((IActionOperation)revertOp);
        op.add((IActionOperation)new ClearLocalStatusesOperation(resources[0]));
        RemoveNonVersionedResourcesOperation removeNonVersionedResourcesOp = new RemoveNonVersionedResourcesOperation(resources[0], true);
        op.add((IActionOperation)removeNonVersionedResourcesOp);
        RevertOperation revertOp1 = new RevertOperation(FileUtility.getResourcesRecursive((IResource[])resources[0], (IStateFilter)IStateFilter.SF_OBSTRUCTED, (int)0), true);
        op.add((IActionOperation)revertOp1);
        op.add((IActionOperation)new ClearLocalStatusesOperation(resources[0]));
        Map<ModelBusRevision, Set<IResource>> splitted = UpdateAction.splitByPegRevision(this, resources[0]);
        for (Map.Entry<ModelBusRevision, Set<IResource>> entry : splitted.entrySet()) {
            final IResource[] toUpdate = entry.getValue().toArray(new IResource[0]);
            UpdateOperation mainOp = new UpdateOperation(new IResourceProvider(){

                public IResource[] getResources() {
                    return FileUtility.getResourcesRecursive((IResource[])toUpdate, (IStateFilter)new IStateFilter.AbstractStateFilter(){

                        protected boolean acceptImpl(ILocalResource local, IResource resource, String state, int mask) {
                            return IStateFilter.SF_ONREPOSITORY.accept(resource, state, mask) || IStateFilter.SF_NOTEXISTS.accept(resource, state, mask);
                        }

                        protected boolean allowsRecursionImpl(ILocalResource local, IResource resource, String state, int mask) {
                            return true;
                        }
                    }, (int)0);
                }
            }, entry.getKey(), true);
            op.add((IActionOperation)mainOp, new IActionOperation[]{revertOp, revertOp1, removeNonVersionedResourcesOp});
            op.add((IActionOperation)new ClearUpdateStatusesOperation((IResourceProvider)mainOp));
        }
        op.add((IActionOperation)new RestoreProjectMetaOperation(saveOp));
        op.add((IActionOperation)new RefreshResourcesOperation(resources[0]));
        return op;
    }
}

