/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.synchronize.update.action;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.team.core.synchronize.FastSyncInfoFilter;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.modelbus.team.eclipse.core.IStateFilter;
import org.modelbus.team.eclipse.core.connector.ModelBusRevision;
import org.modelbus.team.eclipse.core.modelbusstorage.ResourcesParentsProvider;
import org.modelbus.team.eclipse.core.operation.CompositeOperation;
import org.modelbus.team.eclipse.core.operation.IActionOperation;
import org.modelbus.team.eclipse.core.operation.local.IUnresolvedConflictDetector;
import org.modelbus.team.eclipse.core.operation.local.RefreshResourcesOperation;
import org.modelbus.team.eclipse.core.operation.local.RestoreProjectMetaOperation;
import org.modelbus.team.eclipse.core.operation.local.SaveProjectMetaOperation;
import org.modelbus.team.eclipse.core.operation.local.UpdateOperation;
import org.modelbus.team.eclipse.core.resource.IResourceProvider;
import org.modelbus.team.eclipse.core.utility.FileUtility;
import org.modelbus.team.eclipse.ui.ModelBusTeamUIPlugin;
import org.modelbus.team.eclipse.ui.operation.ClearUpdateStatusesOperation;
import org.modelbus.team.eclipse.ui.operation.NotifyUnresolvedConflictOperation;
import org.modelbus.team.eclipse.ui.synchronize.action.AbstractSynchronizeModelAction;
import org.modelbus.team.eclipse.ui.synchronize.update.UpdateSyncInfo;
import org.modelbus.team.eclipse.ui.utility.UnacceptableOperationNotificator;

public class UpdateAction
extends AbstractSynchronizeModelAction {
    protected boolean advancedMode;

    public UpdateAction(String text, ISynchronizePageConfiguration configuration) {
        super(text, configuration);
        this.advancedMode = false;
    }

    public UpdateAction(String text, ISynchronizePageConfiguration configuration, ISelectionProvider selectionProvider) {
        super(text, configuration, selectionProvider);
        this.advancedMode = true;
    }

    protected FastSyncInfoFilter getSyncInfoFilter() {
        return new FastSyncInfoFilter.SyncInfoDirectionFilter(new int[]{8, 12}){

            public boolean select(SyncInfo info) {
                return super.select(info) && !IStateFilter.SF_OBSTRUCTED.accept(((UpdateSyncInfo)info).getLocalResource());
            }
        };
    }

    @Override
    protected IActionOperation getOperation(ISynchronizePageConfiguration configuration, IDiffElement[] elements) {
        IResource[] resources = UnacceptableOperationNotificator.shrinkResourcesWithNotOnRespositoryParents(configuration.getSite().getShell(), this.syncInfoSelector.getSelectedResources());
        if (resources == null || resources.length == 0) {
            return null;
        }
        IResource[] missing = FileUtility.getResourcesRecursive((IResource[])(resources = FileUtility.addOperableParents((IResource[])resources, (IStateFilter)IStateFilter.SF_UNVERSIONED)), (IStateFilter)IStateFilter.SF_MISSING);
        if (missing.length > 0 && !org.modelbus.team.eclipse.ui.action.local.UpdateAction.updateMissing(configuration.getSite().getShell(), missing)) {
            return null;
        }
        if (this.advancedMode) {
            String message = resources.length == 1 ? ModelBusTeamUIPlugin.instance().getResource("UpdateAll.Message.Single") : ModelBusTeamUIPlugin.instance().getResource("UpdateAll.Message.Multi", new String[]{String.valueOf(resources.length)});
            MessageDialog dlg = new MessageDialog(configuration.getSite().getShell(), ModelBusTeamUIPlugin.instance().getResource("UpdateAll.Title"), null, message, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
            if (dlg.open() != 0) {
                return null;
            }
        }
        CompositeOperation op = new CompositeOperation("Operation.Update");
        SaveProjectMetaOperation saveOp = new SaveProjectMetaOperation(resources);
        op.add((IActionOperation)saveOp);
        Map<ModelBusRevision, Set<IResource>> splitted = UpdateAction.splitByPegRevision(this, resources);
        for (Map.Entry<ModelBusRevision, Set<IResource>> entry : splitted.entrySet()) {
            UpdateOperation mainOp = new UpdateOperation(entry.getValue().toArray(new IResource[0]), entry.getKey(), true);
            op.add((IActionOperation)mainOp);
            op.add((IActionOperation)new ClearUpdateStatusesOperation((IResourceProvider)mainOp));
            op.add((IActionOperation)new NotifyUnresolvedConflictOperation((IUnresolvedConflictDetector)mainOp));
        }
        op.add((IActionOperation)new RestoreProjectMetaOperation(saveOp));
        op.add((IActionOperation)new RefreshResourcesOperation((IResourceProvider)new ResourcesParentsProvider(resources)));
        return op;
    }

    public static Map<ModelBusRevision, Set<IResource>> splitByPegRevision(AbstractSynchronizeModelAction action, IResource[] resources) {
        HashMap<ModelBusRevision, Set<IResource>> splitted = new HashMap<ModelBusRevision, Set<IResource>>();
        splitted.put(ModelBusRevision.HEAD, new HashSet<IResource>(Arrays.asList(resources)));
        return splitted;
    }
}

