/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.synchronize.variant;

import java.io.ByteArrayInputStream;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.TeamException;
import org.modelbus.team.eclipse.core.IStateFilter;
import org.modelbus.team.eclipse.core.connector.ModelBusChangeStatus;
import org.modelbus.team.eclipse.core.connector.ModelBusConnector;
import org.modelbus.team.eclipse.core.connector.ModelBusRevision;
import org.modelbus.team.eclipse.core.modelbusstorage.ModelBusRemoteStorage;
import org.modelbus.team.eclipse.core.operation.IActionOperation;
import org.modelbus.team.eclipse.core.operation.remote.GetFileContentOperation;
import org.modelbus.team.eclipse.core.resource.ILocalResource;
import org.modelbus.team.eclipse.core.resource.IRepositoryResource;
import org.modelbus.team.eclipse.core.resource.IResourceChange;
import org.modelbus.team.eclipse.core.utility.ModelBusUtility;
import org.modelbus.team.eclipse.core.utility.ProgressMonitorUtility;
import org.modelbus.team.eclipse.ui.synchronize.variant.RemoteResourceVariant;

public class RemoteFileVariant
extends RemoteResourceVariant {
    public RemoteFileVariant(ILocalResource local) {
        super(local);
    }

    protected void fetchContents(IProgressMonitor monitor) throws TeamException {
        if (!this.local.isCopied() && this.local.getRevision() == ModelBusRevision.INVALID_REVISION_DESCRIPTOR || IStateFilter.SF_DELETED.accept(this.local) && !IStateFilter.SF_REPLACED.accept(this.local)) {
            this.setContents(new ByteArrayInputStream(new byte[0]), monitor);
            return;
        }
        IRepositoryResource remote = null;
        if (this.local.isCopied()) {
            ModelBusChangeStatus st = ModelBusUtility.getModelBusInfoForNotConnected((IResource)this.local.getResource());
            remote = ModelBusConnector.asRepositoryFile((String)st.urlCopiedFrom, (boolean)false);
            remote.setSelectedRevision(st.revisionCopiedFrom);
            remote.setPegRevision(st.revisionCopiedFrom);
        } else {
            IRepositoryResource originator;
            remote = ModelBusRemoteStorage.instance().asRepositoryResource(this.local.getResource());
            remote.setSelectedRevision(this.local.getRevision());
            remote.setPegRevision(((IResourceChange)this.local).getPegRevision());
            if (this.local instanceof IResourceChange && (originator = ((IResourceChange)this.local).getOriginator()) != null) {
                remote = originator;
            }
        }
        GetFileContentOperation op = new GetFileContentOperation(remote);
        ProgressMonitorUtility.doTaskExternal((IActionOperation)op, (IProgressMonitor)monitor);
        if (op.getExecutionState() == 0) {
            this.setContents(op.getContent(), monitor);
        }
    }

    public boolean isContainer() {
        return false;
    }
}

