/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.verifier;

import java.util.Iterator;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.modelbus.team.eclipse.ui.verifier.AbstractVerifier;
import org.modelbus.team.eclipse.ui.verifier.GroupVerifier;
import org.modelbus.team.eclipse.ui.verifier.IValidationManager;
import org.modelbus.team.eclipse.ui.verifier.IVerifierListener;

public abstract class AbstractVerificationKeyListener
extends KeyAdapter
implements IValidationManager,
IVerifierListener {
    protected GroupVerifier verifier = new GroupVerifier();

    public AbstractVerificationKeyListener() {
        this.verifier.addVerifierListener(this);
    }

    @Override
    public void attachTo(Control cmp, AbstractVerifier verifier) {
        this.verifier.add(cmp, verifier);
    }

    public void addListeners() {
        Iterator<Control> it = this.verifier.getComponents();
        while (it.hasNext()) {
            Control cmp = it.next();
            if (cmp instanceof Text) {
                ((Text)cmp).addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        AbstractVerificationKeyListener.this.validateContent();
                    }
                });
            }
            if (cmp instanceof StyledText) {
                ((StyledText)cmp).addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        AbstractVerificationKeyListener.this.validateContent();
                    }
                });
            }
            if (!(cmp instanceof Combo)) continue;
            ((Combo)cmp).addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    AbstractVerificationKeyListener.this.validateContent();
                }
            });
            ((Combo)cmp).addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    AbstractVerificationKeyListener.this.validateContent();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
    }

    @Override
    public void detachFrom(Control cmp) {
        this.verifier.remove(cmp);
        if (!cmp.isDisposed()) {
            cmp.removeKeyListener((KeyListener)this);
        }
    }

    @Override
    public void detachAll() {
        Iterator<Control> it = this.verifier.getComponents();
        while (it.hasNext()) {
            Control ctrl = it.next();
            if (ctrl.isDisposed()) continue;
            ctrl.removeKeyListener((KeyListener)this);
        }
        this.verifier.removeAll();
    }

    @Override
    public void validateContent() {
        this.verifier.verify();
    }

    @Override
    public boolean validateControl(Control cmp) {
        return this.verifier.verify(cmp);
    }

    @Override
    public boolean isFilledRight() {
        return this.verifier.isFilledRight();
    }

    public void keyReleased(KeyEvent e) {
        this.validateContent();
    }
}

