/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.verifier;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.widgets.Control;
import org.modelbus.team.eclipse.ui.verifier.AbstractVerifier;
import org.modelbus.team.eclipse.ui.verifier.IVerifierListener;

public class CompositeVerifier
extends AbstractVerifier
implements IVerifierListener {
    protected List<AbstractVerifier> verifiers = new ArrayList<AbstractVerifier>();

    public List<AbstractVerifier> getVerifiers() {
        return this.verifiers;
    }

    public void add(AbstractVerifier verifier) {
        if (!this.verifiers.contains(verifier)) {
            verifier.addVerifierListener(this);
            this.verifiers.add(verifier);
        }
    }

    public void remove(AbstractVerifier verifier) {
        if (this.verifiers.remove(verifier)) {
            verifier.removeVerifierListener(this);
        }
    }

    public void removeAll() {
        for (AbstractVerifier verifier : this.verifiers) {
            verifier.removeVerifierListener(this);
        }
        this.verifiers.clear();
    }

    @Override
    public boolean verify(Control input) {
        this.hasWarning = false;
        for (AbstractVerifier verifier : this.verifiers) {
            if (verifier.verify(input)) continue;
            return false;
        }
        if (!this.hasWarning) {
            this.fireOk();
        }
        return true;
    }

    @Override
    public void hasError(String errorReason) {
        this.fireError(errorReason);
    }

    @Override
    public void hasWarning(String warningReason) {
        this.fireWarning(warningReason);
    }

    @Override
    public void hasNoError() {
    }

    @Override
    protected String getErrorMessage(Control input) {
        return null;
    }

    @Override
    protected String getWarningMessage(Control input) {
        return null;
    }
}

