/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.verifier;

import java.io.File;
import org.eclipse.swt.widgets.Control;
import org.modelbus.team.eclipse.ui.ModelBusTeamUIPlugin;
import org.modelbus.team.eclipse.ui.verifier.AbstractFormattedVerifier;

public class ExistingResourceVerifier
extends AbstractFormattedVerifier {
    protected static String ERROR_MESSAGE_DOES_NOT_EXIST;
    protected static String ERROR_MESSAGE_IS_NOT_A_FILE;
    protected static String ERROR_MESSAGE_IS_NOT_A_DIRECTORY;
    protected boolean checkNodeType;
    protected boolean files;

    public ExistingResourceVerifier(String fieldName) {
        super(fieldName);
        this.init();
        this.checkNodeType = false;
    }

    public ExistingResourceVerifier(String fieldName, boolean files) {
        super(fieldName);
        this.init();
        this.files = files;
        this.checkNodeType = true;
    }

    @Override
    protected String getErrorMessageImpl(Control input) {
        File currentFile = new File(this.getText(input));
        if (!currentFile.exists()) {
            return ERROR_MESSAGE_DOES_NOT_EXIST;
        }
        if (this.checkNodeType && this.files && !currentFile.isFile()) {
            return ERROR_MESSAGE_IS_NOT_A_FILE;
        }
        if (this.checkNodeType && !this.files && !currentFile.isDirectory()) {
            return ERROR_MESSAGE_IS_NOT_A_DIRECTORY;
        }
        return null;
    }

    @Override
    protected String getWarningMessageImpl(Control input) {
        return null;
    }

    private void init() {
        ERROR_MESSAGE_DOES_NOT_EXIST = ModelBusTeamUIPlugin.instance().getResource("Verifier.ExistingResource.NotExists", new String[]{"$FIELD_NAME$"});
        ERROR_MESSAGE_IS_NOT_A_FILE = ModelBusTeamUIPlugin.instance().getResource("Verifier.ExistingResource.IsNotAFile", new String[]{"$FIELD_NAME$"});
        ERROR_MESSAGE_IS_NOT_A_DIRECTORY = ModelBusTeamUIPlugin.instance().getResource("Verifier.ExistingResource.IsNotADir", new String[]{"$FIELD_NAME$"});
    }
}

