/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.verifier;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.swt.widgets.Control;
import org.modelbus.team.eclipse.ui.verifier.AbstractVerifier;
import org.modelbus.team.eclipse.ui.verifier.CompositeVerifier;

public class GroupVerifier
extends CompositeVerifier {
    protected Map<AbstractVerifier, Control> componentsMap = new LinkedHashMap<AbstractVerifier, Control>();

    public boolean verify() {
        this.hasWarning = false;
        for (AbstractVerifier iVer : this.verifiers) {
            if (iVer.verify(this.componentsMap.get(iVer))) continue;
            return false;
        }
        if (!this.hasWarning) {
            this.fireOk();
        }
        return true;
    }

    @Override
    public boolean verify(Control input) {
        for (Map.Entry<AbstractVerifier, Control> entry : this.componentsMap.entrySet()) {
            if (!entry.getValue().equals(input)) continue;
            return entry.getKey().verify(input);
        }
        return true;
    }

    public void add(Control cmp, AbstractVerifier verifier) {
        super.add(verifier);
        this.componentsMap.put(verifier, cmp);
    }

    public void remove(Control cmp) {
        Iterator<Map.Entry<AbstractVerifier, Control>> it = this.componentsMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<AbstractVerifier, Control> entry = it.next();
            if (cmp != entry.getValue()) continue;
            AbstractVerifier verifier = entry.getKey();
            super.remove(verifier);
            it.remove();
            break;
        }
    }

    @Override
    public void removeAll() {
        super.removeAll();
        this.componentsMap.clear();
    }

    public Iterator<Control> getComponents() {
        return this.componentsMap.values().iterator();
    }
}

