/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.verifier;

import org.eclipse.swt.widgets.Control;
import org.modelbus.team.eclipse.ui.ModelBusTeamUIPlugin;
import org.modelbus.team.eclipse.ui.verifier.AbstractFormattedVerifier;

public class IntegerFieldVerifier
extends AbstractFormattedVerifier {
    protected static String ERROR_NAN;
    protected static String ERROR_NEGATIVE;
    protected boolean positive;

    public IntegerFieldVerifier(String fieldName, boolean positive) {
        super(fieldName);
        this.positive = positive;
        ERROR_NAN = ModelBusTeamUIPlugin.instance().getResource("Verifier.IntegerField.NaN", new String[]{"$FIELD_NAME$"});
        ERROR_NEGATIVE = ModelBusTeamUIPlugin.instance().getResource("Verifier.IntegerField.Negative", new String[]{"$FIELD_NAME$"});
    }

    @Override
    protected String getErrorMessageImpl(Control input) {
        String text = this.getText(input);
        try {
            long i = Long.parseLong(text);
            if (this.positive && i < 0L) {
                return ERROR_NEGATIVE;
            }
        }
        catch (Exception exception) {
            return ERROR_NAN;
        }
        return null;
    }

    @Override
    protected String getWarningMessageImpl(Control input) {
        return null;
    }
}

