/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.verifier;

import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.widgets.Control;
import org.modelbus.team.eclipse.ui.ModelBusTeamUIPlugin;
import org.modelbus.team.eclipse.ui.verifier.AbstractFormattedVerifier;

public class PropertyNameVerifier
extends AbstractFormattedVerifier {
    protected static String ERROR_MESSAGE_LETTER;
    protected static String ERROR_MESSAGE_SYMBOLS;
    protected HashSet<String> ignoreStrings;

    public PropertyNameVerifier(String fieldName) {
        super(fieldName);
        ERROR_MESSAGE_LETTER = ModelBusTeamUIPlugin.instance().getResource("Verifier.PropertyName.Letter", new String[]{"$FIELD_NAME$"});
        ERROR_MESSAGE_SYMBOLS = ModelBusTeamUIPlugin.instance().getResource("Verifier.PropertyName.Symbols", new String[]{"$FIELD_NAME$"});
        this.ignoreStrings = new HashSet();
        this.ignoreStrings.add(ModelBusTeamUIPlugin.instance().getResource("AbstractPropertyEditPanel.modelbus_description"));
        this.ignoreStrings.add(ModelBusTeamUIPlugin.instance().getResource("PropertyEditPanel.tmodelbus_description"));
        this.ignoreStrings.add(ModelBusTeamUIPlugin.instance().getResource("PropertyEditPanel.bugtraq_description"));
        this.ignoreStrings.add(ModelBusTeamUIPlugin.instance().getResource("AbstractPropertyEditPanel.custom_description"));
        this.ignoreStrings.add("    " + ModelBusTeamUIPlugin.instance().getResource("AbstractPropertyEditPanel.custom_hint"));
    }

    @Override
    protected String getErrorMessageImpl(Control input) {
        String property = this.getText(input);
        if (property.trim().length() == 0) {
            return null;
        }
        if (this.ignoreStrings.contains(property)) {
            return ModelBusTeamUIPlugin.instance().getResource("AbstractPropertyEditPanel.Name.Verifier.IgnoreStrings");
        }
        Pattern pattern = Pattern.compile("[a-zA-Z].*");
        Matcher matcher = pattern.matcher(property);
        if (!matcher.matches()) {
            return ERROR_MESSAGE_LETTER;
        }
        pattern = Pattern.compile("[a-zA-Z0-9:\\-_.]*");
        if (!pattern.matcher(property).matches()) {
            return ERROR_MESSAGE_SYMBOLS;
        }
        return null;
    }

    @Override
    protected String getWarningMessageImpl(Control input) {
        return null;
    }
}

