/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.verifier;

import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.widgets.Control;
import org.modelbus.team.eclipse.core.resource.IRepositoryResource;
import org.modelbus.team.eclipse.core.utility.ModelBusUtility;
import org.modelbus.team.eclipse.ui.ModelBusTeamUIPlugin;
import org.modelbus.team.eclipse.ui.verifier.AbstractFormattedVerifier;

public class PropertyVerifier
extends AbstractFormattedVerifier {
    private IRepositoryResource base;
    private Pattern pattern;
    private String propName;
    private boolean toValidate;

    public PropertyVerifier(String fieldName, String regExp, String propName, IRepositoryResource base) {
        super(fieldName);
        if (regExp == null) {
            this.toValidate = false;
            return;
        }
        this.toValidate = true;
        String[] parts = propName.split(":");
        this.propName = "";
        int i = 0;
        while (i < parts.length) {
            this.propName = String.valueOf(this.propName) + parts[i];
            ++i;
        }
        this.pattern = Pattern.compile(regExp);
        this.base = base;
    }

    @Override
    protected String getErrorMessageImpl(Control input) {
        if (!this.toValidate || this.propName.equals("modelbuslog") || this.propName.equals("modelbusauthor")) {
            return null;
        }
        String inputText = this.getText(input);
        if (this.propName.equals("bugtraqlogregex")) {
            try {
                String[] logs = inputText.split("\r\n");
                int i = 0;
                while (i < logs.length) {
                    Pattern.compile(logs[i]);
                    ++i;
                }
            }
            catch (Exception exception) {
                return ModelBusTeamUIPlugin.instance().getResource("PropertyEditPanel.Verifier." + this.propName);
            }
            return null;
        }
        if (this.propName.equals("bugtraqmessage")) {
            if (!inputText.contains("%BUGID%")) {
                return ModelBusTeamUIPlugin.instance().getResource("PropertyEditPanel.Verifier." + this.propName);
            }
            return null;
        }
        if (this.propName.equals("modelbusexternals")) {
            try {
                ModelBusUtility.parseModelBusExternalsProperty((String)inputText, (IRepositoryResource)this.base);
            }
            catch (Exception exception) {
                return ModelBusTeamUIPlugin.instance().getResource("PropertyEditPanel.Verifier." + this.propName);
            }
            return null;
        }
        if (this.propName.equals("modelbusdate")) {
            try {
                new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").parse(inputText);
            }
            catch (Exception exception) {
                return ModelBusTeamUIPlugin.instance().getResource("PropertyEditPanel.Verifier." + this.propName, new String[]{"yyyy-MM-dd'T'HH:mm:ss.SSS'Z'"});
            }
            return null;
        }
        Matcher matcher = this.pattern.matcher(inputText);
        if (!matcher.matches()) {
            String retVal = ModelBusTeamUIPlugin.instance().getResource("PropertyEditPanel.Verifier." + this.propName);
            if (retVal.equals("PropertyEditPanel.Verifier." + this.propName)) {
                return MessageFormat.format(ModelBusTeamUIPlugin.instance().getResource("PropertyEditPanel.regExp.Verifier"), this.pattern.pattern());
            }
            return ModelBusTeamUIPlugin.instance().getResource("PropertyEditPanel.Verifier." + this.propName);
        }
        return null;
    }

    @Override
    protected String getWarningMessageImpl(Control input) {
        if (this.propName == null) {
            return null;
        }
        if (this.propName.equals("modelbusauthor") || this.propName.equals("modelbuslog") || this.propName.equals("modelbusdate")) {
            return ModelBusTeamUIPlugin.instance().getResource("PropertyEditPanel.Verifier.Warning." + this.propName);
        }
        return null;
    }
}

