/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.verifier;

import java.net.URL;
import org.eclipse.swt.widgets.Control;
import org.modelbus.team.eclipse.core.utility.ModelBusUtility;
import org.modelbus.team.eclipse.ui.ModelBusTeamUIPlugin;
import org.modelbus.team.eclipse.ui.verifier.AbstractFormattedVerifier;

public class URLVerifier
extends AbstractFormattedVerifier {
    protected static final String ERROR_REASON = "$ERROR_REASON$";
    protected static String ERROR_MESSAGE_SHORT;
    protected static String ERROR_MESSAGE_FULL;

    public URLVerifier(String fieldName) {
        super(fieldName);
        ERROR_MESSAGE_SHORT = ModelBusTeamUIPlugin.instance().getResource("Verifier.URL.Short", new String[]{"$FIELD_NAME$"});
        ERROR_MESSAGE_FULL = ModelBusTeamUIPlugin.instance().getResource("Verifier.URL.Full", new String[]{"$FIELD_NAME$", ERROR_REASON});
    }

    @Override
    protected String getErrorMessageImpl(Control input) {
        String url = this.getText(input);
        try {
            URL modelbusUrl = ModelBusUtility.getModelBusUrl((String)url);
            String host = modelbusUrl.getHost();
            if (!host.matches("[a-zA-Z0-9_\\-]+(?:\\.[a-zA-Z0-9_\\-]+)*") && host.length() > 0 || host.length() == 0 && !"file".equals(modelbusUrl.getProtocol())) {
                this.setPlaceHolder(ERROR_REASON, ModelBusTeamUIPlugin.instance().getResource("Verifier.URL.NoHost"));
                return ERROR_MESSAGE_FULL;
            }
            return null;
        }
        catch (Exception ex) {
            this.setPlaceHolder(ERROR_REASON, ex.getMessage());
            return ex.getMessage() == null ? ERROR_MESSAGE_SHORT : ERROR_MESSAGE_FULL;
        }
    }

    @Override
    protected String getWarningMessageImpl(Control input) {
        return null;
    }
}

