/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.wizard;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.wizard.IWizardPage;
import org.modelbus.team.eclipse.core.utility.ModelBusUtility;
import org.modelbus.team.eclipse.ui.ModelBusTeamUIPlugin;
import org.modelbus.team.eclipse.ui.wizard.AbstractModelBusWizard;
import org.modelbus.team.eclipse.ui.wizard.createpatch.PatchOptionsPage;
import org.modelbus.team.eclipse.ui.wizard.createpatch.SelectPatchFilePage;

public class CreatePatchWizard
extends AbstractModelBusWizard {
    public static final int WRITE_TO_CLIPBOARD = 0;
    public static final int WRITE_TO_EXTERNAL_FILE = 1;
    public static final int WRITE_TO_WORKSPACE_FILE = 2;
    protected String targetName;
    protected boolean showIgnoreAncestry;
    protected SelectPatchFilePage selectFile;
    protected PatchOptionsPage options;
    protected IResource[] roots;

    public CreatePatchWizard(String targetName) {
        this(targetName, null);
    }

    public CreatePatchWizard(String targetName, IResource[] roots) {
        this(targetName, roots, false);
    }

    public CreatePatchWizard(String targetName, IResource[] roots, boolean showIgnoreAncestry) {
        this.setWindowTitle(ModelBusTeamUIPlugin.instance().getResource("CreatePatchWizard.Title"));
        this.targetName = targetName;
        this.roots = roots;
        this.showIgnoreAncestry = showIgnoreAncestry;
    }

    public int getRootPoint() {
        return this.options.getRootPoint();
    }

    public IResource getTargetFolder() {
        return ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(this.getFileName())).getParent();
    }

    public String getFileName() {
        return this.selectFile.getFileName();
    }

    public int getWriteMode() {
        return this.selectFile.getWriteMode();
    }

    public boolean isIgnoreDeleted() {
        return this.options.isIgnoreDeleted();
    }

    public boolean isProcessBinary() {
        return this.options.isProcessBinary();
    }

    public boolean isProcessUnversioned() {
        return this.options.isProcessUnversioned();
    }

    public boolean isRecursive() {
        return this.options.isRecursive() & this.selectFile.isRecursive();
    }

    public IResource[] getSelection() {
        return this.selectFile.isRecursive() ? this.roots : this.selectFile.getSelection();
    }

    public boolean isIgnoreAncestry() {
        return this.options.isIgnoreAncestry();
    }

    public void addPages() {
        this.selectFile = new SelectPatchFilePage(this.targetName, this.roots);
        this.addPage((IWizardPage)this.selectFile);
        this.options = new PatchOptionsPage(this.roots != null, this.showIgnoreAncestry);
        this.addPage((IWizardPage)this.options);
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (this.roots != null) {
            this.options.setMultiSelect(ModelBusUtility.splitWorkingCopies((IResource[])this.getSelection()).size() > 1);
        }
        return super.getNextPage(page);
    }

    public boolean performFinish() {
        return true;
    }
}

