/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.wizard;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.team.ui.IConfigurationWizard;
import org.eclipse.ui.IWorkbench;
import org.modelbus.team.eclipse.core.IStateFilter;
import org.modelbus.team.eclipse.core.operation.AbstractActionOperation;
import org.modelbus.team.eclipse.core.operation.CompositeOperation;
import org.modelbus.team.eclipse.core.operation.IActionOperation;
import org.modelbus.team.eclipse.core.operation.IUnprotectedOperation;
import org.modelbus.team.eclipse.core.operation.local.NotifyProjectStatesChangedOperation;
import org.modelbus.team.eclipse.core.operation.local.RefreshResourcesOperation;
import org.modelbus.team.eclipse.core.operation.local.management.IShareProjectPrompt;
import org.modelbus.team.eclipse.core.operation.local.management.ReconnectProjectOperation;
import org.modelbus.team.eclipse.core.operation.local.management.ShareProjectOperation;
import org.modelbus.team.eclipse.core.resource.IResourceProvider;
import org.modelbus.team.eclipse.core.utility.FileUtility;
import org.modelbus.team.eclipse.ui.ModelBusTeamUIPlugin;
import org.modelbus.team.eclipse.ui.action.IResourceSelector;
import org.modelbus.team.eclipse.ui.extension.ExtensionsManager;
import org.modelbus.team.eclipse.ui.extension.factory.ICommitDialog;
import org.modelbus.team.eclipse.ui.extension.factory.IShareProjectFactory;
import org.modelbus.team.eclipse.ui.panel.local.CommitPanel;
import org.modelbus.team.eclipse.ui.synchronize.ModelBusChangeSetCapability;
import org.modelbus.team.eclipse.ui.utility.CommitActionUtility;
import org.modelbus.team.eclipse.ui.utility.UIMonitorUtility;
import org.modelbus.team.eclipse.ui.wizard.AbstractModelBusWizard;
import org.modelbus.team.eclipse.ui.wizard.shareproject.AlreadyConnectedPage;
import org.modelbus.team.eclipse.ui.wizard.shareproject.EditCommentPage;
import org.modelbus.team.eclipse.ui.wizard.shareproject.IShareProjectWrapper;
import org.modelbus.team.eclipse.ui.wizard.shareproject.SelectProjectNamePage;
import org.modelbus.team.eclipse.ui.wizard.shareproject.SelectProjectsGroupPage;

public class ShareProjectWizard
extends AbstractModelBusWizard
implements IConfigurationWizard {
    protected IProject[] allProjects;
    protected IResourceProvider projects;
    protected SelectProjectNamePage selectName;
    protected AlreadyConnectedPage connectedPage;
    protected EditCommentPage commentPage;

    public ShareProjectWizard() {
        this.setWindowTitle(ModelBusTeamUIPlugin.instance().getResource("ShareProjectWizard.Title.Single"));
    }

    public void addPages() {
        this.projects = new SelectProjectsGroupPage(this.allProjects);
        this.addPage((IWizardPage)((SelectProjectsGroupPage)this.projects));
        this.connectedPage = new AlreadyConnectedPage();
        this.addPage((IWizardPage)this.connectedPage);
        this.selectName = ExtensionsManager.getInstance().getCurrentShareProjectFactory().getProjectLayoutPage();
        this.addPage((IWizardPage)this.selectName);
        this.commentPage = new EditCommentPage(this.projects);
        this.addPage((IWizardPage)this.commentPage);
    }

    @Override
    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
    }

    public IWizardPage getStartingPage() {
        if (!this.isGroupSelectionRequired()) {
            return this.getNextPage(super.getStartingPage());
        }
        return super.getStartingPage();
    }

    public IWizardPage getNextPage(IWizardPage page) {
        IWizardPage retVal = null;
        retVal = super.getNextPage(page);
        if (retVal == this.selectName) {
            System.out.println("TODOMWA11");
        } else if (retVal == this.commentPage) {
            System.out.println("TODOMWA12");
            this.commentPage.setDefaultCommitMessage();
        } else if (retVal == this.connectedPage && this.alreadyConnected()) {
            this.connectedPage.setProjects(this.getProjects());
        }
        return retVal;
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        IWizardPage retVal = null;
        retVal = super.getPreviousPage(page) == this.connectedPage && !this.alreadyConnected() ? super.getPreviousPage(super.getPreviousPage(page)) : super.getPreviousPage(page);
        if (retVal == this.projects && !this.isGroupSelectionRequired()) {
            return null;
        }
        return retVal;
    }

    public boolean canFinish() {
        IWizardPage currentPage = this.getContainer().getCurrentPage();
        IShareProjectFactory factory = ExtensionsManager.getInstance().getCurrentShareProjectFactory();
        if (currentPage instanceof SelectProjectsGroupPage) {
            return false;
        }
        if (currentPage instanceof AlreadyConnectedPage) {
            return ((AlreadyConnectedPage)currentPage).useProjectSettings() && currentPage.isPageComplete() && !factory.disallowFinishOnAlreadyConnected(this.getProjects());
        }
        return super.canFinish();
    }

    public boolean performFinish() {
        this.getContainer().getCurrentPage();
        boolean reconnect = this.connectedPage == null || !this.connectedPage.useProjectSettings() && !this.connectedPage.createUsingProjectSettings();
        IShareProjectWrapper mainOp = reconnect ? this.getFreshConnectOperation() : this.getAlreadyConnectedOperation(this.connectedPage.createUsingProjectSettings());
        CompositeOperation op = new CompositeOperation(mainOp.getId());
        op.add((IActionOperation)new NotifyProjectStatesChangedOperation(mainOp.getProjects(), 2));
        op.add((IActionOperation)new RefreshResourcesOperation((IResourceProvider)mainOp, 2, RefreshResourcesOperation.REFRESH_ALL));
        op.add((IActionOperation)new NotifyProjectStatesChangedOperation(mainOp.getProjects(), 0));
        if (!(this.alreadyConnected() && !reconnect || this.commentPage != null && !this.commentPage.isShowCommitDialog())) {
            op.add((IActionOperation)new PostShareCommitOperation(mainOp));
        }
        UIMonitorUtility.doTaskScheduledActive((IActionOperation)op);
        return true;
    }

    protected boolean isGroupSelectionRequired() {
        return ((SelectProjectsGroupPage)this.projects).isGroupSelectionRequired();
    }

    protected IShareProjectWrapper getAlreadyConnectedOperation(boolean create) {
        return create ? new ReconnectProjectOperationImpl(this.getProjects()) : new ReconnectProjectOperationImpl(this.getProjects());
    }

    protected IShareProjectWrapper getFreshConnectOperation() {
        ShareProjectOperation mainOp = ExtensionsManager.getInstance().getCurrentShareProjectFactory().getShareProjectOperation(this.getProjects(), this.selectName, this.commentPage.getCommitComment());
        mainOp.setSharePrompt(new IShareProjectPrompt(){

            public boolean prompt(final IProject[] projects) {
                final int[] result = new int[1];
                UIMonitorUtility.getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        String projectNames = FileUtility.getNamesListAsString((Object[])projects);
                        String message = ModelBusTeamUIPlugin.instance().getResource(projects.length == 1 ? "ShareProject.Confirmation.Description.Single" : "ShareProject.Confirmation.Description.Multiple", new String[]{projectNames});
                        MessageDialog dialog = new MessageDialog(UIMonitorUtility.getShell(), ModelBusTeamUIPlugin.instance().getResource(projects.length == 1 ? "ShareProject.Confirmation.Title.Single" : "ShareProject.Confirmation.Title.Multiple"), null, message, 4, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
                        result[0] = dialog.open();
                    }
                });
                return result[0] == 0;
            }
        });
        CompositeOperationImpl op = new CompositeOperationImpl(mainOp.getId());
        AbstractActionOperation predecessor = null;
        if (this.alreadyConnected()) {
            predecessor = new AbstractActionOperation("Operation.DropModelBusMeta"){

                public ISchedulingRule getSchedulingRule() {
                    return MultiRule.combine((ISchedulingRule[])ShareProjectWizard.this.getProjects());
                }

                protected void runImpl(IProgressMonitor monitor) throws Exception {
                    IProject[] projects = ShareProjectWizard.this.getProjects();
                    int i = 0;
                    while (i < projects.length && !monitor.isCanceled()) {
                        final IProject project = projects[i];
                        this.protectStep(new IUnprotectedOperation(){

                            public void run(IProgressMonitor monitor) throws Exception {
                                FileUtility.removeModelBusMetaInformation((IResource)project, (IProgressMonitor)monitor);
                            }
                        }, monitor, projects.length);
                        ++i;
                    }
                }
            };
            op.add((IActionOperation)predecessor);
        }
        if (predecessor != null) {
            op.add((IActionOperation)mainOp, new IActionOperation[]{predecessor});
        } else {
            op.add((IActionOperation)mainOp);
        }
        return op;
    }

    public void init(IWorkbench workbench, IProject project) {
        this.init(new IProject[]{project});
    }

    public void init(IProject[] projects) {
        this.allProjects = projects;
        if (projects.length > 1) {
            this.setWindowTitle(ModelBusTeamUIPlugin.instance().getResource("ShareProjectWizard.Title.Multiple"));
        } else {
            this.setWindowTitle(ModelBusTeamUIPlugin.instance().getResource("ShareProjectWizard.Title.Single"));
        }
    }

    protected boolean alreadyConnected() {
        return FileUtility.alreadyOnModelBus((IResource)this.getProjects()[0]);
    }

    protected IProject[] getProjects() {
        return (IProject[])this.projects.getResources();
    }

    protected class CompositeOperationImpl
    extends CompositeOperation
    implements IShareProjectWrapper {
        public CompositeOperationImpl(String name) {
            super(name);
        }

        public IResource[] getResources() {
            return this.getProjects();
        }

        @Override
        public IProject[] getProjects() {
            return ShareProjectWizard.this.getProjects();
        }
    }

    protected class PostShareCommitOperation
    extends AbstractActionOperation {
        protected IActionOperation mainOp;

        public PostShareCommitOperation(IActionOperation mainOp) {
            super("Operation.PrepareCommit");
            this.mainOp = mainOp;
        }

        protected void runImpl(final IProgressMonitor monitor) throws Exception {
            if (this.mainOp.getExecutionState() != 0) {
                return;
            }
            IResourceSelector selector = new IResourceSelector(){

                @Override
                public IResource[] getSelectedResources() {
                    return ShareProjectWizard.this.getProjects();
                }

                @Override
                public IResource[] getSelectedResources(IStateFilter filter) {
                    return FileUtility.getResourcesRecursive((IResource[])this.getSelectedResources(), (IStateFilter)filter, (int)0);
                }

                @Override
                public IResource[] getSelectedResourcesRecursive(IStateFilter filter) {
                    return this.getSelectedResourcesRecursive(filter, 2);
                }

                @Override
                public IResource[] getSelectedResourcesRecursive(IStateFilter filter, int depth) {
                    return FileUtility.getResourcesRecursive((IResource[])this.getSelectedResources(), (IStateFilter)filter, (int)depth, (IActionOperation)PostShareCommitOperation.this, (IProgressMonitor)monitor);
                }
            };
            final CommitActionUtility commitUtility = new CommitActionUtility(selector);
            if (commitUtility.getAllResources().length == 0) {
                return;
            }
            String proposedComment = ModelBusChangeSetCapability.getProposedComment(commitUtility.getAllResources());
            IResource[] allResources = commitUtility.getAllResources();
            final CommitPanel commitPanel = new CommitPanel(allResources, allResources, 0, proposedComment);
            final CompositeOperation[] commitOp = new CompositeOperation[1];
            UIMonitorUtility.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    ICommitDialog commitDialog = ExtensionsManager.getInstance().getCurrentCommitFactory().getCommitDialog(ShareProjectWizard.this.getShell(), commitUtility.getAllResourcesSet(), commitPanel);
                    if (commitDialog.open() == 0) {
                        commitOp[0] = commitUtility.getCompositeCommitOperation(commitPanel.getSelectedResources(), commitPanel.getNotSelectedResources(), commitDialog.getMessage(), commitPanel.getKeepLocks(), ShareProjectWizard.this.getShell(), UIMonitorUtility.getActivePart(), true);
                    }
                }
            });
            if (commitOp[0] != null) {
                UIMonitorUtility.doTaskScheduledActive((IActionOperation)commitOp[0]);
            }
        }
    }

    protected class ReconnectProjectOperationImpl
    extends ReconnectProjectOperation
    implements IShareProjectWrapper {
        public ReconnectProjectOperationImpl(IProject[] projects) {
            super(projects);
        }

        public IResource[] getResources() {
            return this.getProjects();
        }

        @Override
        public IProject[] getProjects() {
            return ShareProjectWizard.this.getProjects();
        }
    }
}

