/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.wizard.checkoutas;

import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.modelbus.team.eclipse.core.connector.ModelBusRevision;
import org.modelbus.team.eclipse.core.resource.IRepositoryResource;
import org.modelbus.team.eclipse.core.utility.FileUtility;
import org.modelbus.team.eclipse.ui.ModelBusTeamUIPlugin;
import org.modelbus.team.eclipse.ui.composite.DepthSelectionComposite;
import org.modelbus.team.eclipse.ui.composite.RevisionComposite;
import org.modelbus.team.eclipse.ui.extension.ExtensionsManager;
import org.modelbus.team.eclipse.ui.verifier.AbstractVerifierProxy;
import org.modelbus.team.eclipse.ui.verifier.CompositeVerifier;
import org.modelbus.team.eclipse.ui.verifier.NonEmptyFieldVerifier;
import org.modelbus.team.eclipse.ui.verifier.ResourceNameVerifier;
import org.modelbus.team.eclipse.ui.wizard.AbstractVerifiedWizardPage;

public class CheckoutMethodSelectionPage
extends AbstractVerifiedWizardPage {
    protected static final int USE_NEW_PROJECT_WIZARD = 0;
    protected static final int FIND_PROJECTS = 1;
    protected static final int CHECKOUT_AS_PROJECT = 2;
    protected static final int CHECKOUT_AS_FOLDER = 3;
    protected String defaultName;
    protected Button selectLocationButton;
    protected Text nameField;
    protected RevisionComposite revisionComposite;
    protected DepthSelectionComposite recureDepthSelector;
    protected String projectName;
    protected int checkoutType;
    protected IRepositoryResource resource;
    protected boolean ignoreExternalsSelected;

    public CheckoutMethodSelectionPage(String defaultName, boolean newProjectSelectionEnabled, IRepositoryResource resource) {
        super(CheckoutMethodSelectionPage.class.getName(), ModelBusTeamUIPlugin.instance().getResource("CheckoutMethodSelectionPage.Title"), ModelBusTeamUIPlugin.instance().getImageDescriptor("icons/wizards/newconnect.png"));
        this.setDescription(ModelBusTeamUIPlugin.instance().getResource("CheckoutMethodSelectionPage.Description"));
        this.projectName = this.defaultName = defaultName;
        this.checkoutType = newProjectSelectionEnabled ? 0 : 2;
        this.resource = resource;
        this.ignoreExternalsSelected = false;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public boolean isUseNewProjectWizard() {
        return this.checkoutType == 0;
    }

    public boolean isFindProjectsSelected() {
        return this.checkoutType == 1;
    }

    public boolean isCheckoutAsFolderSelected() {
        return this.checkoutType == 3;
    }

    public int getRecureDepth() {
        return 3;
    }

    public boolean isIgnoreExternalsSelected() {
        return true;
    }

    public ModelBusRevision getSelectedRevision() {
        return this.revisionComposite.getSelectedRevision();
    }

    @Override
    protected Composite createControlImpl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.initializeDialogUnits((Control)composite);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        composite.setLayoutData((Object)data);
        this.setControl((Control)composite);
        Label description = new Label(composite, 64);
        data = new GridData(768);
        data.widthHint = 200;
        data.heightHint = this.convertHeightInCharsToPixels(this.checkoutType == 0 ? 1 : 2);
        description.setLayoutData((Object)data);
        String message = ModelBusTeamUIPlugin.instance().getResource("CheckoutMethodSelectionPage.HintHead", new String[]{this.defaultName});
        description.setText(String.valueOf(message) + (this.checkoutType != 0 ? " " + ModelBusTeamUIPlugin.instance().getResource("CheckoutMethodSelectionPage.HintTail") : ""));
        this.projectName = this.defaultName = FileUtility.formatResourceName((String)this.defaultName);
        Button useNewProjectWizardButton = new Button(composite, 16);
        data = new GridData(768);
        useNewProjectWizardButton.setLayoutData((Object)data);
        useNewProjectWizardButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CheckoutMethodSelectionPage.this.selectionChanged(0);
            }
        });
        useNewProjectWizardButton.setText(ModelBusTeamUIPlugin.instance().getResource("CheckoutMethodSelectionPage.NewWizard"));
        useNewProjectWizardButton.setSelection(this.checkoutType == 0);
        useNewProjectWizardButton.setEnabled(this.checkoutType == 0);
        Button findProjectsButton = new Button(composite, 16);
        data = new GridData(768);
        findProjectsButton.setLayoutData((Object)data);
        findProjectsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CheckoutMethodSelectionPage.this.selectionChanged(1);
            }
        });
        findProjectsButton.setText(ModelBusTeamUIPlugin.instance().getResource("CheckoutMethodSelectionPage.Find"));
        findProjectsButton.setEnabled(this.checkoutType == 0 || ExtensionsManager.getInstance().getCurrentCheckoutFactory().findProjectsOptionEnabled());
        this.selectLocationButton = new Button(composite, 16);
        data = new GridData(768);
        this.selectLocationButton.setLayoutData((Object)data);
        this.selectLocationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CheckoutMethodSelectionPage.this.selectionChanged(2);
            }
        });
        this.selectLocationButton.setText(ModelBusTeamUIPlugin.instance().getResource("CheckoutMethodSelectionPage.Project"));
        this.selectLocationButton.setSelection(this.checkoutType != 0);
        this.nameField = new Text(composite, 2052);
        data = new GridData(768);
        this.nameField.setLayoutData((Object)data);
        this.nameField.setText(this.defaultName);
        this.nameField.setEnabled(this.checkoutType != 0);
        this.nameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String name;
                CheckoutMethodSelectionPage.this.projectName = name = CheckoutMethodSelectionPage.this.nameField.getText().trim();
            }
        });
        String name = ModelBusTeamUIPlugin.instance().getResource("CheckoutMethodSelectionPage.ProjectName.Verifier");
        CompositeVerifier verifier = new CompositeVerifier();
        verifier.add(new ResourceNameVerifier(name, false));
        verifier.add(new NonEmptyFieldVerifier(name));
        this.attachTo((Control)this.nameField, new AbstractVerifierProxy(verifier){

            @Override
            protected boolean isVerificationEnabled(Control input) {
                return CheckoutMethodSelectionPage.this.selectLocationButton.getSelection();
            }
        });
        Label separator = new Label(composite, 258);
        data = new GridData(768);
        data.horizontalSpan = 2;
        data.verticalIndent = 5;
        separator.setLayoutData((Object)data);
        this.revisionComposite = new RevisionComposite(composite, this, false, new String[]{ModelBusTeamUIPlugin.instance().getResource("RevisionComposite.Revision"), ModelBusTeamUIPlugin.instance().getResource("RevisionComposite.HeadRevision")}, ModelBusRevision.HEAD, false);
        data = new GridData(768);
        this.revisionComposite.setLayoutData(data);
        this.revisionComposite.setSelectedResource(this.resource);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.modelbus.team.eclipse.help.checkoutMethodSelectionContext");
        return composite;
    }

    protected void selectionChanged(int newSelection) {
        this.checkoutType = newSelection;
        switch (this.checkoutType) {
            case 0: 
            case 1: 
            case 3: {
                this.projectName = this.defaultName;
                this.nameField.setEnabled(false);
                break;
            }
            case 2: {
                this.projectName = this.nameField.getText().trim();
                this.nameField.setEnabled(true);
            }
        }
        this.validateContent();
    }
}

