/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.wizard.checkoutas;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.modelbus.team.eclipse.core.resource.IRepositoryResource;
import org.modelbus.team.eclipse.core.utility.FileUtility;
import org.modelbus.team.eclipse.core.utility.ModelBusUtility;
import org.modelbus.team.eclipse.core.utility.PatternProvider;
import org.modelbus.team.eclipse.ui.ModelBusTeamUIPlugin;
import org.modelbus.team.eclipse.ui.dialog.DefaultDialog;
import org.modelbus.team.eclipse.ui.verifier.AbstractVerifier;
import org.modelbus.team.eclipse.ui.verifier.AbstractVerifierProxy;
import org.modelbus.team.eclipse.ui.verifier.CompositeVerifier;
import org.modelbus.team.eclipse.ui.verifier.ExistingResourceVerifier;
import org.modelbus.team.eclipse.ui.verifier.NonEmptyFieldVerifier;
import org.modelbus.team.eclipse.ui.wizard.AbstractVerifiedWizardPage;
import org.modelbus.team.eclipse.ui.wizard.checkoutas.ProjectsSelectionPage;

public class ProjectLocationSelectionPage
extends AbstractVerifiedWizardPage {
    protected static String DEFAULT_WORKING_SET;
    protected String location;
    protected String defaultLocation;
    protected String workingSetName;
    protected boolean useDefaultLocation;
    protected ProjectsSelectionPage projectsSelectionPage;
    protected Button browse;
    protected Button useDefaultLocationButton;
    protected Combo workingSetNameCombo;
    protected Text locationField;
    protected boolean sinceEclipse_3_2;

    public ProjectLocationSelectionPage(boolean multiple, ProjectsSelectionPage projectsSelectionPage) {
        super(ProjectLocationSelectionPage.class.getName(), ModelBusTeamUIPlugin.instance().getResource("ProjectLocationSelectionPage.Title"), ModelBusTeamUIPlugin.instance().getImageDescriptor("icons/wizards/newconnect.png"));
        DEFAULT_WORKING_SET = ModelBusTeamUIPlugin.instance().getResource("ProjectLocationSelectionPage.DefaultWS");
        this.setDescription(ModelBusTeamUIPlugin.instance().getResource(multiple ? "ProjectLocationSelectionPage.Description.Multi" : "ProjectLocationSelectionPage.Description.Single"));
        String framework = System.getProperties().getProperty("osgi.framework.version");
        try {
            int version = Integer.parseInt(PatternProvider.replaceAll((String)framework, (String)"\\.", (String)"").substring(0, 2));
            this.sinceEclipse_3_2 = version >= 32;
        }
        catch (NumberFormatException numberFormatException) {
            this.sinceEclipse_3_2 = false;
        }
        this.location = ResourcesPlugin.getWorkspace().getRoot().getLocation().toString();
        this.projectsSelectionPage = projectsSelectionPage;
        this.defaultLocation = ResourcesPlugin.getWorkspace().getRoot().getLocation().toString();
    }

    public String getLocation() {
        return this.useDefaultLocation ? this.defaultLocation : this.location;
    }

    public String getWorkingSetName() {
        return this.workingSetName.equals(DEFAULT_WORKING_SET) ? null : this.workingSetName;
    }

    public void setUseDefaultLocation(boolean defaultLocation) {
        if (!this.sinceEclipse_3_2) {
            this.useDefaultLocationButton.setSelection(defaultLocation);
            this.useDefaultLocationButton.setEnabled(defaultLocation);
            this.refreshControls();
        }
    }

    @Override
    protected Composite createControlImpl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        this.setControl((Control)composite);
        Group locationSelectionGroup = new Group(composite, 0);
        locationSelectionGroup.setLayoutData((Object)new GridData(768));
        layout = new GridLayout();
        layout.numColumns = 2;
        locationSelectionGroup.setLayout((Layout)layout);
        locationSelectionGroup.setText(ModelBusTeamUIPlugin.instance().getResource("ProjectLocationSelectionPage.Location"));
        this.useDefaultLocationButton = new Button((Composite)locationSelectionGroup, 32);
        this.locationField = new Text((Composite)locationSelectionGroup, 2052);
        this.browse = new Button((Composite)locationSelectionGroup, 8);
        data = new GridData();
        data.horizontalSpan = 2;
        this.useDefaultLocationButton.setLayoutData((Object)data);
        this.useDefaultLocationButton.setSelection(true);
        this.useDefaultLocationButton.setText(ModelBusTeamUIPlugin.instance().getResource("ProjectLocationSelectionPage.UseDefaultLocation"));
        this.useDefaultLocationButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ProjectLocationSelectionPage.this.validateContent();
                ProjectLocationSelectionPage.this.refreshControls();
            }
        });
        data = new GridData(768);
        data.widthHint = 300;
        this.locationField.setLayoutData((Object)data);
        this.locationField.setText(this.location);
        this.locationField.setEnabled(false);
        CompositeVerifier verifier = new CompositeVerifier();
        verifier.add(new LocationVerifier(this.projectsSelectionPage, this.defaultLocation, this.sinceEclipse_3_2, this.useDefaultLocationButton));
        verifier.add(new AbstractVerifierProxy(new ExistingResourceVerifier(ModelBusTeamUIPlugin.instance().getResource("ProjectLocationSelectionPage.Location.Verifier"), false)){

            @Override
            protected boolean isVerificationEnabled(Control input) {
                return !ProjectLocationSelectionPage.this.useDefaultLocationButton.getSelection();
            }
        });
        this.attachTo((Control)this.locationField, verifier);
        this.locationField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ProjectLocationSelectionPage.this.location = ProjectLocationSelectionPage.this.locationField.getText();
            }
        });
        this.browse.setText(ModelBusTeamUIPlugin.instance().getResource("Button.Browse"));
        data = new GridData();
        data.widthHint = DefaultDialog.computeButtonWidth(this.browse);
        this.browse.setLayoutData((Object)data);
        this.browse.setEnabled(false);
        this.browse.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                DirectoryDialog fileDialog = new DirectoryDialog(ProjectLocationSelectionPage.this.getShell());
                String res = fileDialog.open();
                if (res != null) {
                    ProjectLocationSelectionPage.this.locationField.setText(res);
                }
            }
        });
        Composite workingSetComposite = new Composite(composite, 0);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.numColumns = 2;
        data = new GridData(768);
        workingSetComposite.setLayout((Layout)layout);
        workingSetComposite.setLayoutData((Object)data);
        Label wSetLabel = new Label(workingSetComposite, 0);
        wSetLabel.setText(ModelBusTeamUIPlugin.instance().getResource("ProjectLocationSelectionPage.SelectWS"));
        this.workingSetNameCombo = new Combo(workingSetComposite, 0);
        data = new GridData(768);
        this.workingSetNameCombo.setLayoutData((Object)data);
        String[] wSetNames = this.getWorkingSetNames();
        ArrayList<String> names = new ArrayList<String>();
        names.add(DEFAULT_WORKING_SET);
        names.addAll(Arrays.asList(wSetNames));
        this.workingSetNameCombo.setItems(names.toArray(new String[names.size()]));
        this.workingSetNameCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ProjectLocationSelectionPage.this.workingSetName = ProjectLocationSelectionPage.this.workingSetNameCombo.getText();
            }
        });
        this.workingSetNameCombo.setText(DEFAULT_WORKING_SET);
        this.attachTo((Control)this.workingSetNameCombo, new NonEmptyFieldVerifier(ModelBusTeamUIPlugin.instance().getResource("ProjectLocationSelectionPage.WorkingSet.Verifier")));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.modelbus.team.eclipse.help.projectLocationSelectionContext");
        return composite;
    }

    protected void refreshControls() {
        this.useDefaultLocation = this.useDefaultLocationButton.isEnabled() && this.useDefaultLocationButton.getSelection();
        this.locationField.setEnabled(!this.useDefaultLocation);
        this.browse.setEnabled(!this.useDefaultLocation);
    }

    protected String[] getWorkingSetNames() {
        ArrayList<String> wSetNames = new ArrayList<String>();
        IWorkingSetManager workingSetManager = ModelBusTeamUIPlugin.instance().getWorkbench().getWorkingSetManager();
        IWorkingSet[] workingSets = workingSetManager.getWorkingSets();
        int i = 0;
        while (i < workingSets.length) {
            wSetNames.add(workingSets[i].getName());
            ++i;
        }
        return wSetNames.toArray(new String[wSetNames.size()]);
    }

    public static class LocationVerifier
    extends AbstractVerifier {
        protected String defaultLocation;
        protected ProjectsSelectionPage projectsSelectionPage;
        protected boolean sinceEclipse_3_2;
        protected Button useDefaultLocationButton;

        public LocationVerifier(ProjectsSelectionPage projectsSelectionPage, String defaultLocation, boolean sinceEclipse3_2, Button useDefaultLocationButton) {
            this.defaultLocation = defaultLocation;
            this.projectsSelectionPage = projectsSelectionPage;
            this.sinceEclipse_3_2 = sinceEclipse3_2;
            this.useDefaultLocationButton = useDefaultLocationButton;
        }

        @Override
        protected String getErrorMessage(Control input) {
            String inputLocation;
            boolean respectHierarchy = this.projectsSelectionPage != null && this.projectsSelectionPage.isRespectHierarchy();
            String parent = this.projectsSelectionPage != null && this.projectsSelectionPage.projects != null ? ModelBusUtility.getResourceParent((IRepositoryResource)this.projectsSelectionPage.projects[0]) : "";
            String string = inputLocation = this.useDefaultLocationButton.getSelection() ? this.defaultLocation : FileUtility.formatPath((String)this.getText(input));
            if (inputLocation.startsWith(this.defaultLocation) && !this.sinceEclipse_3_2 && (respectHierarchy || inputLocation.length() > this.defaultLocation.length())) {
                return ModelBusTeamUIPlugin.instance().getResource("ProjectLocationSelectionPage.Location.Verifier.Error.Eclipse32");
            }
            IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int i = 0;
            while (i < projects.length) {
                IPath location = projects[i].getLocation();
                if (location != null && location.isPrefixOf((IPath)new Path(String.valueOf(inputLocation) + parent))) {
                    return ModelBusTeamUIPlugin.instance().getResource("ProjectLocationSelectionPage.Location.Verifier.Error.ExistingProject", new String[]{location.toString()});
                }
                ++i;
            }
            return null;
        }

        @Override
        protected String getWarningMessage(Control input) {
            return null;
        }
    }
}

