/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.wizard.copymove;

import org.eclipse.jface.wizard.IWizardPage;
import org.modelbus.team.eclipse.core.resource.IRepositoryResource;
import org.modelbus.team.eclipse.ui.ModelBusTeamUIPlugin;
import org.modelbus.team.eclipse.ui.wizard.AbstractModelBusWizard;
import org.modelbus.team.eclipse.ui.wizard.copymove.CommentWizardPage;
import org.modelbus.team.eclipse.ui.wizard.copymove.SelectDestinationPage;

public class CopyMoveWizard
extends AbstractModelBusWizard {
    protected SelectDestinationPage destinationPage;
    protected CommentWizardPage commentPage;
    protected IRepositoryResource[] selectedResources;
    protected boolean isMove;
    protected IRepositoryResource destination;
    protected String comment;
    protected String newName;

    public CopyMoveWizard(IRepositoryResource[] selectedResources, boolean isMove) {
        this.selectedResources = selectedResources;
        this.isMove = isMove;
        this.setWindowTitle(this.isMove ? ModelBusTeamUIPlugin.instance().getResource("MoveToAction.Select.Title") : ModelBusTeamUIPlugin.instance().getResource("CopyToAction.Select.Title"));
    }

    public void addPages() {
        this.destinationPage = new SelectDestinationPage(this.selectedResources);
        this.addPage((IWizardPage)this.destinationPage);
        this.commentPage = new CommentWizardPage(this.isMove);
        this.addPage((IWizardPage)this.commentPage);
    }

    public boolean canFinish() {
        IWizardPage currentPage = this.getContainer().getCurrentPage();
        if (currentPage instanceof SelectDestinationPage) {
            return false;
        }
        return super.canFinish();
    }

    public boolean performFinish() {
        this.destination = this.destinationPage.getDestination();
        this.newName = this.destinationPage.getNewResourceName();
        this.comment = this.commentPage.getComment();
        return true;
    }

    public String getComment() {
        return this.comment;
    }

    public String getNewName() {
        return this.newName;
    }

    public IRepositoryResource getDestination() {
        return this.destination;
    }
}

