/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.model;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.modelbus.team.eclipse.model.ModelFolder;
import org.modelbus.team.eclipse.model.ModelObject;
import org.modelbus.team.eclipse.model.ModelObjectDefinitionFile;
import org.modelbus.team.eclipse.model.ModelProject;
import org.modelbus.team.eclipse.model.ModelResource;

public abstract class ModelContainer
extends ModelResource {
    protected ModelContainer(IContainer container) {
        super((IResource)container);
    }

    protected IContainer getContainer() {
        return (IContainer)this.getResource();
    }

    @Override
    public ModelObject[] getChildren() throws CoreException {
        IResource[] members = this.getContainer().members();
        ArrayList<ModelResource> result = new ArrayList<ModelResource>();
        int i = 0;
        while (i < members.length) {
            IResource resource = members[i];
            if (resource instanceof IFolder) {
                result.add(new ModelFolder((IFolder)resource));
            } else if (ModelObjectDefinitionFile.isModFile(resource)) {
                result.add(new ModelObjectDefinitionFile((IFile)resource));
            } else if (resource instanceof IProject && ModelProject.isModProject((IProject)resource)) {
                result.add(new ModelProject((IProject)resource));
            }
            ++i;
        }
        return result.toArray(new ModelObject[result.size()]);
    }
}

