/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.model.ui;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.team.ui.mapping.ITeamStateChangeEvent;
import org.eclipse.team.ui.mapping.ITeamStateChangeListener;
import org.eclipse.team.ui.mapping.SynchronizationStateTester;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonContentProvider;
import org.eclipse.ui.navigator.IPipelinedTreeContentProvider;
import org.eclipse.ui.navigator.PipelinedShapeModification;
import org.eclipse.ui.navigator.PipelinedViewerUpdate;
import org.modelbus.team.eclipse.model.ModelObject;
import org.modelbus.team.eclipse.model.ModelProject;
import org.modelbus.team.eclipse.model.ModelWorkspace;
import org.modelbus.team.eclipse.repository.ModelBusRepositoryPlugin;

public class ModelNavigatorContentProvider
extends BaseWorkbenchContentProvider
implements ICommonContentProvider,
IResourceChangeListener,
IPipelinedTreeContentProvider,
ITeamStateChangeListener {
    private ICommonContentExtensionSite extensionSite;
    private boolean isWorkspaceRoot;
    private Viewer viewer;
    private final boolean updateViewer;
    private SynchronizationStateTester syncStateTester;

    public ModelNavigatorContentProvider() {
        this.updateViewer = true;
    }

    public ModelNavigatorContentProvider(boolean updateViewer) {
        this.updateViewer = updateViewer;
    }

    public void init(ICommonContentExtensionSite aConfig) {
        this.extensionSite = aConfig;
        if (this.updateViewer) {
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
            this.syncStateTester = new SynchronizationStateTester();
            this.syncStateTester.getTeamStateProvider().addDecoratedStateChangeListener((ITeamStateChangeListener)this);
        }
    }

    public void dispose() {
        super.dispose();
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        if (this.syncStateTester != null) {
            this.syncStateTester.getTeamStateProvider().removeDecoratedStateChangeListener((ITeamStateChangeListener)this);
        }
    }

    public void restoreState(IMemento aMemento) {
    }

    public void saveState(IMemento aMemento) {
    }

    public ICommonContentExtensionSite getExtensionSite() {
        return this.extensionSite;
    }

    public Object[] getElements(Object element) {
        if (element instanceof IWorkspaceRoot) {
            this.isWorkspaceRoot = true;
            return super.getElements((Object)ModelObject.create((IResource)((IWorkspaceRoot)element)));
        }
        return super.getElements(element);
    }

    public Object getParent(Object element) {
        Object parent = super.getParent(element);
        if (this.isWorkspaceRoot && parent instanceof ModelWorkspace) {
            return ((ModelWorkspace)((Object)parent)).getResource();
        }
        return parent;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.viewer = viewer;
        super.inputChanged(viewer, oldInput, newInput);
    }

    public void teamStateChanged(ITeamStateChangeEvent event) {
        HashSet<ModelObject> refreshProjects = new HashSet<ModelObject>();
        IResource[] addedRoots = event.getAddedRoots();
        int i = 0;
        while (i < addedRoots.length) {
            IResource resource = addedRoots[i];
            if (this.isModelProject((IResource)resource.getProject())) {
                refreshProjects.add(ModelObject.create((IResource)resource.getProject()));
            }
            ++i;
        }
        IResource[] removedRoots = event.getRemovedRoots();
        int i2 = 0;
        while (i2 < removedRoots.length) {
            IResource resource = removedRoots[i2];
            if (this.isModelProject((IResource)resource.getProject())) {
                refreshProjects.add(ModelObject.create((IResource)resource.getProject()));
            }
            ++i2;
        }
        IResource[] changed = event.getChangedResources();
        int i3 = 0;
        while (i3 < changed.length) {
            IResource resource = changed[i3];
            if (this.isModelProject((IResource)resource.getProject())) {
                refreshProjects.add(ModelObject.create((IResource)resource.getProject()));
            }
            ++i3;
        }
        this.refreshProjects(refreshProjects.toArray(new ModelProject[refreshProjects.size()]));
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (this.viewer == null) {
            return;
        }
        IResourceDelta delta = event.getDelta();
        IResourceDelta[] children = delta.getAffectedChildren();
        boolean refreshAll = false;
        ArrayList<ModelObject> refreshProjects = new ArrayList<ModelObject>();
        int i = 0;
        while (i < children.length) {
            IResourceDelta childDelta = children[i];
            if (this.isModelProject(childDelta.getResource())) {
                if (this.isProjectChange(childDelta)) {
                    refreshAll = true;
                    break;
                }
                refreshProjects.add(ModelObject.create(childDelta.getResource()));
            }
            ++i;
        }
        if (refreshAll || !refreshProjects.isEmpty()) {
            if (refreshAll) {
                this.refreshViewer();
            } else {
                this.refreshProjects(refreshProjects.toArray(new ModelProject[refreshProjects.size()]));
            }
        }
    }

    private void refreshProjects(final ModelProject[] projects) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!ModelNavigatorContentProvider.this.getViewer().getControl().isDisposed()) {
                    int i = 0;
                    while (i < projects.length) {
                        ModelProject project = projects[i];
                        ((AbstractTreeViewer)ModelNavigatorContentProvider.this.getViewer()).refresh((Object)project, true);
                        ++i;
                    }
                }
            }
        });
    }

    private void refreshViewer() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!ModelNavigatorContentProvider.this.getViewer().getControl().isDisposed()) {
                    ModelNavigatorContentProvider.this.getViewer().refresh();
                }
            }
        });
    }

    private boolean isProjectChange(IResourceDelta childDelta) {
        return (childDelta.getFlags() & 0x84000) > 0;
    }

    private boolean isModelProject(IResource resource) {
        try {
            return ModelProject.isModProject(resource.getProject());
        }
        catch (CoreException e) {
            ModelBusRepositoryPlugin.log(e.getStatus());
            return false;
        }
    }

    Viewer getViewer() {
        return this.viewer;
    }

    public void getPipelinedChildren(Object aParent, Set theCurrentChildren) {
    }

    public void getPipelinedElements(Object anInput, Set theCurrentElements) {
        if (anInput instanceof IWorkspaceRoot) {
            ArrayList<ModelObject> newProjects = new ArrayList<ModelObject>();
            Iterator iter = theCurrentElements.iterator();
            while (iter.hasNext()) {
                Object element = iter.next();
                if (!(element instanceof IProject)) continue;
                IProject project = (IProject)element;
                try {
                    if (!ModelProject.isModProject(project)) continue;
                    iter.remove();
                    newProjects.add(ModelObject.create((IResource)project));
                }
                catch (CoreException e) {
                    ModelBusRepositoryPlugin.log(e.getStatus());
                }
            }
            theCurrentElements.addAll(newProjects);
        }
    }

    public Object getPipelinedParent(Object anObject, Object aSuggestedParent) {
        return aSuggestedParent;
    }

    public PipelinedShapeModification interceptAdd(PipelinedShapeModification anAddModification) {
        if (anAddModification.getParent() instanceof IWorkspaceRoot) {
            Iterator iter = anAddModification.getChildren().iterator();
            while (iter.hasNext()) {
                Object element = iter.next();
                if (!(element instanceof IProject)) continue;
                IProject project = (IProject)element;
                try {
                    if (!ModelProject.isModProject(project)) continue;
                    iter.remove();
                }
                catch (CoreException e) {
                    ModelBusRepositoryPlugin.log(e.getStatus());
                }
            }
        }
        return null;
    }

    public boolean interceptRefresh(PipelinedViewerUpdate aRefreshSynchronization) {
        return false;
    }

    public PipelinedShapeModification interceptRemove(PipelinedShapeModification aRemoveModification) {
        return aRemoveModification;
    }

    public boolean interceptUpdate(PipelinedViewerUpdate anUpdateSynchronization) {
        return false;
    }
}

