/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.model.ui;

import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.modelbus.team.eclipse.model.ModelFolder;
import org.modelbus.team.eclipse.model.ModelObject;
import org.modelbus.team.eclipse.model.ModelObjectDefinitionFile;
import org.modelbus.team.eclipse.model.ModelObjectElementFile;
import org.modelbus.team.eclipse.model.ModelProject;
import org.modelbus.team.eclipse.model.ModelWorkspace;
import org.modelbus.team.eclipse.repository.ModelBusRepositoryPlugin;
import org.osgi.framework.Bundle;

public class ModelWorkbenchAdapter
implements IWorkbenchAdapter {
    private final String ICON_PATH = "$nl$/icons/full/";

    public Object[] getChildren(Object o) {
        if (o instanceof ModelObject) {
            ModelObject mo = (ModelObject)((Object)o);
            try {
                return mo.getChildren();
            }
            catch (CoreException e) {
                ModelBusRepositoryPlugin.log(e.getStatus());
            }
        }
        return new Object[0];
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        if (object instanceof ModelProject) {
            return this.createImageDescriptor("obj/prj_obj.gif");
        }
        if (object instanceof ModelWorkspace) {
            return this.createImageDescriptor("obj/root_obj.gif");
        }
        if (object instanceof ModelFolder) {
            return this.createImageDescriptor("obj/fldr_obj.gif");
        }
        if (object instanceof ModelObjectDefinitionFile) {
            return this.createImageDescriptor("obj/mod_obj.gif");
        }
        if (object instanceof ModelObjectElementFile) {
            return this.createImageDescriptor("obj/moe_obj.gif");
        }
        return null;
    }

    public String getLabel(Object o) {
        if (o instanceof ModelObject) {
            ModelObject mo = (ModelObject)((Object)o);
            return mo.getName();
        }
        return null;
    }

    public Object getParent(Object o) {
        if (o instanceof ModelObject) {
            ModelObject mo = (ModelObject)((Object)o);
            return mo.getParent();
        }
        return null;
    }

    private ImageDescriptor createImageDescriptor(String id) {
        URL url = FileLocator.find((Bundle)ModelBusRepositoryPlugin.getPlugin().getBundle(), (IPath)new Path("$nl$/icons/full/" + id), null);
        return ImageDescriptor.createFromURL((URL)url);
    }
}

