/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.model.ui.mapping;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.ui.mapping.SynchronizationLabelProvider;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.modelbus.team.eclipse.model.ModelObjectDefinitionFile;
import org.modelbus.team.eclipse.model.ModelObjectElementFile;
import org.modelbus.team.eclipse.model.ModelResource;
import org.modelbus.team.eclipse.model.ui.ModelNavigatorLabelProvider;
import org.modelbus.team.eclipse.repository.ModelBusRepositoryPlugin;

public class ModelSyncLabelProvider
extends SynchronizationLabelProvider {
    private ModelNavigatorLabelProvider delegate;

    public void init(ICommonContentExtensionSite site) {
        super.init(site);
        this.delegate = new ModelNavigatorLabelProvider();
        this.delegate.init(site);
    }

    public void dispose() {
        super.dispose();
        if (this.delegate != null) {
            this.delegate.dispose();
        }
    }

    protected ILabelProvider getDelegateLabelProvider() {
        return this.delegate;
    }

    protected IDiff getDiff(Object element) {
        if (element instanceof ModelResource) {
            ModelResource mr = (ModelResource)((Object)element);
            return this.getContext().getDiffTree().getDiff(mr.getResource());
        }
        return super.getDiff(element);
    }

    protected boolean isIncludeOverlays() {
        return true;
    }

    protected boolean isBusy(Object element) {
        if (element instanceof ModelResource) {
            ModelResource mr = (ModelResource)((Object)element);
            boolean busy = this.getContext().getDiffTree().getProperty(mr.getResource().getFullPath(), 1);
            if (!busy && mr instanceof ModelObjectDefinitionFile) {
                ModelObjectDefinitionFile modFile = (ModelObjectDefinitionFile)mr;
                try {
                    ModelObjectElementFile[] children = modFile.getModelObjectElementFiles();
                    int i = 0;
                    while (i < children.length) {
                        ModelObjectElementFile file = children[i];
                        busy = this.getContext().getDiffTree().getProperty(file.getResource().getFullPath(), 1);
                        if (!busy) {
                            ++i;
                            continue;
                        }
                        break;
                    }
                }
                catch (CoreException e) {
                    ModelBusRepositoryPlugin.log(e.getStatus());
                }
            }
            return busy;
        }
        return super.isBusy(element);
    }

    protected boolean hasDecendantConflicts(Object element) {
        if (element instanceof ModelResource) {
            ModelResource mr = (ModelResource)((Object)element);
            boolean conflict = this.getContext().getDiffTree().getProperty(mr.getResource().getFullPath(), 2);
            if (!conflict && mr instanceof ModelObjectDefinitionFile) {
                ModelObjectDefinitionFile modFile = (ModelObjectDefinitionFile)mr;
                try {
                    ModelObjectElementFile[] children = modFile.getModelObjectElementFiles();
                    int i = 0;
                    while (i < children.length) {
                        ModelObjectElementFile file = children[i];
                        conflict = this.getContext().getDiffTree().getProperty(file.getResource().getFullPath(), 2);
                        if (!conflict) {
                            ++i;
                            continue;
                        }
                        break;
                    }
                }
                catch (CoreException e) {
                    ModelBusRepositoryPlugin.log(e.getStatus());
                }
            }
            return conflict;
        }
        return super.hasDecendantConflicts(element);
    }
}

