/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.repository;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileModificationValidator;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.modelbus.team.eclipse.repository.ModelBusRepositoryOperations;
import org.modelbus.team.eclipse.repository.ModelBusRepositoryProvider;

public final class FileModificationValidator
implements IFileModificationValidator {
    private ModelBusRepositoryOperations operations;

    public FileModificationValidator(RepositoryProvider provider) {
        this.operations = ((ModelBusRepositoryProvider)provider).getOperations();
    }

    private IStatus checkout(IResource[] resources) {
        try {
            this.operations.checkout(resources, 2, null);
        }
        catch (TeamException e) {
            return new Status(4, "org.modelbus.team.eclipse.repository", 0, e.getLocalizedMessage(), (Throwable)e);
        }
        return Status.OK_STATUS;
    }

    public IStatus validateEdit(IFile[] files, Object context) {
        ArrayList<IFile> toBeCheckedOut = new ArrayList<IFile>();
        int i = 0;
        while (i < files.length) {
            if (!this.operations.isCheckedOut((IResource)files[i])) {
                toBeCheckedOut.add(files[i]);
            }
            ++i;
        }
        return this.checkout(toBeCheckedOut.toArray(new IResource[toBeCheckedOut.size()]));
    }

    public IStatus validateSave(IFile file) {
        if (file.isReadOnly()) {
            return this.checkout(new IResource[]{file});
        }
        return Status.OK_STATUS;
    }
}

