/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.repository;

import java.util.HashMap;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.team.core.RepositoryProvider;
import org.modelbus.core.lib.IRepositoryHelper;
import org.modelbus.core.lib.ModelBusCoreLib;
import org.modelbus.preferences.dependencies.DependenciesPreferencePlugin;
import org.modelbus.team.eclipse.repository.ModelBusRepositoryProvider;

public class ModelBusRepositoryHelper
implements IResourceChangeListener,
IPropertyChangeListener {
    private static ModelBusRepositoryHelper modelBusRepositoryHelper;
    private static IRepositoryHelper repositoryHelper;
    private static boolean oldCheckDependencies;
    private static String[] oldExtensions;
    private static HashMap<String, String> oldlocal2remoteMap;

    static {
        oldCheckDependencies = false;
        oldExtensions = new String[0];
    }

    private ModelBusRepositoryHelper() {
    }

    public static ModelBusRepositoryHelper getModelBusRepositoryHelper() {
        if (modelBusRepositoryHelper == null) {
            modelBusRepositoryHelper = new ModelBusRepositoryHelper();
        }
        return modelBusRepositoryHelper;
    }

    public static IRepositoryHelper getRepositoryHelper() {
        if (repositoryHelper == null && (repositoryHelper = ModelBusCoreLib.getRepositoryHelper()) != null) {
            oldlocal2remoteMap = ModelBusRepositoryHelper._getLocal2RemoteMap();
            repositoryHelper.setProjectPathMap(oldlocal2remoteMap);
            oldCheckDependencies = ModelBusRepositoryHelper._getCheckDependencies();
            repositoryHelper.setEnableDependencies(oldCheckDependencies);
            oldExtensions = ModelBusRepositoryHelper._getExtensions();
            repositoryHelper.setModelExtensions(oldExtensions);
        }
        return repositoryHelper;
    }

    private static boolean _getCheckDependencies() {
        boolean checkDependencies = DependenciesPreferencePlugin.getDefault().getPreferenceStore().getBoolean("CHECK_DEPENDENCIES_booleanPreference");
        return checkDependencies;
    }

    private static String[] _getExtensions() {
        String[] extensions = DependenciesPreferencePlugin.getDefault().getExtensionPreference();
        return extensions;
    }

    private static HashMap<String, String> _getLocal2RemoteMap() {
        HashMap<String, String> local2remoteMap = new HashMap<String, String>();
        IProject[] localProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < localProjects.length) {
            RepositoryProvider provider = RepositoryProvider.getProvider((IProject)localProjects[i], (String)"org.modelbus.team.eclipse.repository.ModelBusRepositoryProvider");
            if (provider != null) {
                ModelBusRepositoryProvider modelbusProvider = (ModelBusRepositoryProvider)provider;
                String remoteLocation = modelbusProvider.getRepositoryPath((IResource)localProjects[i]);
                String localLocation = localProjects[i].getLocationURI().toString();
                local2remoteMap.put(localLocation, remoteLocation);
            }
            ++i;
        }
        return local2remoteMap;
    }

    public static HashMap<String, String> getLocal2RemoteMap() {
        if (oldlocal2remoteMap == null) {
            oldlocal2remoteMap = new HashMap();
        }
        return oldlocal2remoteMap;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (event.getType() == 1) {
            IRepositoryHelper repositoryHelper = ModelBusRepositoryHelper.getRepositoryHelper();
            HashMap<String, String> local2RemoteMap = ModelBusRepositoryHelper.getLocal2RemoteMap();
            if (repositoryHelper != null) {
                IResourceDelta[] resource;
                IResourceDelta delta = event.getDelta();
                IResourceDelta[] iResourceDeltaArray = resource = delta.getAffectedChildren();
                int n = resource.length;
                int n2 = 0;
                while (n2 < n) {
                    IResourceDelta iResourceDelta = iResourceDeltaArray[n2];
                    IResource iResource = iResourceDelta.getResource();
                    if (iResource.getType() == 4) {
                        String localLocation;
                        String remoteLocation;
                        ModelBusRepositoryProvider modelbusProvider;
                        RepositoryProvider provider;
                        if (iResourceDelta.getKind() == 1) {
                            provider = RepositoryProvider.getProvider((IProject)((IProject)iResource), (String)"org.modelbus.team.eclipse.repository.ModelBusRepositoryProvider");
                            if (provider != null) {
                                modelbusProvider = (ModelBusRepositoryProvider)provider;
                                remoteLocation = modelbusProvider.getRepositoryPath((IResource)((IProject)iResource));
                                localLocation = iResource.getLocationURI().toString();
                                local2RemoteMap.put(localLocation, remoteLocation);
                                repositoryHelper.setProjectPathMap(local2RemoteMap);
                            }
                        } else if (iResourceDelta.getKind() == 2) {
                            String localLocation2;
                            provider = RepositoryProvider.getProvider((IProject)((IProject)iResource), (String)"org.modelbus.team.eclipse.repository.ModelBusRepositoryProvider");
                            if (provider != null) {
                                localLocation2 = iResource.getLocationURI().toString();
                                local2RemoteMap.remove(localLocation2);
                                repositoryHelper.setProjectPathMap(local2RemoteMap);
                            } else {
                                localLocation2 = "file:/" + ResourcesPlugin.getWorkspace().getRoot().getLocation().toString() + iResource.getFullPath().toString();
                                local2RemoteMap.remove(localLocation2);
                                repositoryHelper.setProjectPathMap(local2RemoteMap);
                            }
                        } else if (iResourceDelta.getKind() == 4 && (provider = RepositoryProvider.getProvider((IProject)((IProject)iResource), (String)"org.modelbus.team.eclipse.repository.ModelBusRepositoryProvider")) != null) {
                            modelbusProvider = (ModelBusRepositoryProvider)provider;
                            remoteLocation = modelbusProvider.getRepositoryPath((IResource)((IProject)iResource));
                            localLocation = iResource.getLocationURI().toString();
                            local2RemoteMap.put(localLocation, remoteLocation);
                            repositoryHelper.setProjectPathMap(local2RemoteMap);
                        }
                    }
                    ++n2;
                }
            }
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        IRepositoryHelper repositoryHelper = ModelBusRepositoryHelper.getRepositoryHelper();
        if (repositoryHelper != null) {
            if (event.getProperty().equals("CHECK_DEPENDENCIES_booleanPreference")) {
                oldCheckDependencies = (Boolean)event.getNewValue();
                repositoryHelper.setEnableDependencies(oldCheckDependencies);
            } else if (event.getProperty().equals("DEPENDENCIES_extensions_preference")) {
                String newValue = event.getNewValue().toString();
                oldExtensions = this.convert(newValue);
                repositoryHelper.setModelExtensions(oldExtensions);
            }
        }
    }

    private String[] convert(String preferenceValue) {
        StringTokenizer tokenizer = new StringTokenizer(preferenceValue, ";");
        int tokenCount = tokenizer.countTokens();
        String[] elements = new String[tokenCount];
        int i = 0;
        while (i < tokenCount) {
            elements[i] = tokenizer.nextToken();
            ++i;
        }
        return elements;
    }
}

