/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.repository;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.core.variants.IResourceVariantComparator;
import org.eclipse.team.core.variants.ThreeWaySynchronizer;
import org.modelbus.core.lib.IRepositoryHelper;
import org.modelbus.dosgi.repository.descriptor.ConstraintViolationException;
import org.modelbus.dosgi.repository.descriptor.InvalidRevisionException;
import org.modelbus.dosgi.repository.descriptor.InvalidValueException;
import org.modelbus.dosgi.repository.descriptor.LockedException;
import org.modelbus.dosgi.repository.descriptor.NonExistingResourceException;
import org.modelbus.dosgi.repository.descriptor.PathFileContentMapEntry;
import org.modelbus.dosgi.repository.descriptor.RepositoryAuthentificationException;
import org.modelbus.dosgi.repository.descriptor.RepositoryDirEntry;
import org.modelbus.dosgi.repository.descriptor.RepositoryRuntimeException;
import org.modelbus.dosgi.repository.descriptor.UnresolvedReferencesException;
import org.modelbus.preferences.dependencies.DependenciesPreferencePlugin;
import org.modelbus.team.eclipse.repository.ModelBusRepositoryHelper;
import org.modelbus.team.eclipse.repository.ModelBusRepositoryPlugin;
import org.modelbus.team.eclipse.repository.ModelBusRepositoryProvider;
import org.modelbus.team.eclipse.repository.Policy;
import org.modelbus.team.eclipse.repository.UserSessionHelper;
import org.modelbus.team.eclipse.repository.subscriber.ModelBusRepositoryResourceVariant;
import org.modelbus.team.eclipse.repository.subscriber.ModelBusRepositorySubscriber;
import org.modelbus.team.eclipse.repository.subscriber.ModelBusThreeWaySynchronizer;
import org.modelbus.team.eclipse.repository.ui.LockHelper;

public class ModelBusRepositoryOperations {
    private ModelBusRepositoryProvider provider;
    private List<PathFileContentMapEntry> createFileMap;
    private List<PathFileContentMapEntry> checkInFileMap;
    private List<String> folderPaths;
    private List<String> deletionPaths;
    private List<IContainer> containerToSetBaseBytes;
    private List<IFile> filesToSetBaseBytes;
    private Map<IFile, URI> modelsToCheckinMap;
    private List<IResource> resourcesToDelete;

    ModelBusRepositoryOperations(ModelBusRepositoryProvider provider) {
        this.provider = provider;
    }

    public void get(IResource[] resources, int depth, boolean overrideOutgoing, IProgressMonitor progress) throws TeamException, RepositoryAuthentificationException, NonExistingResourceException, IOException, InvalidRevisionException {
        try {
            progress = Policy.monitorFor(progress);
            progress.beginTask(Policy.bind("GetAction.working"), 100);
            ModelBusRepositorySubscriber.getInstance().refresh(resources, depth, (IProgressMonitor)new SubProgressMonitor(progress, 30));
            this.internalGet(resources, depth, overrideOutgoing, (IProgressMonitor)new SubProgressMonitor(progress, 70));
        }
        finally {
            progress.done();
        }
    }

    public void get(ResourceTraversal[] traversals, boolean overrideOutgoing, IProgressMonitor monitor) throws TeamException, RepositoryAuthentificationException, NonExistingResourceException, IOException, InvalidRevisionException {
        try {
            monitor = Policy.monitorFor(monitor);
            monitor.beginTask(null, 100 * traversals.length);
            int i = 0;
            while (i < traversals.length) {
                ResourceTraversal traversal = traversals[i];
                this.get(traversal.getResources(), traversal.getDepth(), overrideOutgoing, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
                ++i;
            }
        }
        finally {
            monitor.done();
        }
    }

    public void checkout(IResource[] resources, int depth, IProgressMonitor progress) throws TeamException {
        try {
            try {
                progress = Policy.monitorFor(progress);
                progress.beginTask(Policy.bind("FileSystemSimpleAccessOperations.1"), resources.length);
                int i = 0;
                while (i < resources.length) {
                    Policy.checkCanceled(progress);
                    resources[i].accept(new IResourceVisitor(){

                        public boolean visit(IResource resource) throws CoreException {
                            if (resource.getType() == 1) {
                                resource.setReadOnly(false);
                            }
                            return true;
                        }
                    }, depth, false);
                    progress.worked(1);
                    ++i;
                }
            }
            catch (CoreException e) {
                throw TeamException.asTeamException((CoreException)e);
            }
        }
        finally {
            progress.done();
        }
    }

    public void checkin(IResource[] resources, int depth, boolean overrideIncoming, IProgressMonitor progress, String commitMessage) throws TeamException, RepositoryAuthentificationException, NonExistingResourceException, LockedException, InvalidValueException, ConstraintViolationException, UnresolvedReferencesException, IOException, InvalidRevisionException {
        try {
            progress = Policy.monitorFor(progress);
            progress.beginTask(Policy.bind("PutAction.working"), 100);
            ModelBusRepositorySubscriber.getInstance().refresh(resources, depth, (IProgressMonitor)new SubProgressMonitor(progress, 5));
            this.createFileMap = new ArrayList<PathFileContentMapEntry>();
            this.checkInFileMap = new ArrayList<PathFileContentMapEntry>();
            this.folderPaths = new ArrayList<String>();
            this.deletionPaths = new ArrayList<String>();
            this.containerToSetBaseBytes = new ArrayList<IContainer>();
            this.filesToSetBaseBytes = new ArrayList<IFile>();
            this.modelsToCheckinMap = new HashMap<IFile, URI>();
            this.resourcesToDelete = new ArrayList<IResource>();
            this.internalPut(resources, depth, overrideIncoming, (IProgressMonitor)new SubProgressMonitor(progress, 5), commitMessage);
            IRepositoryHelper repositoryHelper = ModelBusRepositoryHelper.getRepositoryHelper();
            if (!(this.createFileMap.isEmpty() && this.checkInFileMap.isEmpty() && this.folderPaths.isEmpty() && this.deletionPaths.isEmpty())) {
                this.commitFilesInBatch(repositoryHelper, commitMessage, (IProgressMonitor)new SubProgressMonitor(progress, 20));
            }
            ThreeWaySynchronizer synchronizer = ModelBusRepositorySubscriber.getInstance().getSynchronizer();
            if (!this.resourcesToDelete.isEmpty()) {
                this.flushSynchronizerForDeletedResources(synchronizer);
            }
            if (!this.containerToSetBaseBytes.isEmpty()) {
                this.setBaseBytesForContainers(synchronizer);
            }
            if (!this.filesToSetBaseBytes.isEmpty()) {
                this.setBaseBytesForCommittedFiles(synchronizer);
            }
            if (!this.modelsToCheckinMap.isEmpty()) {
                this.commitModels(repositoryHelper, synchronizer, commitMessage, (IProgressMonitor)new SubProgressMonitor(progress, 70));
            }
        }
        finally {
            progress.done();
        }
    }

    private void commitFilesInBatch(IRepositoryHelper repositoryHelper, String commitMessage, IProgressMonitor progress) throws RepositoryRuntimeException, InvalidValueException, RepositoryAuthentificationException, LockedException {
        try {
            progress = Policy.monitorFor(progress);
            progress.beginTask(Policy.bind("PutAction.working"), -1);
            Policy.checkCanceled(progress);
            progress.subTask("committing files...");
            repositoryHelper.commit(UserSessionHelper.getSession(), this.createFileMap, this.checkInFileMap, this.folderPaths, this.deletionPaths, commitMessage);
            progress.worked(1);
        }
        finally {
            progress.done();
        }
    }

    private void flushSynchronizerForDeletedResources(ThreeWaySynchronizer synchronizer) throws TeamException {
        for (IResource resource : this.resourcesToDelete) {
            if (resource instanceof IFolder) {
                synchronizer.flush(resource, 2);
                continue;
            }
            synchronizer.flush(resource, 0);
        }
    }

    private void setBaseBytesForContainers(ThreeWaySynchronizer synchronizer) throws TeamException, RepositoryAuthentificationException, NonExistingResourceException, IOException, InvalidRevisionException {
        for (IContainer container : this.containerToSetBaseBytes) {
            if (!container.exists()) continue;
            ModelBusRepositoryResourceVariant remote = (ModelBusRepositoryResourceVariant)this.provider.getResourceVariant((IResource)container);
            synchronizer.setBaseBytes((IResource)container, remote.asBytes());
            ((ModelBusThreeWaySynchronizer)synchronizer).setWorkingCopyRevision((IResource)container, remote.getRevision());
        }
    }

    private void setBaseBytesForCommittedFiles(ThreeWaySynchronizer synchronizer) throws RepositoryAuthentificationException, NonExistingResourceException, TeamException, IOException, InvalidRevisionException {
        for (IFile file : this.filesToSetBaseBytes) {
            ModelBusRepositoryResourceVariant remote = this.getResourceVariant((IResource)file);
            if (remote != null) {
                synchronizer.setBaseBytes((IResource)file, remote.asBytes());
                ((ModelBusThreeWaySynchronizer)synchronizer).setWorkingCopyRevision((IResource)file, remote.getRevision());
                continue;
            }
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                FileInputStream fileInputStream = new FileInputStream(file.getLocation().toFile());
                byte[] buffer = new byte[16384];
                int len = fileInputStream.read(buffer);
                while (len > 0) {
                    byteArrayOutputStream.write(buffer, 0, len);
                    len = fileInputStream.read(buffer);
                }
                fileInputStream.close();
                synchronizer.setBaseBytes((IResource)file, byteArrayOutputStream.toByteArray());
                ((ModelBusThreeWaySynchronizer)synchronizer).setWorkingCopyRevision((IResource)file, "-1");
            }
            catch (IOException e) {
                throw ModelBusRepositoryPlugin.wrapException(e);
            }
        }
    }

    private void commitModels(IRepositoryHelper repositoryHelper, ThreeWaySynchronizer synchronizer, String commitMessage, IProgressMonitor progress) throws TeamException, RepositoryAuthentificationException, NonExistingResourceException, IOException, InvalidValueException, ConstraintViolationException, LockedException, UnresolvedReferencesException, InvalidRevisionException {
        try {
            progress = Policy.monitorFor(progress);
            progress.beginTask(Policy.bind("PutAction.working"), -1);
            progress.subTask("committing models...");
            Iterator<Map.Entry<IFile, URI>> iterator = this.modelsToCheckinMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Policy.checkCanceled(progress);
                Map.Entry<IFile, URI> entry = iterator.next();
                ArrayList parentContainers = new ArrayList();
                IFile localFile = entry.getKey();
                progress.subTask("committing " + localFile.getName() + "...");
                ResourceSetImpl resourceSet = new ResourceSetImpl();
                URI localUri = URI.createFileURI((String)localFile.getLocation().toString());
                Resource resource = resourceSet.createResource(localUri);
                resource.load(Collections.EMPTY_MAP);
                URI remoteUri = entry.getValue();
                resource.setURI(remoteUri);
                repositoryHelper.checkInModel(UserSessionHelper.getSession(), resource, localUri, Collections.EMPTY_MAP, commitMessage);
                ModelBusRepositoryResourceVariant remote = this.getResourceVariant((IResource)localFile);
                if (remote != null) {
                    synchronizer.setBaseBytes((IResource)localFile, remote.asBytes());
                    ((ModelBusThreeWaySynchronizer)synchronizer).setWorkingCopyRevision((IResource)localFile, remote.getRevision());
                } else {
                    try {
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                        FileInputStream fileInputStream = new FileInputStream(localFile.getLocation().toFile());
                        byte[] buffer = new byte[16384];
                        int len = fileInputStream.read(buffer);
                        while (len > 0) {
                            byteArrayOutputStream.write(buffer, 0, len);
                            len = fileInputStream.read(buffer);
                        }
                        fileInputStream.close();
                        synchronizer.setBaseBytes((IResource)localFile, byteArrayOutputStream.toByteArray());
                        RepositoryDirEntry dirEntry = repositoryHelper.getInfo(UserSessionHelper.getSession(), remoteUri, "-1");
                        ((ModelBusThreeWaySynchronizer)synchronizer).setWorkingCopyRevision((IResource)localFile, dirEntry.getRevision());
                    }
                    catch (IOException e) {
                        throw ModelBusRepositoryPlugin.wrapException(e);
                    }
                }
                List filesToCheckin = repositoryHelper.getFilesToCheckin();
                for (String filePath : filesToCheckin) {
                    java.net.URI fileLocation = java.net.URI.create(filePath);
                    java.net.URI rooturi = ResourcesPlugin.getWorkspace().getRoot().getLocationURI();
                    if (localFile.getLocationURI().equals(fileLocation)) continue;
                    fileLocation = rooturi.relativize(fileLocation);
                    Path path = new Path(fileLocation.toString());
                    IFile ifile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
                    ModelBusRepositoryResourceVariant variant = this.getResourceVariant((IResource)ifile);
                    if (variant == null) continue;
                    synchronizer.setBaseBytes((IResource)ifile, variant.asBytes());
                    ((ModelBusThreeWaySynchronizer)synchronizer).setWorkingCopyRevision((IResource)ifile, variant.getRevision());
                    this.getAllParents((IResource)ifile, parentContainers);
                }
                for (Object ctr : parentContainers) {
                    if (!synchronizer.isLocallyModified((IResource)ctr)) continue;
                    synchronizer.setBaseBytes((IResource)ctr, new byte[0]);
                    ((ModelBusThreeWaySynchronizer)synchronizer).setWorkingCopyRevision((IResource)ctr, "-1");
                }
                progress.worked(1);
            }
        }
        finally {
            progress.done();
        }
    }

    public void checkin(ResourceTraversal[] traversals, boolean overrideIncoming, IProgressMonitor monitor, String commitMessage) throws TeamException, RepositoryAuthentificationException, NonExistingResourceException, LockedException, InvalidValueException, ConstraintViolationException, UnresolvedReferencesException, IOException, InvalidRevisionException {
        try {
            monitor = Policy.monitorFor(monitor);
            monitor.beginTask(null, 100 * traversals.length);
            int i = 0;
            while (i < traversals.length) {
                ResourceTraversal traversal = traversals[i];
                this.checkin(traversal.getResources(), traversal.getDepth(), overrideIncoming, (IProgressMonitor)new SubProgressMonitor(monitor, 100), commitMessage);
                ++i;
            }
        }
        finally {
            monitor.done();
        }
    }

    public boolean isCheckedOut(IResource resource) {
        if (resource.getType() != 1) {
            return true;
        }
        return !resource.isReadOnly();
    }

    private ModelBusRepositoryResourceVariant getResourceVariant(IResource resource) throws RepositoryAuthentificationException, NonExistingResourceException, IOException, InvalidRevisionException {
        return (ModelBusRepositoryResourceVariant)this.provider.getResourceVariant(resource);
    }

    private void internalGet(IResource[] resources, int depth, boolean overrideOutgoing, IProgressMonitor progress) throws TeamException, RepositoryAuthentificationException, NonExistingResourceException, IOException, InvalidRevisionException {
        progress.beginTask(Policy.bind("GetAction.working"), -1);
        int i = 0;
        while (i < resources.length) {
            Policy.checkCanceled(progress);
            if (resources[i].getType() == 1) {
                this.internalGet((IFile)resources[i], overrideOutgoing, progress);
            } else if (depth != 0) {
                this.internalGet((IContainer)resources[i], depth, overrideOutgoing, progress);
            }
            progress.worked(1);
            ++i;
        }
    }

    private void internalGet(IContainer container, int depth, boolean overrideOutgoing, IProgressMonitor progress) throws TeamException, RepositoryAuthentificationException, NonExistingResourceException, IOException, InvalidRevisionException {
        try {
            IResource[] children;
            ThreeWaySynchronizer synchronizer = ModelBusRepositorySubscriber.getInstance().getSynchronizer();
            ArrayList<IFolder> toDelete = new ArrayList<IFolder>();
            if (container.getType() == 2) {
                IFolder folder = (IFolder)container;
                ModelBusRepositoryResourceVariant remote = this.getResourceVariant((IResource)container);
                if (!folder.exists() && remote != null) {
                    folder.create(false, true, progress);
                    synchronizer.setBaseBytes((IResource)folder, remote.asBytes());
                    ((ModelBusThreeWaySynchronizer)synchronizer).setWorkingCopyRevision((IResource)folder, remote.getRevision());
                } else if (folder.exists() && remote == null) {
                    toDelete.add(folder);
                }
            }
            if ((children = synchronizer.members((IResource)container)).length > 0) {
                this.internalGet(children, depth == 2 ? 2 : 0, overrideOutgoing, progress);
            }
            for (IFolder folder : toDelete) {
                if (folder.members().length != 0) continue;
                folder.delete(false, true, progress);
                synchronizer.flush((IResource)folder, 2);
            }
        }
        catch (CoreException e) {
            throw TeamException.asTeamException((CoreException)e);
        }
    }

    private void internalGet(IFile localFile, boolean overrideOutgoing, IProgressMonitor progress) throws TeamException, RepositoryAuthentificationException, NonExistingResourceException, IOException, InvalidRevisionException {
        ThreeWaySynchronizer synchronizer = ModelBusRepositorySubscriber.getInstance().getSynchronizer();
        IResourceVariantComparator comparator = ModelBusRepositorySubscriber.getInstance().getResourceComparator();
        ModelBusRepositoryResourceVariant remote = this.getResourceVariant((IResource)localFile);
        byte[] baseBytes = synchronizer.getBaseBytes((IResource)localFile);
        IResourceVariant base = this.provider.getLocalResourceVariant((IResource)localFile, baseBytes);
        if (!synchronizer.hasSyncBytes((IResource)localFile) || this.isLocallyModified(localFile) && !overrideOutgoing) {
            return;
        }
        if (base != null && remote == null) {
            try {
                synchronizer.flush((IResource)localFile, 0);
                localFile.delete(false, true, progress);
            }
            catch (CoreException e) {
                throw TeamException.asTeamException((CoreException)e);
            }
            return;
        }
        if (!synchronizer.isLocallyModified((IResource)localFile) && base != null && remote != null && comparator.compare(base, (IResourceVariant)remote)) {
            return;
        }
        try {
            InputStream source = null;
            try {
                source = remote.getContents();
                if (localFile.exists()) {
                    localFile.setContents(source, false, false, progress);
                } else {
                    localFile.create(source, false, progress);
                }
            }
            finally {
                if (source != null) {
                    source.close();
                }
            }
            synchronizer.setBaseBytes((IResource)localFile, remote.asBytes());
            ((ModelBusThreeWaySynchronizer)synchronizer).setWorkingCopyRevision((IResource)localFile, remote.getRevision());
        }
        catch (IOException e) {
            throw ModelBusRepositoryPlugin.wrapException(e);
        }
        catch (CoreException e) {
            throw ModelBusRepositoryPlugin.wrapException(e);
        }
    }

    private void internalPut(IResource[] resources, int depth, boolean overrideIncoming, IProgressMonitor progress, String commitMessage) throws TeamException, RepositoryAuthentificationException, NonExistingResourceException, LockedException, InvalidValueException, ConstraintViolationException, UnresolvedReferencesException, IOException, InvalidRevisionException {
        progress = Policy.monitorFor(progress);
        progress.beginTask(Policy.bind("PutAction.working"), -1);
        int i = 0;
        while (i < resources.length) {
            Policy.checkCanceled(progress);
            if (resources[i].getType() == 1) {
                this.internalPut((IFile)resources[i], overrideIncoming, progress, commitMessage);
            } else if (depth > 0) {
                this.internalPut((IContainer)resources[i], depth, overrideIncoming, progress, commitMessage);
            }
            progress.worked(1);
            ++i;
        }
        progress.done();
    }

    public void lock(IFile localFile, IProgressMonitor progress) throws RepositoryAuthentificationException, InvalidValueException, NonExistingResourceException, LockedException {
        String remoteFileLocation = this.provider.getRepositoryPath((IResource)localFile);
        URI remoteFileURI = URI.createURI((String)remoteFileLocation);
        IRepositoryHelper repositoryHelper = ModelBusRepositoryHelper.getRepositoryHelper();
        repositoryHelper.lock(UserSessionHelper.getSession(), remoteFileURI);
    }

    public void unlock(IFile localFile, IProgressMonitor progress) throws RepositoryAuthentificationException, LockedException, NonExistingResourceException {
        String remoteFileLocation = this.provider.getRepositoryPath((IResource)localFile);
        URI remoteFileURI = URI.createURI((String)remoteFileLocation);
        IRepositoryHelper repositoryHelper = ModelBusRepositoryHelper.getRepositoryHelper();
        repositoryHelper.unlock(UserSessionHelper.getSession(), remoteFileURI);
    }

    private void getAllParents(IResource iResource, List folders) throws TeamException {
        IContainer parent = iResource.getParent();
        while (parent != null) {
            if (!folders.contains(parent)) {
                folders.add(parent);
            }
            parent = parent.getParent();
        }
    }

    private boolean internalPut(IFile localFile, boolean overrideIncoming, IProgressMonitor progress, String commitMessage) throws TeamException, RepositoryAuthentificationException, NonExistingResourceException, LockedException, InvalidValueException, ConstraintViolationException, UnresolvedReferencesException, IOException, InvalidRevisionException {
        String lockUser = LockHelper.getLockHelper().objectLockedBy(localFile);
        if (lockUser != null && !lockUser.equals(UserSessionHelper.getPropertyUserName())) {
            return false;
        }
        ThreeWaySynchronizer synchronizer = ModelBusRepositorySubscriber.getInstance().getSynchronizer();
        IResourceVariantComparator comparator = ModelBusRepositorySubscriber.getInstance().getResourceComparator();
        ModelBusRepositoryResourceVariant remote = this.getResourceVariant((IResource)localFile);
        byte[] baseBytes = synchronizer.getBaseBytes((IResource)localFile);
        IResourceVariant base = this.provider.getLocalResourceVariant((IResource)localFile, baseBytes);
        if (base == null && remote != null && !overrideIncoming) {
            return false;
        }
        if (base != null && remote == null) {
            if (!localFile.exists()) {
                synchronizer.flush((IResource)localFile, 0);
            } else if (!overrideIncoming) {
                return false;
            }
        } else if (base != null && remote != null) {
            boolean same = comparator.compare(base, (IResourceVariant)remote);
            if (!this.isLocallyModified(localFile) && same) {
                return true;
            }
            if (!same && !overrideIncoming) {
                return false;
            }
        }
        String remoteFileLocation = this.provider.getRepositoryPath((IResource)localFile);
        if (!localFile.exists()) {
            ModelBusRepositoryHelper.getRepositoryHelper();
            this.deletionPaths.add(remoteFileLocation);
            this.resourcesToDelete.add((IResource)localFile);
        } else {
            ArrayList<IContainer> parentContainers = new ArrayList<IContainer>();
            IContainer parent = localFile.getParent();
            while (parent != null) {
                parentContainers.add(parent);
                parent = parent.getParent();
            }
            boolean checkDependencies = DependenciesPreferencePlugin.getDefault().getPreferenceStore().getBoolean("CHECK_DEPENDENCIES_booleanPreference");
            IRepositoryHelper repositoryHelper = ModelBusRepositoryHelper.getRepositoryHelper();
            URI remoteFileURI = URI.createURI((String)remoteFileLocation);
            if (checkDependencies && this.isExtensionForDependenciesSupport(localFile.getFileExtension())) {
                this.modelsToCheckinMap.put(localFile, remoteFileURI);
            } else {
                PathFileContentMapEntry pathFileContentMapEntry = new PathFileContentMapEntry();
                File file = localFile.getLocation().toFile();
                FileDataSource fileDataSource = new FileDataSource(file);
                DataHandler dataHandler = new DataHandler((DataSource)fileDataSource);
                pathFileContentMapEntry.setPath(remoteFileLocation);
                pathFileContentMapEntry.setFileContent(dataHandler);
                if (repositoryHelper.exists(UserSessionHelper.getSession(), remoteFileURI, "-1")) {
                    this.checkInFileMap.add(pathFileContentMapEntry);
                } else {
                    this.createFileMap.add(pathFileContentMapEntry);
                }
                this.filesToSetBaseBytes.add(localFile);
            }
            for (Object e : parentContainers) {
                if (!synchronizer.isLocallyModified((IResource)e)) continue;
                synchronizer.setBaseBytes((IResource)e, new byte[0]);
                ((ModelBusThreeWaySynchronizer)synchronizer).setWorkingCopyRevision((IResource)e, "-1");
            }
        }
        return true;
    }

    private boolean isLocallyModified(IFile localFile) throws TeamException {
        ThreeWaySynchronizer synchronizer = ModelBusRepositorySubscriber.getInstance().getSynchronizer();
        if (!localFile.exists()) {
            return synchronizer.getBaseBytes((IResource)localFile) != null;
        }
        return synchronizer.isLocallyModified((IResource)localFile);
    }

    private boolean isExtensionForDependenciesSupport(String extension) {
        String[] modelExtensions;
        String[] stringArray = modelExtensions = DependenciesPreferencePlugin.getDefault().getExtensionPreference();
        int n = modelExtensions.length;
        int n2 = 0;
        while (n2 < n) {
            String modelExtension;
            String planeExtension = modelExtension = stringArray[n2];
            if (modelExtension.startsWith("*.")) {
                planeExtension = modelExtension.substring(2);
            } else if (modelExtension.startsWith(".")) {
                planeExtension = modelExtension.substring(1);
            }
            if (planeExtension.equals(extension)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void internalPut(IContainer container, int depth, boolean overrideIncoming, IProgressMonitor progress, String commitMessage) throws TeamException, NonExistingResourceException, RepositoryAuthentificationException, LockedException, InvalidValueException, ConstraintViolationException, UnresolvedReferencesException, IOException, InvalidRevisionException {
        try {
            IResource[] children;
            ThreeWaySynchronizer synchronizer = ModelBusRepositorySubscriber.getInstance().getSynchronizer();
            ArrayList<IFolder> toDelete = new ArrayList<IFolder>();
            if (container.getType() == 2) {
                IFolder folder = (IFolder)container;
                ModelBusRepositoryResourceVariant remote = this.getResourceVariant((IResource)container);
                if (!folder.exists() && remote != null) {
                    toDelete.add(folder);
                } else if (folder.exists() && remote == null) {
                    ModelBusRepositoryHelper.getRepositoryHelper();
                    try {
                        this.folderPaths.add(this.provider.getRepositoryPath((IResource)folder));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            if ((children = synchronizer.members((IResource)container)).length > 0) {
                this.internalPut(children, depth == 2 ? 2 : 0, overrideIncoming, progress, commitMessage);
            }
            Iterator iter = toDelete.iterator();
            while (iter.hasNext()) {
                ModelBusRepositoryHelper.getRepositoryHelper();
                try {
                    IFolder folderToDelete = (IFolder)iter.next();
                    this.deletionPaths.add(this.provider.getRepositoryPath((IResource)folderToDelete));
                    this.resourcesToDelete.add((IResource)folderToDelete);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (container.exists()) {
                this.containerToSetBaseBytes.add(container);
            }
        }
        catch (CoreException e) {
            throw TeamException.asTeamException((CoreException)e);
        }
    }
}

