/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.repository;

import java.io.IOException;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.team.core.TeamException;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.modelbus.core.lib.notification.INotificationListener;
import org.modelbus.core.lib.notification.NotificationListenerManager;
import org.modelbus.preferences.dependencies.DependenciesPreferencePlugin;
import org.modelbus.team.eclipse.repository.ModelBusRepositoryHelper;
import org.modelbus.team.eclipse.repository.RepositoryLocationHelper;
import org.modelbus.team.eclipse.repository.ResourceUtil;
import org.modelbus.team.eclipse.repository.ui.LockHelper;
import org.modelbus.team.eclipse.repository.ui.ModelBusRepositoryDecoratorPing;
import org.modelbus.team.eclipse.repository.ui.ModelBusRepositoryStatus;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class ModelBusRepositoryPlugin
extends AbstractUIPlugin {
    public static final String ID = "org.modelbus.team.eclipse.repository";
    public static final String PROVIDER_ID = "org.modelbus.team.eclipse.repository.ModelBusRepositoryProvider";
    private static String repLocation;
    private static ModelBusRepositoryPlugin plugin;
    private ModelBusRepositoryDecoratorPing modelBusRepositoryDecoratorPing;
    private final long pingInterval = 5000L;
    private final ModelBusRepositoryStatus modelBusRepositoryStatus;

    public ModelBusRepositoryPlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        plugin = this;
        this.modelBusRepositoryStatus = new ModelBusRepositoryStatus();
    }

    public static ModelBusRepositoryPlugin getPlugin() {
        return plugin;
    }

    public static TeamException wrapException(CoreException e) {
        return new TeamException(e.getStatus());
    }

    public static TeamException wrapException(IOException e) {
        return new TeamException((IStatus)new Status(4, ID, -4, e.getMessage(), (Throwable)e));
    }

    public ModelBusRepositoryStatus getRepositoryStatus() {
        return this.modelBusRepositoryStatus;
    }

    public static void log(IStatus status) {
        plugin.getLog().log(status);
    }

    public static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.addResourceChangeListener((IResourceChangeListener)ModelBusRepositoryHelper.getModelBusRepositoryHelper());
        DependenciesPreferencePlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)ModelBusRepositoryHelper.getModelBusRepositoryHelper());
        LockHelper.getLockHelper();
        this.modelBusRepositoryDecoratorPing = new ModelBusRepositoryDecoratorPing(5000L);
        this.modelBusRepositoryDecoratorPing.start();
    }

    public void stop(BundleContext context) throws Exception {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        ModelBusRepositoryHelper modelBusRepositoryHelper = ModelBusRepositoryHelper.getModelBusRepositoryHelper();
        workspace.removeResourceChangeListener((IResourceChangeListener)modelBusRepositoryHelper);
        DependenciesPreferencePlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)modelBusRepositoryHelper);
        LockHelper lockHelper = LockHelper.getLockHelper();
        NotificationListenerManager nManager = NotificationListenerManager.getNotificationListenerManager();
        if (nManager != null) {
            nManager.removeNotificationListener((INotificationListener)lockHelper);
        }
        this.modelBusRepositoryStatus.deleteObservers();
        this.modelBusRepositoryDecoratorPing.kill();
        super.stop(context);
    }

    public String getResource(String key) {
        return ResourceUtil.getResource(Platform.getResourceBundle((Bundle)this.getBundle()), key);
    }

    protected static String getRepositoryLocation() {
        if (repLocation == null) {
            repLocation = RepositoryLocationHelper.getPropertyRepositoryLocation();
        }
        return repLocation;
    }
}

