/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.repository;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.eclipse.core.resources.IFileModificationValidator;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.team.ResourceRuleFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.emf.common.util.URI;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.history.IFileHistoryProvider;
import org.eclipse.team.core.variants.IResourceVariant;
import org.modelbus.core.lib.IRepositoryHelper;
import org.modelbus.dosgi.repository.descriptor.InvalidRevisionException;
import org.modelbus.dosgi.repository.descriptor.NonExistingResourceException;
import org.modelbus.dosgi.repository.descriptor.RepositoryAuthentificationException;
import org.modelbus.dosgi.repository.descriptor.RepositoryDirEntry;
import org.modelbus.dosgi.repository.descriptor.RepositoryNodeKind;
import org.modelbus.preferences.dependencies.DependenciesPreferencePlugin;
import org.modelbus.team.eclipse.repository.FileModificationValidator;
import org.modelbus.team.eclipse.repository.ModelBusRepositoryHelper;
import org.modelbus.team.eclipse.repository.ModelBusRepositoryOperations;
import org.modelbus.team.eclipse.repository.ModelBusRepositoryPlugin;
import org.modelbus.team.eclipse.repository.Policy;
import org.modelbus.team.eclipse.repository.UserSessionHelper;
import org.modelbus.team.eclipse.repository.history.ModelBusRepositoryHistoryProvider;
import org.modelbus.team.eclipse.repository.subscriber.ModelBusRepositoryLocalFileResourceVariant;
import org.modelbus.team.eclipse.repository.subscriber.ModelBusRepositoryResourceVariant;
import org.modelbus.team.eclipse.repository.subscriber.ModelBusRepositorySubscriber;
import org.modelbus.team.eclipse.repository.subscriber.ModelBusThreeWaySynchronizer;

public class ModelBusRepositoryProvider
extends RepositoryProvider {
    private static final ResourceRuleFactory RESOURCE_RULE_FACTORY = new ResourceRuleFactory(){};
    private String repositoryURL;
    private IPath root;
    public static QualifiedName MODELBUS_REPO_LOC = new QualifiedName("org.modelbus.team.eclipse.repository", "modelbus_repository_location");
    private static ModelBusRepositoryHistoryProvider fileHistoryProvider;

    public void configureProject() throws CoreException {
        ModelBusRepositorySubscriber.getInstance().handleRootChanged((IResource)this.getProject(), true);
    }

    public void deconfigure() throws CoreException {
        this.getProject().setPersistentProperty(MODELBUS_REPO_LOC, null);
        ModelBusRepositorySubscriber.getInstance().handleRootChanged((IResource)this.getProject(), false);
    }

    public String getID() {
        return "org.modelbus.team.eclipse.repository.ModelBusRepositoryProvider";
    }

    public void setTargetLocation(String location) throws TeamException, RepositoryAuthentificationException, NonExistingResourceException {
        this.repositoryURL = location;
        DependenciesPreferencePlugin.getDefault().getPreferenceStore().getBoolean("CHECK_DEPENDENCIES_booleanPreference");
        DependenciesPreferencePlugin.getDefault().getExtensionPreference();
        IRepositoryHelper repositoryHelper = ModelBusRepositoryHelper.getRepositoryHelper();
        try {
            if (repositoryHelper.exists(UserSessionHelper.getSession(), URI.createURI((String)location), "-1")) {
                if (!RepositoryNodeKind.DIR.equals((Object)repositoryHelper.checkPath(UserSessionHelper.getSession(), URI.createURI((String)location), "-1"))) {
                    throw new TeamException(Policy.bind("ModelBusRepositoryProvider.mustBeFolder", location));
                }
            } else {
                repositoryHelper.createDir(UserSessionHelper.getSession(), URI.createURI((String)location), "TODO: logMessage");
            }
            this.getProject().setPersistentProperty(MODELBUS_REPO_LOC, location);
            ModelBusRepositorySubscriber.getInstance().getSynchronizer().setBaseBytes((IResource)this.getProject(), new byte[0]);
            String revision = repositoryHelper.getInfo(UserSessionHelper.getSession(), URI.createURI((String)location), "-1").getRevision();
            ((ModelBusThreeWaySynchronizer)ModelBusRepositorySubscriber.getInstance().getSynchronizer()).setWorkingCopyRevision((IResource)this.getProject(), revision);
        }
        catch (CoreException e) {
            e.printStackTrace();
            throw ModelBusRepositoryPlugin.wrapException(e);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw ModelBusRepositoryPlugin.wrapException(e);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw ModelBusRepositoryPlugin.wrapException(e);
        }
        catch (InvalidRevisionException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public String getRepositoryURL() {
        if (this.repositoryURL == null) {
            String location;
            block4: {
                try {
                    location = this.getProject().getPersistentProperty(MODELBUS_REPO_LOC);
                    if (location != null) break block4;
                    return null;
                }
                catch (CoreException e) {
                    ModelBusRepositoryPlugin.log(e.getStatus());
                    return null;
                }
            }
            this.repositoryURL = location;
        }
        return this.repositoryURL;
    }

    public ModelBusRepositoryOperations getOperations() {
        return new ModelBusRepositoryOperations(this);
    }

    public IFileModificationValidator getFileModificationValidator() {
        return new FileModificationValidator(this);
    }

    public IResourceVariant getResourceVariant(IResource resource, byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        String filelocation = this.getRepositoryPath(resource);
        if (filelocation == null) {
            return null;
        }
        DependenciesPreferencePlugin.getDefault().getPreferenceStore().getBoolean("CHECK_DEPENDENCIES_booleanPreference");
        DependenciesPreferencePlugin.getDefault().getExtensionPreference();
        IRepositoryHelper repositoryHelper = ModelBusRepositoryHelper.getRepositoryHelper();
        return new ModelBusRepositoryResourceVariant(this.getRepositoryPath(resource), repositoryHelper, bytes);
    }

    public IResourceVariant getResourceVariant(IResource resource) throws RepositoryAuthentificationException, NonExistingResourceException, IOException, InvalidRevisionException {
        String repositoryPath = this.getRepositoryPath(resource);
        DependenciesPreferencePlugin.getDefault().getPreferenceStore().getBoolean("CHECK_DEPENDENCIES_booleanPreference");
        DependenciesPreferencePlugin.getDefault().getExtensionPreference();
        IRepositoryHelper repositoryHelper = ModelBusRepositoryHelper.getRepositoryHelper();
        if (repositoryPath == null || !repositoryHelper.exists(UserSessionHelper.getSession(), URI.createURI((String)repositoryPath), "-1")) {
            return null;
        }
        RepositoryDirEntry entry = repositoryHelper.getInfo(UserSessionHelper.getSession(), URI.createURI((String)repositoryPath), "-1");
        String revision = entry.getRevision();
        return new ModelBusRepositoryResourceVariant(repositoryPath, repositoryHelper, revision);
    }

    public IResourceVariant getResourceVariant(IResource resource, String revision) throws NonExistingResourceException, RepositoryAuthentificationException, IOException, InvalidRevisionException {
        String repositoryPath = this.getRepositoryPath(resource);
        DependenciesPreferencePlugin.getDefault().getPreferenceStore().getBoolean("CHECK_DEPENDENCIES_booleanPreference");
        DependenciesPreferencePlugin.getDefault().getExtensionPreference();
        IRepositoryHelper repositoryHelper = ModelBusRepositoryHelper.getRepositoryHelper();
        if (repositoryPath == null || !repositoryHelper.exists(UserSessionHelper.getSession(), URI.createURI((String)repositoryPath), revision)) {
            return null;
        }
        return new ModelBusRepositoryResourceVariant(repositoryPath, repositoryHelper, revision);
    }

    public IResourceVariant getLocalResourceVariant(IResource resource) {
        File file = this.getFile(resource);
        if (file == null || !file.exists()) {
            return null;
        }
        return new ModelBusRepositoryLocalFileResourceVariant(file);
    }

    public IResourceVariant getLocalResourceVariant(IResource resource, byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        File file = this.getFile(resource);
        if (file == null) {
            return null;
        }
        return new ModelBusRepositoryLocalFileResourceVariant(file, bytes);
    }

    public File getFile(IResource resource) {
        if (resource.getProject().equals((Object)this.getProject())) {
            IPath rootdir = this.getRoot();
            return new File(rootdir.append(resource.getProjectRelativePath()).toOSString());
        }
        return null;
    }

    public String getRepositoryPath(IResource resource) {
        if (resource == null) {
            return null;
        }
        if (resource.getProject() == null) {
            return null;
        }
        if (resource.getProject().equals((Object)this.getProject())) {
            String repositoryDir = this.getRepositoryURL();
            if (repositoryDir == null) {
                return null;
            }
            return repositoryDir.concat("/" + resource.getProjectRelativePath().toString());
        }
        return null;
    }

    public IPath getRoot() {
        if (this.root == null) {
            String location;
            block4: {
                try {
                    location = "";
                    if (location != null) break block4;
                    return null;
                }
                catch (Exception exception) {
                    return null;
                }
            }
            this.root = new Path(location);
        }
        return this.root;
    }

    public IResourceRuleFactory getRuleFactory() {
        return RESOURCE_RULE_FACTORY;
    }

    public IFileHistoryProvider getFileHistoryProvider() {
        if (fileHistoryProvider == null) {
            fileHistoryProvider = new ModelBusRepositoryHistoryProvider();
        }
        return fileHistoryProvider;
    }
}

