/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.repository;

import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.internal.preferences.Base64;

public class ResourceUtil {
    public static String[] decodeStringToArray(String encodedString) {
        String[] valuesArray = new String[]{};
        if (encodedString != null && encodedString.length() > 0) {
            valuesArray = encodedString.split(";");
            int i = 0;
            while (i < valuesArray.length) {
                valuesArray[i] = new String(Base64.decode((byte[])valuesArray[i].getBytes()));
                ++i;
            }
        }
        return valuesArray;
    }

    public static String getResource(ResourceBundle bundle, String key) {
        if (key == null) {
            return null;
        }
        if (bundle == null) {
            return key;
        }
        String retVal = ResourceUtil.getResourceImpl(bundle, key);
        if (retVal != null) {
            String id;
            if (key.indexOf("Error") != -1 && (id = ResourceUtil.getResourceImpl(bundle, String.valueOf(key) + ".Id")) != null) {
                retVal = String.valueOf(id) + ": " + retVal;
            }
            return retVal;
        }
        return key;
    }

    private static String getResourceImpl(ResourceBundle bundle, String key) {
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }

    public static String flattenText(String text) {
        StringBuffer flat = new StringBuffer(text.length() + 20);
        boolean skipAdjacentLineSeparator = true;
        int i = 0;
        while (i < text.length()) {
            char currentChar = text.charAt(i);
            if (currentChar == '\r' || currentChar == '\n') {
                if (!skipAdjacentLineSeparator) {
                    flat.append("/");
                }
                skipAdjacentLineSeparator = true;
            } else {
                flat.append(currentChar);
                skipAdjacentLineSeparator = false;
            }
            ++i;
        }
        return flat.toString().replace('\t', ' ');
    }
}

