/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.repository.history;

import java.io.InputStream;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.core.history.provider.FileRevision;
import org.modelbus.core.lib.IRepositoryHelper;
import org.modelbus.core.lib.util.ModelBusCoreUtil;
import org.modelbus.dosgi.repository.descriptor.RepositoryDirEntry;
import org.modelbus.team.eclipse.repository.ModelBusRepositoryHelper;
import org.modelbus.team.eclipse.repository.UserSessionHelper;

public class ModelBusRepositoryFileRevision
extends FileRevision {
    RepositoryDirEntry remoteFile;

    public ModelBusRepositoryFileRevision(RepositoryDirEntry file) {
        this.remoteFile = file;
    }

    public String getName() {
        return this.remoteFile.getName();
    }

    public long getTimestamp() {
        return this.remoteFile.getCreationDate().toGregorianCalendar().getTimeInMillis();
    }

    public IStorage getStorage(IProgressMonitor monitor) throws CoreException {
        return new IStorage(){

            public InputStream getContents() throws CoreException {
                try {
                    IRepositoryHelper repositoryHelper = ModelBusRepositoryHelper.getRepositoryHelper();
                    InputStream stream = repositoryHelper.checkOutFile(UserSessionHelper.getSession(), URI.createURI((String)ModelBusRepositoryFileRevision.this.remoteFile.getUri()), ModelBusRepositoryFileRevision.this.remoteFile.getRevision());
                    return stream;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new RuntimeException(e);
                }
            }

            public IPath getFullPath() {
                String uri = ModelBusRepositoryFileRevision.this.remoteFile.getUri();
                String path = null;
                path = ModelBusCoreUtil.URIUtil.isHTTPURI((String)uri) ? uri.substring("http://".length()) : uri;
                return new Path(null, path);
            }

            public String getName() {
                return ModelBusRepositoryFileRevision.this.remoteFile.getName();
            }

            public boolean isReadOnly() {
                return true;
            }

            public Object getAdapter(Class adapter) {
                return null;
            }
        };
    }

    public boolean isPropertyMissing() {
        return false;
    }

    public IFileRevision withAllProperties(IProgressMonitor monitor) throws CoreException {
        return null;
    }

    public String getContentIdentifier() {
        return "[File System Revision]";
    }
}

