/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.repository.subscriber;

import java.io.UnsupportedEncodingException;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.diff.IThreeWayDiff;
import org.eclipse.team.core.mapping.ISynchronizationScopeManager;
import org.eclipse.team.core.mapping.provider.ResourceDiffTree;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.core.subscribers.SubscriberMergeContext;
import org.eclipse.team.internal.core.Policy;
import org.modelbus.team.eclipse.repository.subscriber.ModelBusRepositorySubscriber;

public class ModelBusRepositoryMergeContext
extends SubscriberMergeContext {
    public ModelBusRepositoryMergeContext(ISynchronizationScopeManager manager) {
        super((Subscriber)ModelBusRepositorySubscriber.getInstance(), manager);
        this.initialize();
    }

    protected void makeInSync(IDiff diff, IProgressMonitor monitor) throws CoreException {
        IResource resource = ResourceDiffTree.getResourceFor((IDiff)diff);
        try {
            ModelBusRepositorySubscriber.getInstance().makeInSync(resource);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public void markAsMerged(IDiff diff, boolean inSyncHint, IProgressMonitor monitor) throws CoreException {
        IResource resource = ResourceDiffTree.getResourceFor((IDiff)diff);
        try {
            ModelBusRepositorySubscriber.getInstance().markAsMerged(resource, monitor);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public void reject(IDiff diff, IProgressMonitor monitor) throws CoreException {
        this.markAsMerged(diff, false, monitor);
    }

    public ISchedulingRule getMergeRule(IDiff node) {
        return ResourceDiffTree.getResourceFor((IDiff)node).getProject();
    }

    public IStatus merge(IDiff diff, boolean ignoreLocalChanges, IProgressMonitor monitor) throws CoreException {
        Policy.checkCanceled((IProgressMonitor)monitor);
        IResource resource = this.getDiffTree().getResource(diff);
        if (resource.getType() != 1 && diff instanceof IThreeWayDiff) {
            IThreeWayDiff twd = (IThreeWayDiff)diff;
            if (resource.getType() == 2 && twd.getDirection() == 512 && twd.getKind() == 2) {
                ((IFolder)resource).delete(false, monitor);
                this.makeInSync(diff, monitor);
                return Status.OK_STATUS;
            }
        }
        return super.merge(diff, ignoreLocalChanges, monitor);
    }
}

