/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.repository.subscriber;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IEncodedStorage;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.variants.CachedResourceVariant;
import org.eclipse.team.internal.core.Messages;
import org.eclipse.team.internal.core.TeamPlugin;
import org.modelbus.core.lib.IRepositoryHelper;
import org.modelbus.core.lib.types.IModelBusDataSource;
import org.modelbus.core.lib.util.ModelBusCoreUtil;
import org.modelbus.dosgi.repository.descriptor.RepositoryDirEntry;
import org.modelbus.dosgi.repository.descriptor.RepositoryNodeKind;
import org.modelbus.team.eclipse.repository.ModelBusRepositoryHelper;
import org.modelbus.team.eclipse.repository.UserSessionHelper;

public class ModelBusRepositoryResourceVariant
extends CachedResourceVariant {
    private RepositoryDirEntry repositoryDirEntry;
    private String repositoryPath;
    private byte[] bytes;
    private String revision = "-1";
    private IRepositoryHelper repositoryHelper;
    private boolean isContainer;
    ModelBusRepositoryResourceVariant[] members = null;
    IModelBusDataSource contents = null;
    ModelBusResourceVariantStorage storage = null;

    public ModelBusRepositoryResourceVariant(RepositoryDirEntry repositoryPath, IRepositoryHelper repositoryHelper) {
        this.repositoryHelper = repositoryHelper;
        this.repositoryDirEntry = repositoryPath;
        if (this.repositoryDirEntry == null) {
            RuntimeException e = new RuntimeException();
            e.printStackTrace();
            throw e;
        }
        this.revision = repositoryPath.getRevision();
    }

    public ModelBusRepositoryResourceVariant(String repositoryPath, IRepositoryHelper repositoryHelper, String revision) {
        this.revision = revision;
        this.repositoryPath = repositoryPath;
        this.repositoryHelper = repositoryHelper;
        if (repositoryPath == null) {
            RuntimeException e = new RuntimeException();
            e.printStackTrace();
            throw e;
        }
    }

    public ModelBusRepositoryResourceVariant(String repositoryPath, IRepositoryHelper repositoryHelper) {
        this.repositoryHelper = repositoryHelper;
        this.repositoryPath = repositoryPath;
        if (repositoryPath == null) {
            RuntimeException e = new RuntimeException();
            e.printStackTrace();
            throw e;
        }
    }

    public ModelBusRepositoryResourceVariant(String repositoryPath, IRepositoryHelper repositoryHelper, byte[] bytes) {
        this.repositoryHelper = repositoryHelper;
        this.repositoryPath = repositoryPath;
        this.bytes = bytes;
        if (repositoryPath == null) {
            RuntimeException e = new RuntimeException();
            e.printStackTrace();
            throw e;
        }
    }

    public RepositoryDirEntry getRepositoryDirEntry() {
        if (this.repositoryDirEntry == null) {
            try {
                this.repositoryDirEntry = this.repositoryHelper.getInfo(UserSessionHelper.getSession(), URI.createURI((String)this.repositoryPath), this.revision);
                this.revision = this.repositoryDirEntry.getRevision();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.repositoryDirEntry;
    }

    public ModelBusRepositoryResourceVariant(RepositoryDirEntry repositoryPath, byte[] bytes) {
        this.repositoryDirEntry = repositoryPath;
        this.bytes = bytes;
        if (repositoryPath == null) {
            RuntimeException e = new RuntimeException();
            e.printStackTrace();
            throw e;
        }
        this.revision = repositoryPath.getRevision();
    }

    protected void fetchContents(IProgressMonitor monitor) throws TeamException {
        this.setContents(this.getContents(), monitor);
    }

    protected String getCachePath() {
        return String.valueOf(URI.createURI((String)this.getRepositoryDirEntry().getUri()).path()) + " " + this.getRepositoryDirEntry().getRevision();
    }

    protected String getCacheId() {
        return "org.modelbus.team.eclipse.repository";
    }

    public String getName() {
        return this.getRepositoryDirEntry().getName();
    }

    public boolean isContainer() {
        if (this.bytes != null && this.bytes.length > 0) {
            return false;
        }
        RepositoryDirEntry dirEntry = null;
        try {
            dirEntry = this.getRepositoryDirEntry();
        }
        catch (RuntimeException runtimeException) {}
        if (dirEntry != null) {
            return RepositoryNodeKind.DIR.equals((Object)dirEntry.getKind());
        }
        return false;
    }

    public boolean isFile() {
        if (this.bytes != null && this.bytes.length == 0) {
            return false;
        }
        RepositoryDirEntry dirEntry = this.getRepositoryDirEntry();
        if (dirEntry != null) {
            return RepositoryNodeKind.FILE.equals((Object)dirEntry.getKind());
        }
        return false;
    }

    public String getContentIdentifier() {
        return this.getRepositoryDirEntry().getUri().toString();
    }

    public byte[] asBytes() {
        if (this.bytes == null) {
            try {
                IRepositoryHelper repositoryHelper = ModelBusRepositoryHelper.getRepositoryHelper();
                if (this.isContainer()) {
                    this.bytes = new byte[0];
                    return this.bytes;
                }
                InputStream stream = repositoryHelper.checkOutFile(UserSessionHelper.getSession(), URI.createURI((String)this.getRepositoryDirEntry().getUri()), this.getRepositoryDirEntry().getRevision());
                if (stream != null) {
                    int len;
                    ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
                    byte[] buffer = new byte[1024];
                    while ((len = stream.read(buffer)) >= 0) {
                        out.write(buffer, 0, len);
                    }
                    stream.close();
                    out.close();
                    this.bytes = out.toByteArray();
                    return this.bytes;
                }
                this.bytes = new byte[0];
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        return this.bytes;
    }

    public ModelBusRepositoryResourceVariant[] members() {
        if (this.isContainer()) {
            if (this.members == null) {
                try {
                    IRepositoryHelper repositoryHelper = ModelBusRepositoryHelper.getRepositoryHelper();
                    RepositoryDirEntry[] entries = repositoryHelper.getDirEntries(UserSessionHelper.getSession(), URI.createURI((String)this.getRepositoryDirEntry().getUri()), this.getRepositoryDirEntry().getRevision());
                    ModelBusRepositoryResourceVariant[] result = new ModelBusRepositoryResourceVariant[entries.length];
                    int i = 0;
                    while (i < entries.length) {
                        result[i] = new ModelBusRepositoryResourceVariant(entries[i], repositoryHelper);
                        ++i;
                    }
                    this.members = result;
                }
                catch (Exception exception) {
                    this.members = new ModelBusRepositoryResourceVariant[0];
                }
            }
            return this.members;
        }
        return new ModelBusRepositoryResourceVariant[0];
    }

    public InputStream getContents() throws TeamException {
        if (this.contents == null) {
            try {
                IRepositoryHelper repositoryHelper = ModelBusRepositoryHelper.getRepositoryHelper();
                this.contents = repositoryHelper.checkOutFileAsDataSource(UserSessionHelper.getSession(), URI.createURI((String)this.getRepositoryDirEntry().getUri()), this.getRepositoryDirEntry().getRevision());
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        if (this.contents != null) {
            try {
                return this.contents.getInputStream();
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        return new ByteArrayInputStream(new byte[0]);
    }

    public RepositoryDirEntry getFile() {
        return this.getRepositoryDirEntry();
    }

    public String getRevision() {
        if ("-1".equals(this.revision)) {
            this.revision = this.getRepositoryDirEntry().getRevision();
        }
        return this.revision;
    }

    public IStorage getStorage(IProgressMonitor monitor) throws TeamException {
        if (this.isContainer()) {
            return null;
        }
        if (this.storage == null) {
            this.storage = new ModelBusResourceVariantStorage();
        }
        return this.storage;
    }

    class ModelBusResourceVariantStorage
    implements IEncodedStorage {
        ModelBusResourceVariantStorage() {
        }

        public InputStream getContents() throws CoreException {
            return ModelBusRepositoryResourceVariant.this.getContents();
        }

        public IPath getFullPath() {
            String uri = ModelBusRepositoryResourceVariant.this.getRepositoryDirEntry().getUri();
            String path = null;
            path = ModelBusCoreUtil.URIUtil.isHTTPURI((String)uri) ? uri.substring("http://".length()) : uri;
            return new Path(null, path);
        }

        public String getName() {
            return ModelBusRepositoryResourceVariant.this.getName();
        }

        public boolean isReadOnly() {
            return true;
        }

        public Object getAdapter(Class adapter) {
            return ModelBusRepositoryResourceVariant.this.getAdapter(adapter);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public String getCharset() throws CoreException {
            String string;
            InputStream contents = this.getContents();
            try {
                String charSet;
                string = charSet = TeamPlugin.getCharset((String)this.getName(), (InputStream)contents);
            }
            catch (IOException e) {
                try {
                    throw new TeamException((IStatus)new Status(4, "org.eclipse.team.core", 381, NLS.bind((String)Messages.CachedResourceVariant_1, (Object[])new String[]{this.getFullPath().toString()}), (Throwable)e));
                }
                catch (Throwable throwable) {
                    try {
                        contents.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
            }
            try {
                contents.close();
                return string;
            }
            catch (IOException iOException) {}
            return string;
        }
    }
}

