/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.repository.subscriber;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.core.variants.ThreeWayRemoteTree;
import org.eclipse.team.core.variants.ThreeWaySubscriber;
import org.eclipse.team.core.variants.ThreeWaySynchronizer;
import org.modelbus.team.eclipse.repository.ModelBusRepositoryProvider;
import org.modelbus.team.eclipse.repository.subscriber.ModelBusRepositoryRemoteTree;
import org.modelbus.team.eclipse.repository.subscriber.ModelBusRepositoryResourceVariant;
import org.modelbus.team.eclipse.repository.subscriber.ModelBusRepositorySyncInfo;
import org.modelbus.team.eclipse.repository.subscriber.ModelBusThreeWaySynchronizer;

public class ModelBusRepositorySubscriber
extends ThreeWaySubscriber {
    private static ModelBusRepositorySubscriber instance;

    public static synchronized ModelBusRepositorySubscriber getInstance() {
        if (instance == null) {
            instance = new ModelBusRepositorySubscriber();
        }
        return instance;
    }

    private ModelBusRepositorySubscriber() {
        super((ThreeWaySynchronizer)new ModelBusThreeWaySynchronizer(new QualifiedName("org.modelbus.team.eclipse.repository", "workspace-sync")));
    }

    public IResourceVariant getResourceVariant(IResource resource, byte[] bytes) throws TeamException {
        RepositoryProvider provider = RepositoryProvider.getProvider((IProject)resource.getProject(), (String)"org.modelbus.team.eclipse.repository.ModelBusRepositoryProvider");
        if (provider != null) {
            return ((ModelBusRepositoryProvider)provider).getResourceVariant(resource, bytes);
        }
        return null;
    }

    protected ThreeWayRemoteTree createRemoteTree() {
        return new ModelBusRepositoryRemoteTree(this);
    }

    public String getName() {
        return "ModelBus Repository Subscriber";
    }

    public IResource[] roots() {
        ArrayList<IProject> result = new ArrayList<IProject>();
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            RepositoryProvider provider;
            IProject project = projects[i];
            if (project.isAccessible() && (provider = RepositoryProvider.getProvider((IProject)project, (String)"org.modelbus.team.eclipse.repository.ModelBusRepositoryProvider")) != null) {
                result.add(project);
            }
            ++i;
        }
        return result.toArray(new IProject[result.size()]);
    }

    public void handleRootChanged(IResource resource, boolean added) {
        super.handleRootChanged(resource, added);
    }

    protected SyncInfo getSyncInfo(IResource local, IResourceVariant base, IResourceVariant remote) throws TeamException {
        ModelBusRepositorySyncInfo info = new ModelBusRepositorySyncInfo(local, base, remote, this.getResourceComparator());
        info.init();
        return info;
    }

    public void makeInSync(IResource resource) throws TeamException, UnsupportedEncodingException {
        ThreeWaySynchronizer synchronizer = this.getSynchronizer();
        IResourceVariant remote = this.getRemoteTree().getResourceVariant(resource);
        ArrayList<IContainer> parentContainers = new ArrayList<IContainer>();
        IContainer parent = resource.getParent();
        while (parent != null) {
            parentContainers.add(parent);
            parent = parent.getParent();
        }
        if (remote == null && !resource.exists()) {
            synchronizer.flush(resource, 0);
        } else {
            byte[] byArray = synchronizer.getRemoteBytes(resource);
            if (byArray == null) {
                if (!resource.exists()) {
                    synchronizer.flush(resource, 0);
                }
            } else {
                synchronizer.setBaseBytes(resource, byArray);
                ((ModelBusThreeWaySynchronizer)synchronizer).setWorkingCopyRevision(resource, ((ModelBusRepositoryResourceVariant)remote).getRevision());
            }
        }
        for (Object e : parentContainers) {
            byte[] remoteBytes = synchronizer.getRemoteBytes((IResource)e);
            if (!synchronizer.isLocallyModified((IResource)e) || remoteBytes == null) continue;
            synchronizer.setBaseBytes((IResource)e, remoteBytes);
            remote = this.getRemoteTree().getResourceVariant((IResource)e);
            ((ModelBusThreeWaySynchronizer)synchronizer).setWorkingCopyRevision((IResource)e, ((ModelBusRepositoryResourceVariant)remote).getRevision());
        }
    }

    public void markAsMerged(IResource resource, IProgressMonitor monitor) throws TeamException, UnsupportedEncodingException {
        this.makeInSync(resource);
        try {
            if (resource.exists() && resource.getType() == 1) {
                resource.touch(monitor);
            }
        }
        catch (CoreException e) {
            throw TeamException.asTeamException((CoreException)e);
        }
    }
}

