/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.repository.subscriber;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.core.variants.IResourceVariantComparator;

public class ModelBusRepositorySyncInfo
extends SyncInfo {
    public ModelBusRepositorySyncInfo(IResource local, IResourceVariant base, IResourceVariant remote, IResourceVariantComparator comparator) {
        super(local, base, remote, comparator);
    }

    protected int calculateKind() throws TeamException {
        if (this.getLocal().getType() != 1) {
            if (this.getBase() != null) {
                if (this.getLocal().exists()) {
                    if (this.getRemote() != null) {
                        return 0;
                    }
                    return 10;
                }
                if (this.getRemote() != null) {
                    return 6;
                }
                return 30;
            }
            if (this.getLocal().exists()) {
                if (this.getRemote() != null) {
                    return 29;
                }
                return 5;
            }
            if (this.getRemote() != null) {
                return 9;
            }
            return 0;
        }
        return this.local_calculateKind();
    }

    private int local_calculateKind() {
        int description = 0;
        boolean localExists = this.getLocal().exists();
        if (this.getComparator().isThreeWay()) {
            if (this.getBase() == null) {
                if (this.getRemote() == null) {
                    description = !localExists ? 0 : 5;
                } else if (!localExists) {
                    description = 9;
                } else {
                    description = 13;
                    if (this.getComparator().compare(this.getLocal(), this.getRemote())) {
                        description |= 0x10;
                    }
                }
            } else if (!localExists) {
                description = this.getRemote() == null ? 30 : (this.getComparator().compare(this.getBase(), this.getRemote()) ? 6 : 15);
            } else if (this.getRemote() == null) {
                description = this.getComparator().compare(this.getLocal(), this.getBase()) ? 10 : 15;
            } else {
                boolean ay = this.getComparator().compare(this.getLocal(), this.getBase());
                boolean am = this.getComparator().compare(this.getBase(), this.getRemote());
                if (!ay || !am) {
                    if (ay && !am) {
                        description = 11;
                    } else if (!ay && am) {
                        description = 7;
                    } else if (!this.getComparator().compare(this.getLocal(), this.getRemote())) {
                        description = 15;
                    }
                }
            }
        } else if (this.getRemote() == null) {
            if (!localExists) {
                Assert.isTrue((boolean)false);
            } else {
                description = 2;
            }
        } else if (!localExists) {
            description = 1;
        } else if (!this.getComparator().compare(this.getLocal(), this.getRemote())) {
            description = 3;
        }
        return description;
    }

    public IResourceVariant getBase() {
        return super.getBase();
    }
}

