/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.repository.subscriber;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import org.eclipse.team.core.TeamException;

public class ModelBusSyncByteConverter {
    public static byte[] setSlot(byte[] syncBytes, int slot, byte[] newBytes) throws TeamException {
        ArrayList<byte[]> collect = new ArrayList<byte[]>();
        int currentPos = 0;
        int newLength = 0;
        int j = 0;
        while (currentPos < syncBytes.length) {
            int length = ModelBusSyncByteConverter.byteArrayToInt(syncBytes, currentPos);
            byte[] array = new byte[length];
            System.arraycopy(syncBytes, currentPos += 4, array, 0, length);
            collect.add(array);
            currentPos += length;
            newLength += 4;
            if (j != slot) {
                newLength += length;
            }
            ++j;
        }
        collect.set(slot, newBytes);
        byte[] result = new byte[newLength += newBytes.length];
        int pos = 0;
        int i = 0;
        while (i < collect.size()) {
            ModelBusSyncByteConverter.intToByteArray(((byte[])collect.get(i)).length, pos, result);
            System.arraycopy(collect.get(i), 0, result, pos += 4, ((byte[])collect.get(i)).length);
            pos += ((byte[])collect.get(i)).length;
            ++i;
        }
        return result;
    }

    private static int startOfSlot(byte[] syncBytes, int slot) {
        int currentPos = 0;
        int j = 0;
        while (j < slot) {
            currentPos = currentPos + ModelBusSyncByteConverter.byteArrayToInt(syncBytes, currentPos) + 4;
            ++j;
        }
        return currentPos + 4;
    }

    private static final byte[] intToByteArray(int value, int pos, byte[] src) {
        src[pos] = (byte)(value >>> 24);
        src[pos + 1] = (byte)(value >>> 16);
        src[pos + 2] = (byte)(value >>> 8);
        src[pos + 3] = (byte)value;
        return src;
    }

    private static final int byteArrayToInt(byte[] b, int pos) {
        return (b[pos] << 24) + ((b[pos + 1] & 0xFF) << 16) + ((b[pos + 2] & 0xFF) << 8) + (b[pos + 3] & 0xFF);
    }

    public static byte[] getSlot(byte[] bytes, int index, boolean includeRest) {
        int currentPos = 0;
        int j = 0;
        while (j < index) {
            currentPos = currentPos + ModelBusSyncByteConverter.byteArrayToInt(bytes, currentPos) + 4;
            ++j;
        }
        int length = ModelBusSyncByteConverter.byteArrayToInt(bytes, currentPos);
        byte[] result = new byte[length];
        System.arraycopy(bytes, currentPos + 4, result, 0, length);
        return result;
    }

    public static byte[] toBytes(String revision, String timeStamp, byte[] base, byte[] remote) {
        byte[][] byteArrays = new byte[4][];
        int length = 0;
        try {
            byteArrays[0] = revision.getBytes("UTF8");
            byteArrays[1] = timeStamp.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        byteArrays[2] = base;
        byteArrays[3] = remote;
        length += byteArrays[0].length;
        length += byteArrays[1].length;
        length += byteArrays[2].length;
        length += byteArrays[3].length;
        byte[] result = new byte[length += 16];
        int pos = 0;
        int i = 0;
        while (i < 4) {
            ModelBusSyncByteConverter.intToByteArray(byteArrays[i].length, pos, result);
            System.arraycopy(byteArrays[i], 0, result, pos += 4, byteArrays[i].length);
            pos += byteArrays[i].length;
            ++i;
        }
        return result;
    }

    public static void main(String[] args) throws UnsupportedEncodingException, TeamException {
    }
}

