/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.repository.ui;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.ui.IConfigurationWizard;
import org.eclipse.ui.IWorkbench;
import org.modelbus.dosgi.repository.descriptor.NonExistingResourceException;
import org.modelbus.dosgi.repository.descriptor.RepositoryAuthentificationException;
import org.modelbus.team.eclipse.repository.ModelBusRepositoryPlugin;
import org.modelbus.team.eclipse.repository.ModelBusRepositoryProvider;
import org.modelbus.team.eclipse.repository.Policy;
import org.modelbus.team.eclipse.repository.ui.ModelBusRepositoryMainPage;

public class ConfigurationWizard
extends Wizard
implements IConfigurationWizard {
    IProject project;
    ModelBusRepositoryMainPage mainPage;

    public ConfigurationWizard() {
        IDialogSettings workbenchSettings = ModelBusRepositoryPlugin.getPlugin().getDialogSettings();
        IDialogSettings section = workbenchSettings.getSection("ProviderExamplesWizard");
        if (section == null) {
            section = workbenchSettings.addNewSection("ProviderExamplesWizard");
        }
        this.setDialogSettings(section);
    }

    public void init(IWorkbench workbench, IProject project) {
        this.project = project;
    }

    public void addPages() {
        this.mainPage = new ModelBusRepositoryMainPage(this.project.getName(), "ModelBusRepositoryMainPage", Policy.bind("ConfigurationWizard.name"), Policy.bind("ConfigurationWizard.description"), null);
        this.addPage((IWizardPage)this.mainPage);
    }

    public boolean performFinish() {
        this.mainPage.finish(null);
        try {
            RepositoryProvider.map((IProject)this.project, (String)"org.modelbus.team.eclipse.repository.ModelBusRepositoryProvider");
            ModelBusRepositoryProvider provider = (ModelBusRepositoryProvider)RepositoryProvider.getProvider((IProject)this.project);
            try {
                provider.setTargetLocation(this.mainPage.getLocation());
            }
            catch (RepositoryAuthentificationException e) {
                throw new RuntimeException(e);
            }
            catch (NonExistingResourceException e) {
                throw new RuntimeException(e);
            }
        }
        catch (TeamException e) {
            ErrorDialog.openError((Shell)this.getShell(), (String)Policy.bind("ConfigurationWizard.errorMapping"), (String)Policy.bind("ConfigurationWizard.error"), (IStatus)e.getStatus());
            return false;
        }
        return true;
    }
}

