/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.repository.ui;

import java.io.IOException;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.diff.IDiffVisitor;
import org.eclipse.team.core.diff.IThreeWayDiff;
import org.eclipse.team.core.subscribers.SubscriberScopeManager;
import org.eclipse.ui.IWorkbenchPart;
import org.modelbus.dosgi.repository.descriptor.InvalidRevisionException;
import org.modelbus.dosgi.repository.descriptor.NonExistingResourceException;
import org.modelbus.dosgi.repository.descriptor.RepositoryAuthentificationException;
import org.modelbus.team.eclipse.repository.ModelBusRepositoryProvider;
import org.modelbus.team.eclipse.repository.Policy;
import org.modelbus.team.eclipse.repository.subscriber.ModelBusRepositorySubscriber;
import org.modelbus.team.eclipse.repository.ui.ModelBusRepositoryOperation;

public class GetOperation
extends ModelBusRepositoryOperation {
    private boolean overwriteOutgoing;
    private IWorkbenchPart workbenchPart;

    public GetOperation(IWorkbenchPart part, SubscriberScopeManager manager) {
        super(part, manager);
        this.workbenchPart = part;
    }

    @Override
    protected void execute(ModelBusRepositoryProvider provider, ResourceTraversal[] traversals, IProgressMonitor monitor) throws CoreException {
        if (!this.isOverwriteOutgoing() && this.hasOutgoingChanges(traversals)) {
            if (this.workbenchPart != null) {
                Shell shell = this.workbenchPart.getSite().getShell();
                Display display = shell.getDisplay();
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openInformation((Shell)GetOperation.this.getShell(), (String)GetOperation.this.getTaskName(), (String)"Could not get all changes due to conflicts or outgoing changes. You have to synchronize your project before updating.");
                    }
                });
            }
            return;
        }
        try {
            provider.getOperations().get(traversals, this.isOverwriteOutgoing(), monitor);
        }
        catch (RepositoryAuthentificationException e) {
            throw new RuntimeException(e);
        }
        catch (NonExistingResourceException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (InvalidRevisionException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean hasOutgoingChanges(ResourceTraversal[] traversals) throws CoreException {
        final RuntimeException found = new RuntimeException();
        try {
            ModelBusRepositorySubscriber.getInstance().accept(traversals, new IDiffVisitor(){

                public boolean visit(IDiff diff) {
                    IThreeWayDiff twd;
                    if (diff instanceof IThreeWayDiff && ((twd = (IThreeWayDiff)diff).getDirection() == 256 || twd.getDirection() == 768)) {
                        throw found;
                    }
                    return false;
                }
            });
        }
        catch (RuntimeException e) {
            if (e == found) {
                return true;
            }
            throw e;
        }
        return false;
    }

    protected boolean isOverwriteOutgoing() {
        return this.overwriteOutgoing;
    }

    public void setOverwriteOutgoing(boolean overwriteOutgoing) {
        this.overwriteOutgoing = overwriteOutgoing;
    }

    @Override
    protected String getTaskName() {
        return Policy.bind("GetAction.working");
    }
}

