/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.repository.ui;

import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.modelbus.team.eclipse.repository.ModelBusRepositoryPlugin;
import org.modelbus.team.eclipse.repository.UserSessionHelper;
import org.modelbus.team.eclipse.repository.ui.LockHelper;
import org.osgi.framework.Bundle;

public class LockDecorator
extends LabelProvider
implements ILightweightLabelDecorator {
    private static LockDecorator lockDecorator = null;
    private final String ICON_PATH = "icons/";

    public LockDecorator() {
        lockDecorator = this;
    }

    public static void refreshDecoration() {
        lockDecorator.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)lockDecorator));
    }

    public void decorate(Object element, IDecoration decoration) {
        try {
            String user = LockHelper.getLockHelper().objectLockedBy(element);
            if (user == null) {
                return;
            }
            if (user.equals(UserSessionHelper.getPropertyUserName())) {
                decoration.addOverlay(this.createImageDescriptor("lock_green.gif"));
                decoration.addSuffix("[locked]");
            } else {
                decoration.addOverlay(this.createImageDescriptor("lock_red.gif"));
                decoration.addSuffix("[locked by " + user + " ]");
            }
        }
        catch (Exception exception) {
            return;
        }
    }

    private ImageDescriptor createImageDescriptor(String id) {
        URL url = FileLocator.find((Bundle)ModelBusRepositoryPlugin.getPlugin().getBundle(), (IPath)new Path("icons/" + id), null);
        return ImageDescriptor.createFromURL((URL)url);
    }
}

