/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.repository.ui;

import java.net.URLDecoder;
import java.rmi.RemoteException;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.ui.progress.UIJob;
import org.modelbus.core.lib.IRepositoryHelper;
import org.modelbus.core.lib.notification.INotificationListener;
import org.modelbus.core.lib.notification.NotificationListenerManager;
import org.modelbus.dosgi.repository.descriptor.LockInfo;
import org.modelbus.dosgi.repository.descriptor.LockedException;
import org.modelbus.dosgi.repository.descriptor.NonExistingResourceException;
import org.modelbus.dosgi.repository.descriptor.RepositoryAuthentificationException;
import org.modelbus.team.eclipse.repository.ModelBusRepositoryHelper;
import org.modelbus.team.eclipse.repository.ModelBusRepositoryPlugin;
import org.modelbus.team.eclipse.repository.ModelBusRepositoryProvider;
import org.modelbus.team.eclipse.repository.UserSessionHelper;
import org.modelbus.team.eclipse.repository.ui.LockDecorator;

public class LockHelper
implements INotificationListener,
Observer {
    private static LockInfo[] lockInfos;
    private static IRepositoryHelper repositoryHelper;
    private static boolean repositoryIsAvailable;
    private static LockHelper lockHelper;
    private static NotificationListenerManager nManager;

    static {
        repositoryHelper = null;
        repositoryIsAvailable = false;
        lockHelper = null;
        nManager = null;
    }

    private LockHelper() throws RemoteException {
    }

    public static synchronized LockHelper getLockHelper() {
        if (nManager == null) {
            try {
                nManager = NotificationListenerManager.getNotificationListenerManager();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        if (nManager != null && lockHelper == null) {
            try {
                lockHelper = new LockHelper();
                ModelBusRepositoryPlugin.getPlugin().getRepositoryStatus().addObserver(lockHelper);
                if (nManager != null && lockHelper != null) {
                    nManager.addNotificationListener((INotificationListener)lockHelper);
                }
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
        return lockHelper;
    }

    private void setRepositoryStatus(boolean isAvailable) {
        repositoryIsAvailable = isAvailable;
    }

    public static void resetLockHelper() {
        nManager.removeNotificationListener((INotificationListener)lockHelper);
        lockHelper = null;
        lockInfos = null;
        UIJob go = new UIJob("DecoratorNotificationListener"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                try {
                    LockDecorator.refreshDecoration();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return Status.OK_STATUS;
            }
        };
        go.setSystem(true);
        go.setUser(false);
        go.schedule();
    }

    public LockInfo[] getLocks() throws RepositoryAuthentificationException, LockedException, NonExistingResourceException {
        repositoryHelper = this.getRepositoryHelper();
        if (repositoryHelper != null) {
            if (lockInfos == null) {
                if (repositoryIsAvailable) {
                    lockInfos = repositoryHelper.getLocks(UserSessionHelper.getSession(), "");
                } else {
                    return new LockInfo[0];
                }
            }
            return lockInfos;
        }
        return new LockInfo[0];
    }

    private IRepositoryHelper getRepositoryHelper() {
        if (repositoryHelper == null) {
            repositoryHelper = ModelBusRepositoryHelper.getRepositoryHelper();
        }
        return repositoryHelper;
    }

    public String getObjectLocation(URI resourceURI, String fragment) {
        String objectLocation = null;
        String resourceLocation = resourceURI.toString();
        Object projectURI = null;
        if (resourceURI.segmentCount() > 1) {
            IFile resource;
            RepositoryProvider repositoryProvider;
            IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            IProject project = null;
            IProject[] iProjectArray = projects;
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject currentProject = iProjectArray[n2];
                if (resourceURI.isPlatformResource()) {
                    projectURI = URI.createPlatformResourceURI((String)currentProject.getName(), (boolean)true);
                } else if (resourceURI.isFile()) {
                    projectURI = URI.createFileURI((String)currentProject.getLocation().toString());
                }
                if (projectURI != null && (projectURI != null && resourceLocation.startsWith(String.valueOf(projectURI.toString()) + "/") || resourceLocation.equals(projectURI.toString()))) {
                    project = currentProject;
                    break;
                }
                ++n2;
            }
            if (project != null && (repositoryProvider = RepositoryProvider.getProvider((IProject)(resource = project.getFile(URLDecoder.decode(resourceLocation.replace(String.valueOf(projectURI.toString()) + "/", "")))).getProject(), (String)"org.modelbus.team.eclipse.repository.ModelBusRepositoryProvider")) != null) {
                ModelBusRepositoryProvider modelBusRepositoryProvider = (ModelBusRepositoryProvider)repositoryProvider;
                objectLocation = modelBusRepositoryProvider.getRepositoryPath((IResource)resource);
                URI uri = URI.createURI((String)objectLocation);
                if (fragment != null) {
                    uri = uri.appendFragment(fragment);
                }
                objectLocation = uri.toString();
            }
        } else {
            objectLocation = fragment != null ? resourceURI.appendFragment(fragment).toString() : resourceLocation;
        }
        return objectLocation;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isDirectLocked(Object object) {
        if (object == null) {
            return false;
        }
        String objectLocation = null;
        if (object instanceof IFile) {
            objectLocation = this.getObjectLocation(URI.createURI((String)((IFile)object).getLocationURI().toString()), null);
        } else if (object instanceof EObject) {
            EObject eObject = (EObject)object;
            Resource objectResource = eObject.eResource();
            if (objectResource == null) {
                return false;
            }
            String objectUri = objectResource.getURIFragment(eObject);
            objectLocation = this.getObjectLocation(objectResource.getURI(), objectUri);
        } else if (object instanceof Resource) {
            objectLocation = this.getObjectLocation(((Resource)object).getURI(), null);
        }
        try {
            LockInfo[] lockInfos = this.getLocks();
            int i = 0;
            while (true) {
                if (i >= lockInfos.length) {
                    return false;
                }
                LockInfo lockInfo = lockInfos[i];
                if (lockInfo != null) {
                    String objectUrl = lockInfo.getUrl();
                    if (objectLocation != null && objectLocation.equals(objectUrl)) {
                        return true;
                    }
                }
                ++i;
            }
        }
        catch (Exception exception) {
            return false;
        }
    }

    public String objectLockedBy(Object object) {
        String objectLocation = null;
        if (object instanceof IFile) {
            objectLocation = this.getObjectLocation(URI.createURI((String)((IFile)object).getLocationURI().toString()), null);
        } else if (object instanceof EObject) {
            EObject eObject = (EObject)object;
            Resource objectResource = eObject.eResource();
            if (objectResource == null) {
                return null;
            }
            String objectUri = objectResource.getURIFragment(eObject);
            objectLocation = this.getObjectLocation(objectResource.getURI(), objectUri);
        } else if (object instanceof Resource) {
            objectLocation = this.getObjectLocation(((Resource)object).getURI(), null);
        }
        try {
            LockInfo[] lockInfos = this.getLocks();
            int i = 0;
            while (i < lockInfos.length) {
                LockInfo lockInfo = lockInfos[i];
                if (lockInfo != null) {
                    String objectUrl = lockInfo.getUrl();
                    String user = lockInfo.getUserName();
                    if (objectLocation != null && objectLocation.equals(objectUrl)) {
                        return user;
                    }
                }
                ++i;
            }
        }
        catch (Exception exception) {
            return null;
        }
        if (object instanceof EObject) {
            EObject container = ((EObject)object).eContainer();
            if (container == null) {
                container = ((EObject)object).eResource();
            }
            if (container != null) {
                return this.objectLockedBy(container);
            }
        }
        return null;
    }

    public void notification(String url, String mode, String user, String sessionID) {
        if ("http://www.modelbus.org/system/model/ModelBus.lock".equals(url) && repositoryIsAvailable) {
            LockHelper.resetLockHelper();
        }
    }

    public void commitChangeModelNotification(String modelUri, String messageID, String changeModelContent) {
    }

    @Override
    public void update(Observable o, Object arg) {
        this.setRepositoryStatus(ModelBusRepositoryPlugin.getPlugin().getRepositoryStatus().isAvailable());
    }
}

