/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.repository.ui;

import java.net.InetAddress;
import org.eclipse.emf.common.util.URI;
import org.modelbus.core.lib.IServicesHelper;
import org.modelbus.core.lib.ModelBusCoreLib;
import org.modelbus.core.lib.types.Status;
import org.modelbus.dosgi.repository.descriptor.RepositoryAuthentificationException;
import org.modelbus.team.eclipse.repository.ModelBusRepositoryPlugin;
import org.modelbus.team.eclipse.repository.RepositoryLocationHelper;
import org.modelbus.team.eclipse.repository.UserSessionHelper;
import org.modelbus.team.eclipse.repository.ui.ModelBusRepositoryStatus;

public class ModelBusRepositoryDecoratorPing
extends Thread {
    private final long interval;
    private boolean stop = false;
    private IServicesHelper servicesHelper = null;

    public ModelBusRepositoryDecoratorPing(long interval) {
        if (interval < 0L) {
            throw new IllegalArgumentException("Value for ping interval has to be non negative.");
        }
        this.interval = interval;
    }

    @Override
    public void run() {
        ModelBusRepositoryStatus modelBusRepositoryStatus = ModelBusRepositoryPlugin.getPlugin().getRepositoryStatus();
        while (!this.stop) {
            try {
                if (this.servicesHelper == null) {
                    this.servicesHelper = ModelBusCoreLib.getServicesHelper();
                }
                Status status = this.servicesHelper.getStatus(UserSessionHelper.getSession(), false);
                String statusLocation = status.getLocation();
                URI statusLocationURI = URI.createURI((String)statusLocation);
                String statusLocationAuthority = statusLocationURI.authority();
                String statusLocationPort = statusLocationURI.port();
                if (statusLocationAuthority != null) {
                    if (statusLocationPort != null) {
                        statusLocationAuthority = statusLocationAuthority.split(":")[0];
                    }
                    statusLocationAuthority = statusLocationAuthority.equals("0.0.0.0") ? InetAddress.getLocalHost().getHostAddress() : InetAddress.getByName(statusLocationAuthority).getHostAddress();
                }
                String repoLocation = RepositoryLocationHelper.getPropertyRepositoryLocation();
                URI repoLocationURI = URI.createURI((String)repoLocation);
                String authority = repoLocationURI.authority();
                String port = repoLocationURI.port();
                if (authority != null) {
                    if (port != null) {
                        authority = authority.split(":")[0];
                    }
                    authority = authority.equals("0.0.0.0") ? InetAddress.getLocalHost().getHostAddress() : InetAddress.getByName(authority).getHostAddress();
                }
                if (repoLocation != null && (repoLocation.equals(statusLocation) || statusLocationAuthority.equals(authority))) {
                    modelBusRepositoryStatus.setAvailable(true);
                } else {
                    modelBusRepositoryStatus.setAvailable(false);
                }
            }
            catch (RepositoryAuthentificationException repositoryAuthentificationException) {
                modelBusRepositoryStatus.setAvailable(false);
            }
            catch (Exception exception) {
                modelBusRepositoryStatus.setAvailable(false);
            }
            try {
                Thread.sleep(this.interval);
            }
            catch (InterruptedException exc) {
                throw new RuntimeException(exc);
            }
        }
    }

    public void kill() {
        this.stop = true;
    }
}

