/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.repository.ui;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.modelbus.core.lib.IRepositoryHelper;
import org.modelbus.core.lib.util.ModelBusCoreUtil;
import org.modelbus.dosgi.repository.descriptor.RepositoryDirEntry;
import org.modelbus.dosgi.repository.descriptor.RepositoryNodeKind;
import org.modelbus.team.eclipse.repository.ModelBusRepositoryHelper;
import org.modelbus.team.eclipse.repository.Policy;
import org.modelbus.team.eclipse.repository.RepositoryLocationHelper;
import org.modelbus.team.eclipse.repository.UserSessionHelper;

public class ModelBusRepositoryMainPage
extends WizardPage {
    private String projectName;
    private Text locationText;
    private Tree tree;
    private static final int COMBO_HISTORY_LENGTH = 5;
    private static final String INCOMPLETE_ROOT_URL_STRING = "http:/";
    private String repositoryLocation;
    private IRepositoryHelper repositoryHelper;
    private static final String STORE_LOCATION = "ModelBusRepositoryWizardMainPage.STORE_LOCATION";

    public ModelBusRepositoryMainPage(String pageName, String title, String description, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
        this.setDescription(description);
        this.setTitle(title);
    }

    public ModelBusRepositoryMainPage(String projectName, String pageName, String title, String description, ImageDescriptor titleImage) {
        this(pageName, title, description, titleImage);
        this.projectName = projectName;
    }

    protected Button createCheckBox(Composite group, String label) {
        Button button = new Button(group, 16416);
        button.setText(label);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        button.setLayoutData((Object)data);
        return button;
    }

    protected Combo createCombo(Composite parent) {
        Combo combo = new Combo(parent, 8);
        GridData data = new GridData(768);
        data.widthHint = 200;
        combo.setLayoutData((Object)data);
        return combo;
    }

    protected Composite createComposite(Composite parent, int numColumns) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        return composite;
    }

    protected Label createLabel(Composite parent, String text) {
        Label label = new Label(parent, 16384);
        label.setText(text);
        GridData data = new GridData();
        data.horizontalSpan = 1;
        data.horizontalAlignment = 4;
        label.setLayoutData((Object)data);
        return label;
    }

    protected Text createTextField(Composite parent) {
        Text text = new Text(parent, 2052);
        GridData data = new GridData(768);
        data.verticalAlignment = 2;
        data.grabExcessVerticalSpace = false;
        data.widthHint = 200;
        text.setLayoutData((Object)data);
        return text;
    }

    protected String[] addToHistory(String[] history, String newEntry) {
        ArrayList<String> l = new ArrayList<String>(Arrays.asList(history));
        this.addToHistory(l, newEntry);
        String[] r = new String[l.size()];
        l.toArray(r);
        return r;
    }

    protected void addToHistory(List history, String newEntry) {
        history.remove(newEntry);
        history.add(0, newEntry);
        if (history.size() > 5) {
            history.remove(5);
        }
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        this.setControl((Control)composite);
        Label label = new Label(composite, 0);
        label.setText(Policy.bind("ModelBusRepositoryMainPage.location"));
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.locationText = new Text(composite, 2048);
        this.locationText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        new Label(composite, 0);
        TreeViewer treeViewer = new TreeViewer(composite, 2048);
        this.tree = treeViewer.getTree();
        this.tree.setLayoutData((Object)new GridData(4, 4, true, true));
        this.tree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ModelBusRepositoryMainPage.this.handleSelection();
            }
        });
        this.initializeValues();
        this.updatePackageTree();
        this.validateFields();
    }

    public String getLocation() {
        return this.locationText.getText();
    }

    private void handleSelection() {
        TreeItem[] sels = this.tree.getSelection();
        if (sels.length > 0) {
            TreeItem sel = sels[0];
            RepositoryDirEntry entry = (RepositoryDirEntry)sel.getData();
            String url = entry.getUri().toString();
            if (INCOMPLETE_ROOT_URL_STRING.equals(url)) {
                url = String.valueOf(url) + "/";
            }
            if (!url.endsWith("/")) {
                url = String.valueOf(url) + "/";
            }
            url = String.valueOf(url) + this.projectName;
            this.locationText.setText(url);
        }
        this.dialogChanged();
    }

    private void dialogChanged() {
        String location = this.locationText.getText();
        if (location.length() == 0) {
            this.updateStatus("Registry Location must be specified");
            return;
        }
        this.updateStatus(null);
    }

    private void updatePackageTree() {
        this.tree.removeAll();
        this.tree.setEnabled(false);
        TreeItem root_package = new TreeItem(this.tree, 0);
        root_package.setText(this.getRepositoryLocation());
        try {
            this.repositoryHelper = ModelBusRepositoryHelper.getRepositoryHelper();
            RepositoryDirEntry root = this.repositoryHelper.getRoot(UserSessionHelper.getSession());
            root_package.setData((Object)root);
            try {
                this.addEntries(root_package, this.repositoryHelper.getDirEntries(UserSessionHelper.getSession(), URI.createURI((String)root.getUri()), root.getRevision()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.tree.setEnabled(true);
            this.updateStatus("Please select a model or a file");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addEntries(TreeItem treeitem, RepositoryDirEntry[] entries) throws RemoteException {
        if (entries == null) {
            return;
        }
        int i = 0;
        while (i < entries.length) {
            RepositoryDirEntry entry = entries[i];
            if (RepositoryNodeKind.DIR.equals((Object)entry.getKind())) {
                TreeItem item = new TreeItem(treeitem, 4);
                item.setText(entry.getName());
                item.setData((Object)entry);
                try {
                    RepositoryDirEntry[] childs = this.repositoryHelper.getDirEntries(UserSessionHelper.getSession(), URI.createURI((String)entry.getUri()), entry.getRevision());
                    this.addEntries(item, childs);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
        this.setPageComplete(true);
    }

    public boolean finish(IProgressMonitor monitor) {
        this.saveWidgetValues();
        return true;
    }

    private void initializeValues() {
        String[] locations;
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null && (locations = settings.getArray(STORE_LOCATION)) != null) {
            int i = 0;
            while (i < locations.length) {
                ++i;
            }
        }
    }

    private void saveWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String[] locations = settings.getArray(STORE_LOCATION);
            if (locations == null) {
                locations = new String[]{};
            }
            settings.put(STORE_LOCATION, locations);
        }
    }

    private void validateFields() {
        String location = this.locationText.getText();
        if (location.length() == 0) {
            this.setErrorMessage(null);
            this.setPageComplete(false);
            return;
        }
        if (!ModelBusCoreUtil.URIUtil.isHTTPURI((String)location)) {
            this.setErrorMessage("Malformed URL");
            this.setPageComplete(false);
            return;
        }
        this.setErrorMessage(null);
        this.setPageComplete(true);
    }

    protected String getRepositoryLocation() {
        if (this.repositoryLocation == null) {
            this.repositoryLocation = RepositoryLocationHelper.getPropertyRepositoryLocation();
        }
        return this.repositoryLocation;
    }
}

