/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.repository.ui;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.mapping.ISynchronizationScope;
import org.eclipse.team.core.mapping.ISynchronizationScopeManager;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.core.subscribers.SubscriberScopeManager;
import org.eclipse.team.ui.synchronize.ModelOperation;
import org.eclipse.ui.IWorkbenchPart;
import org.modelbus.dosgi.repository.descriptor.ConstraintViolationException;
import org.modelbus.dosgi.repository.descriptor.InvalidValueException;
import org.modelbus.dosgi.repository.descriptor.LockedException;
import org.modelbus.dosgi.repository.descriptor.NonExistingResourceException;
import org.modelbus.dosgi.repository.descriptor.UnresolvedReferencesException;
import org.modelbus.team.eclipse.repository.ModelBusRepositoryProvider;
import org.modelbus.team.eclipse.repository.subscriber.ModelBusRepositorySubscriber;
import org.modelbus.team.eclipse.repository.ui.CompoundResourceTraversal;

public abstract class ModelBusRepositoryOperation
extends ModelOperation {
    public static SubscriberScopeManager createScopeManager(String name, ResourceMapping[] inputMappings) {
        return new SubscriberScopeManager(name, inputMappings, (Subscriber)ModelBusRepositorySubscriber.getInstance(), true);
    }

    protected ModelBusRepositoryOperation(IWorkbenchPart part, SubscriberScopeManager manager) {
        super(part, (ISynchronizationScopeManager)manager);
    }

    protected void execute(IProgressMonitor monitor) throws InvocationTargetException {
        try {
            try {
                Map providerToTraversals = this.getProviderToTraversalsMap();
                monitor.beginTask(this.getTaskName(), providerToTraversals.size() * 100);
                monitor.setTaskName(this.getTaskName());
                for (ModelBusRepositoryProvider provider : providerToTraversals.keySet()) {
                    ResourceTraversal[] traversals = this.getTraversals(providerToTraversals, provider);
                    this.execute(provider, traversals, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
                }
            }
            catch (CoreException e) {
                throw new InvocationTargetException(e);
            }
            catch (InvalidValueException e) {
                throw new InvocationTargetException(e);
            }
            catch (NonExistingResourceException e) {
                throw new InvocationTargetException(e);
            }
            catch (LockedException e) {
                throw new InvocationTargetException(e);
            }
            catch (ConstraintViolationException e) {
                throw new InvocationTargetException(e);
            }
            catch (UnresolvedReferencesException e) {
                throw new InvocationTargetException(e);
            }
        }
        finally {
            monitor.done();
        }
    }

    private Map getProviderToTraversalsMap() {
        HashMap result = new HashMap();
        ISynchronizationScope scope = this.getScope();
        ResourceMapping[] mappings = scope.getMappings();
        int i = 0;
        while (i < mappings.length) {
            ResourceMapping mapping = mappings[i];
            ResourceTraversal[] traversals = scope.getTraversals(mapping);
            int j = 0;
            while (j < traversals.length) {
                ResourceTraversal traversal = traversals[j];
                IResource[] resources = traversal.getResources();
                int k = 0;
                while (k < resources.length) {
                    IResource resource = resources[k];
                    this.recordResourceAndDepth(result, resource, traversal.getDepth());
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return result;
    }

    protected ModelBusRepositoryProvider getProviderFor(IProject project) {
        return (ModelBusRepositoryProvider)RepositoryProvider.getProvider((IProject)project, (String)"org.modelbus.team.eclipse.repository.ModelBusRepositoryProvider");
    }

    private void recordResourceAndDepth(HashMap providerToTraversals, IResource resource, int depth) {
        ModelBusRepositoryProvider provider = this.getProviderFor(resource.getProject());
        if (provider != null) {
            CompoundResourceTraversal traversal = (CompoundResourceTraversal)providerToTraversals.get((Object)provider);
            if (traversal == null) {
                traversal = new CompoundResourceTraversal();
                providerToTraversals.put(provider, traversal);
            }
            traversal.addResource(resource, depth);
        }
    }

    private ResourceTraversal[] getTraversals(Map providerToTraversals, ModelBusRepositoryProvider provider) {
        CompoundResourceTraversal traversal = (CompoundResourceTraversal)providerToTraversals.get((Object)provider);
        return traversal.asTraversals();
    }

    protected abstract void execute(ModelBusRepositoryProvider var1, ResourceTraversal[] var2, IProgressMonitor var3) throws CoreException, InvalidValueException, NonExistingResourceException, LockedException, ConstraintViolationException, UnresolvedReferencesException;

    protected abstract String getTaskName();

    protected boolean canRunAsJob() {
        return true;
    }
}

