/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.repository.ui;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.subscribers.SubscriberScopeManager;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ModelParticipantAction;
import org.modelbus.model.user.User;
import org.modelbus.model.user.UserModel;
import org.modelbus.model.user.UserPackage;
import org.modelbus.team.eclipse.repository.ModelBusRepositoryPlugin;
import org.modelbus.team.eclipse.repository.UserSessionHelper;
import org.modelbus.team.eclipse.repository.ui.ModelBusRepositoryOperation;
import org.modelbus.team.eclipse.repository.ui.MultiLineInputDialog;
import org.modelbus.team.eclipse.repository.ui.PutOperation;

public class ModelPutAction
extends ModelParticipantAction {
    public ModelPutAction(String text, ISynchronizePageConfiguration configuration) {
        super(text, configuration);
    }

    protected boolean isEnabledForSelection(IStructuredSelection selection) {
        int mode = this.getConfiguration().getMode();
        if (mode == 2 || mode == 4) {
            return this.getResourceMappings(selection).length > 0;
        }
        return false;
    }

    private ResourceMapping[] getResourceMappings(IStructuredSelection selection) {
        ArrayList<ResourceMapping> mappings = new ArrayList<ResourceMapping>();
        for (Object element : selection) {
            ResourceMapping mapping = Utils.getResourceMapping(element);
            if (mapping == null) continue;
            mappings.add(mapping);
        }
        return mappings.toArray(new ResourceMapping[mappings.size()]);
    }

    public void run() {
        ResourceMapping[] resourceMappings = this.getResourceMappings(this.getStructuredSelection());
        SubscriberScopeManager manager = ModelBusRepositoryOperation.createScopeManager("Put", resourceMappings);
        try {
            Shell shell = ModelBusRepositoryPlugin.getPlugin().getWorkbench().getActiveWorkbenchWindow().getShell();
            IStructuredSelection selection = this.getStructuredSelection();
            Object firstElement = selection.getFirstElement();
            if (firstElement instanceof IResource) {
                IResource[] allChildren = this.getAllChildren((IResource)firstElement, new ArrayList<IResource>());
                int i = 0;
                block4: while (i < allChildren.length) {
                    IResource child = allChildren[i];
                    String childName = child.getName();
                    if (childName.equals("ModelBus.user")) {
                        ResourceSetImpl resourceSet = new ResourceSetImpl();
                        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("user", new XMIResourceFactoryImpl());
                        resourceSet.getPackageRegistry().put((Object)"http://www.modelbus.org/system/model/user.ecore", (Object)UserPackage.eINSTANCE);
                        Resource res = resourceSet.getResource(URI.createFileURI((String)child.getLocation().toString()), true);
                        UserModel userModel = (UserModel)res.getContents().get(0);
                        EList ownedUser = userModel.getOwnedUser();
                        for (User user : ownedUser) {
                            if (!UserSessionHelper.getPropertyUserName().equals(user.getName()) || UserSessionHelper.getPropertyUserPassword().equals(user.getPassword())) continue;
                            MessageDialog messageDialog = new MessageDialog(shell, "Changing current password", null, "You are about to change your password!\nPlease change your password in the ModelBus Preferences Page after committing the file.", 2, new String[]{"OK", "CANCEL"}, 0);
                            if (messageDialog.open() != 1) break block4;
                            return;
                        }
                        break;
                    }
                    ++i;
                }
            }
            MultiLineInputDialog inputDialog = new MultiLineInputDialog(shell, "Commit Message Dialog");
            String commitMessage = "";
            if (inputDialog.open() == 0) {
                commitMessage = inputDialog.getValue();
                new PutOperation(this.getConfiguration().getSite().getPart(), manager, commitMessage).run();
            }
        }
        catch (InvocationTargetException e) {
            IStatus status = this.getStatus(e);
            ErrorDialog.openError((Shell)this.getConfiguration().getSite().getShell(), null, null, (IStatus)status);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private IResource[] getAllChildren(IResource resource, ArrayList<IResource> allChildren) throws CoreException {
        IResource[] members;
        if (!allChildren.contains(resource)) {
            allChildren.add(resource);
        }
        if (resource instanceof IContainer && (members = ((IContainer)resource).members()).length != 0) {
            int i = 0;
            while (i < members.length) {
                IResource member = members[i];
                this.getAllChildren(member, allChildren);
                ++i;
            }
        }
        return allChildren.toArray(new IResource[allChildren.size()]);
    }

    private IStatus getStatus(Throwable throwable) {
        if (throwable instanceof InvocationTargetException) {
            return this.getStatus(((InvocationTargetException)throwable).getCause());
        }
        return new Status(4, "org.modelbus.team.eclipse.repository", 0, "An error occurred during the put.", throwable);
    }
}

