/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.repository.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.internal.preferences.Base64;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.modelbus.team.eclipse.repository.ModelBusRepositoryPlugin;
import org.modelbus.team.eclipse.repository.ResourceUtil;

public class MultiLineInputDialog
extends Dialog {
    private static final String COMMENT_HISTORY_NAME = "comment";
    private static String PREVIOUS_COMMENTS_HEADER;
    private static String PREVIOUS_COMMENTS_HINT;
    private static final int COMMENT_SAVED_COMMENTS_COUNT_DEFAULT = 10;
    private String title;
    private String value = "";
    private Button okButton;
    private Text text;
    private UserInputHistory history;
    private Set<String> ignoredStrings;

    public MultiLineInputDialog(Shell parentShell, String dialogTitle) {
        super(parentShell);
        this.title = dialogTitle;
        PREVIOUS_COMMENTS_HEADER = ModelBusRepositoryPlugin.getPlugin().getResource("InputDialog.Previous");
        PREVIOUS_COMMENTS_HINT = "    " + ModelBusRepositoryPlugin.getPlugin().getResource("InputDialog.Previous.Hint");
        this.ignoredStrings = new HashSet<String>();
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.value = this.text.getText();
            this.history.addLine(this.value);
        } else {
            this.value = null;
        }
        super.buttonPressed(buttonId);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.text.setFocus();
        if (this.value != null) {
            this.text.setText(this.value);
            this.text.selectAll();
        }
    }

    protected Control createDialogArea(Composite parent) {
        GridLayout layout = null;
        GridData data = null;
        Color bgColor = new Color(null, 255, 255, 255);
        Composite composite = new Composite(parent, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        composite.setLayout((Layout)layout);
        data = new GridData(1808);
        composite.setLayoutData((Object)data);
        Dialog.applyDialogFont((Control)composite);
        Composite infoPanel = new Composite(composite, 0);
        layout = new GridLayout();
        layout.marginHeight = 1;
        layout.marginWidth = 1;
        layout.numColumns = 2;
        infoPanel.setLayout((Layout)layout);
        data = new GridData(768);
        Point pt = new Point(510, -1);
        data.widthHint = pt.x;
        infoPanel.setLayoutData((Object)data);
        infoPanel.setBackground(bgColor);
        Composite leftSide = new Composite(infoPanel, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.horizontalSpacing = 1;
        leftSide.setLayout((Layout)layout);
        data = new GridData(1808);
        leftSide.setLayoutData((Object)data);
        leftSide.setBackground(bgColor);
        Font defaultFont = JFaceResources.getBannerFont();
        FontData[] fData = defaultFont.getFontData();
        Display display = Display.getCurrent();
        if (display == null) {
            display = PlatformUI.getWorkbench().getDisplay();
        }
        Font mainLabelFont = new Font((Device)display, fData);
        Label description = new Label(leftSide, 64);
        data = new GridData(768);
        data.horizontalSpan = 2;
        description.setLayoutData((Object)data);
        String descText = ModelBusRepositoryPlugin.getPlugin().getResource("InputDialog.Description");
        description.setText(descText != null ? descText : "");
        description.setFont(mainLabelFont);
        description.setBackground(bgColor);
        Label message = new Label(leftSide, 64);
        message.setText(ModelBusRepositoryPlugin.getPlugin().getResource("InputDialog.Message"));
        data = new GridData(1808);
        data.horizontalIndent = 3;
        message.setLayoutData((Object)data);
        message.setFont(parent.getFont());
        message.setBackground(bgColor);
        Composite fullSizePanel = new Composite(composite, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        fullSizePanel.setLayout((Layout)layout);
        data = new GridData(1808);
        fullSizePanel.setLayoutData((Object)data);
        Label separator = new Label(fullSizePanel, 258);
        separator.setLayoutData((Object)new GridData(768));
        Composite customPanel = new Composite(fullSizePanel, 0);
        layout = new GridLayout();
        layout.marginHeight = 7;
        layout.marginWidth = 7;
        customPanel.setLayout((Layout)layout);
        data = new GridData(1808);
        pt = new Point(510, -1);
        data.widthHint = pt.x;
        customPanel.setLayoutData((Object)data);
        separator = new Label(fullSizePanel, 258);
        separator.setLayoutData((Object)new GridData(768));
        this.text = this.createText(customPanel);
        Label label = new Label(customPanel, 0);
        label.setLayoutData((Object)new GridData());
        label.setText(ModelBusRepositoryPlugin.getPlugin().getResource("InputDialog.ChooseComment"));
        this.history = new UserInputHistory(COMMENT_HISTORY_NAME, 10);
        final Combo previousCommentsCombo = new Combo(customPanel, 8);
        data = new GridData(768);
        data.widthHint = 200;
        previousCommentsCombo.setLayoutData((Object)data);
        final List<String> commentsList = this.getCommentsList();
        ArrayList<String> flattenCommentsList = new ArrayList<String>();
        Iterator<String> iter = commentsList.iterator();
        while (iter.hasNext()) {
            flattenCommentsList.add(ResourceUtil.flattenText(iter.next()));
        }
        previousCommentsCombo.setVisibleItemCount(flattenCommentsList.size());
        previousCommentsCombo.setItems(flattenCommentsList.toArray(new String[flattenCommentsList.size()]));
        previousCommentsCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int idx = previousCommentsCombo.getSelectionIndex();
                if (idx != -1) {
                    String comboText = (String)commentsList.get(idx);
                    MultiLineInputDialog.this.text.setText(MultiLineInputDialog.this.ignoredStrings.contains(comboText) ? MultiLineInputDialog.this.text.getText() : comboText);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return composite;
    }

    protected Button getOkButton() {
        return this.okButton;
    }

    protected Text getText() {
        return this.text;
    }

    public String getValue() {
        return this.value;
    }

    protected int getInputTextStyle() {
        return 2052;
    }

    protected Text createText(Composite composite) {
        Text text = new Text(composite, 2818);
        GridData data = new GridData(1808);
        data.heightHint = 5 * text.getLineHeight();
        data.widthHint = this.convertHorizontalDLUsToPixels(200);
        text.setLayoutData((Object)data);
        return text;
    }

    protected List<String> getCommentsList() {
        ArrayList<String> commentsList = new ArrayList<String>();
        commentsList.add(PREVIOUS_COMMENTS_HEADER);
        this.ignoredStrings.add(PREVIOUS_COMMENTS_HEADER);
        if (this.history.getHistory().length > 0) {
            commentsList.addAll(Arrays.asList(this.history.getHistory()));
        } else {
            commentsList.add(PREVIOUS_COMMENTS_HINT);
            this.ignoredStrings.add(PREVIOUS_COMMENTS_HINT);
        }
        return commentsList;
    }

    private class UserInputHistory {
        protected static final String HISTORY_NAME_BASE = "history.";
        protected String name;
        protected int depth;
        protected List<String> history;

        public UserInputHistory(String name, int depth) {
            this.name = name;
            this.depth = depth;
            this.loadHistoryLines();
        }

        public String[] getHistory() {
            return this.history.toArray(new String[this.history.size()]);
        }

        public void addLine(String line) {
            if (line == null || line.trim().length() == 0) {
                return;
            }
            this.history.remove(line);
            this.history.add(0, line);
            if (this.history.size() > this.depth) {
                this.history.remove(this.history.size() - 1);
            }
            this.saveHistoryLines();
        }

        protected void loadHistoryLines() {
            this.history = new ArrayList<String>();
            String historyData = ModelBusRepositoryPlugin.getPlugin().getPreferenceStore().getString(HISTORY_NAME_BASE + this.name);
            if (historyData != null && historyData.length() > 0) {
                String[] historyArray = historyData.split(";");
                int i = 0;
                while (i < historyArray.length) {
                    historyArray[i] = new String(Base64.decode((byte[])historyArray[i].getBytes()));
                    ++i;
                }
                this.history.addAll(Arrays.asList(historyArray));
            }
        }

        protected void saveHistoryLines() {
            String result = "";
            for (String str : this.history) {
                str = new String(Base64.encode((byte[])str.getBytes()));
                result = String.valueOf(result) + (result.length() == 0 ? str : ";" + str);
            }
            ModelBusRepositoryPlugin.getPlugin().getPreferenceStore().setValue(HISTORY_NAME_BASE + this.name, result);
        }
    }
}

