/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.repository.ui;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.IProjectSetSerializer;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.modelbus.dosgi.repository.descriptor.NonExistingResourceException;
import org.modelbus.dosgi.repository.descriptor.RepositoryAuthentificationException;
import org.modelbus.team.eclipse.repository.ModelBusRepositoryProvider;
import org.modelbus.team.eclipse.repository.Policy;

public class ProjectSetSerializer
implements IProjectSetSerializer {
    public String[] asReference(IProject[] providerProjects, Object context, IProgressMonitor monitor) throws TeamException {
        Assert.isTrue((boolean)(context instanceof Shell));
        ArrayList<String> refs = new ArrayList<String>();
        int i = 0;
        while (i < providerProjects.length) {
            IProject project = providerProjects[i];
            ModelBusRepositoryProvider provider = (ModelBusRepositoryProvider)RepositoryProvider.getProvider((IProject)project, (String)"org.modelbus.team.eclipse.repository.ModelBusRepositoryProvider");
            if (provider != null) {
                refs.add(this.asReference(provider));
            }
            ++i;
        }
        return refs.toArray(new String[refs.size()]);
    }

    public IProject[] addToWorkspace(String[] referenceStrings, String filename, Object context, IProgressMonitor monitor) throws TeamException {
        Assert.isTrue((boolean)(context instanceof Shell));
        ArrayList<IProject> projects = new ArrayList<IProject>();
        int i = 0;
        while (i < referenceStrings.length) {
            String string = referenceStrings[i];
            String projectName = this.getProjectName(string);
            String path = this.getPath(string);
            if (projectName != null && path != null) {
                try {
                    IProject project = this.createProject(projectName, monitor);
                    RepositoryProvider.map((IProject)project, (String)"org.modelbus.team.eclipse.repository.ModelBusRepositoryProvider");
                    ModelBusRepositoryProvider provider = (ModelBusRepositoryProvider)RepositoryProvider.getProvider((IProject)project);
                    try {
                        provider.setTargetLocation(path);
                    }
                    catch (RepositoryAuthentificationException e) {
                        throw new RuntimeException(e);
                    }
                    catch (NonExistingResourceException e) {
                        throw new RuntimeException(e);
                    }
                    projects.add(project);
                }
                catch (CoreException e) {
                    ErrorDialog.openError((Shell)((Shell)context), (String)Policy.bind("ConfigurationWizard.errorMapping"), (String)Policy.bind("ConfigurationWizard.error"), (IStatus)e.getStatus());
                }
            }
            ++i;
        }
        return projects.toArray(new IProject[projects.size()]);
    }

    private String asReference(ModelBusRepositoryProvider provider) {
        return String.valueOf(provider.getProject().getName()) + "," + provider.getRepositoryURL();
    }

    private String getProjectName(String string) {
        int i = string.indexOf(44);
        if (i == -1) {
            return null;
        }
        return string.substring(0, i);
    }

    private String getPath(String string) {
        int i = string.indexOf(44);
        if (i == -1) {
            return null;
        }
        return string.substring(i + 1);
    }

    private IProject createProject(String projectName, IProgressMonitor monitor) throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (!project.exists()) {
            project.create(monitor);
        }
        if (!project.isOpen()) {
            project.open(monitor);
        }
        return project;
    }
}

