/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.repository.ui;

import java.io.IOException;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.diff.IDiffVisitor;
import org.eclipse.team.core.diff.IThreeWayDiff;
import org.eclipse.team.core.subscribers.SubscriberScopeManager;
import org.eclipse.ui.IWorkbenchPart;
import org.modelbus.dosgi.repository.descriptor.ConstraintViolationException;
import org.modelbus.dosgi.repository.descriptor.InvalidRevisionException;
import org.modelbus.dosgi.repository.descriptor.InvalidValueException;
import org.modelbus.dosgi.repository.descriptor.LockedException;
import org.modelbus.dosgi.repository.descriptor.NonExistingResourceException;
import org.modelbus.dosgi.repository.descriptor.RepositoryAuthentificationException;
import org.modelbus.dosgi.repository.descriptor.UnresolvedReferencesException;
import org.modelbus.team.eclipse.repository.ModelBusRepositoryProvider;
import org.modelbus.team.eclipse.repository.Policy;
import org.modelbus.team.eclipse.repository.subscriber.ModelBusRepositorySubscriber;
import org.modelbus.team.eclipse.repository.ui.ModelBusRepositoryOperation;

public class PutOperation
extends ModelBusRepositoryOperation {
    private boolean overwriteIncoming;
    private String commitMessage;
    private IWorkbenchPart workbenchPart;

    protected PutOperation(IWorkbenchPart part, SubscriberScopeManager manager, String commitMessage) {
        super(part, manager);
        this.commitMessage = commitMessage;
        this.workbenchPart = part;
    }

    @Override
    protected void execute(ModelBusRepositoryProvider provider, ResourceTraversal[] traversals, IProgressMonitor monitor) throws CoreException, LockedException, InvalidValueException, ConstraintViolationException, UnresolvedReferencesException {
        if (!this.isOverwriteIncoming() && this.hasIncomingChanges(traversals)) {
            if (this.workbenchPart != null) {
                Shell shell = this.workbenchPart.getSite().getShell();
                Display display = shell.getDisplay();
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openInformation((Shell)PutOperation.this.getShell(), (String)PutOperation.this.getTaskName(), (String)"Could not get all changes due to conflicts or incoming changes. You have to synchronize your project before committing.");
                    }
                });
            }
            return;
        }
        try {
            provider.getOperations().checkin(traversals, this.isOverwriteIncoming(), monitor, this.commitMessage);
        }
        catch (RepositoryAuthentificationException e) {
            throw new RuntimeException(e);
        }
        catch (NonExistingResourceException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (InvalidRevisionException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean hasIncomingChanges(ResourceTraversal[] traversals) throws CoreException {
        final RuntimeException found = new RuntimeException();
        try {
            ModelBusRepositorySubscriber.getInstance().accept(traversals, new IDiffVisitor(){

                public boolean visit(IDiff diff) {
                    IThreeWayDiff twd;
                    if (diff instanceof IThreeWayDiff && ((twd = (IThreeWayDiff)diff).getDirection() == 512 || twd.getDirection() == 768)) {
                        throw found;
                    }
                    return false;
                }
            });
        }
        catch (RuntimeException e) {
            if (e == found) {
                return true;
            }
            throw e;
        }
        return false;
    }

    @Override
    protected String getTaskName() {
        return Policy.bind("PutAction.working");
    }

    public boolean isOverwriteIncoming() {
        return this.overwriteIncoming;
    }

    public void setOverwriteIncoming(boolean overwriteIncoming) {
        this.overwriteIncoming = overwriteIncoming;
    }
}

