/*
 * Decompiled with CFR 0.152.
 */
package org.oslo.ocl20;

import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.oslo.ocl20.OclProcessor;
import org.oslo.ocl20.generation.lib.OclAnyImpl;
import org.oslo.ocl20.semantics.bridge.Classifier;
import org.oslo.ocl20.semantics.bridge.Environment;
import org.oslo.ocl20.semantics.bridge.Namespace;
import org.oslo.ocl20.semantics.bridge.OclModelElementType;
import org.oslo.ocl20.semantics.model.contexts.ClassifierContextDecl;
import org.oslo.ocl20.semantics.model.contexts.Constraint;
import org.oslo.ocl20.semantics.model.contexts.ConstraintKind$Class;
import org.oslo.ocl20.semantics.model.contexts.ContextDeclaration;
import org.oslo.ocl20.standard.lib.OclAny;
import org.oslo.ocl20.syntax.ast.contexts.PackageDeclarationAS;
import org.oslo.ocl20.synthesis.OclToStringVisitorImpl;
import org.oslo.ocl20.synthesis.RuntimeEnvironment;
import org.oslo.ocl20.synthesis.RuntimeEnvironmentImpl;
import uk.ac.kent.cs.kmf.util.ILog;

public abstract class OclProcessorImpl
implements OclProcessor {
    public RuntimeEnvironment renv_ = null;
    protected Boolean debug = Boolean.FALSE;
    protected ILog log = null;
    protected Set models = new HashSet();

    public OclProcessorImpl(ILog log) {
        this.log = log;
    }

    @Override
    public void setDebug(Boolean d) {
        this.debug = d;
    }

    @Override
    public Boolean getDebug() {
        return this.debug;
    }

    @Override
    public ILog getLog() {
        return this.log;
    }

    @Override
    public void setLog(ILog l) {
        this.log = l;
    }

    @Override
    public Set getModels() {
        return this.models;
    }

    @Override
    public PackageDeclarationAS parse(String str) {
        return this.parse(str, this.getLog());
    }

    @Override
    public PackageDeclarationAS parse(String str, ILog log) {
        log.resetErrors();
        PackageDeclarationAS pd = this.getParser().parse(new StringReader(str), log, false);
        if (log.hasErrors()) {
            return null;
        }
        return pd;
    }

    @Override
    public PackageDeclarationAS parse(String str, ILog log, boolean debug) {
        PackageDeclarationAS pd = this.getParser().parse(new StringReader(str), log, debug);
        if (log.hasErrors()) {
            return null;
        }
        return pd;
    }

    @Override
    public PackageDeclarationAS parse(Reader input) {
        return this.parse(input, this.getLog());
    }

    @Override
    public PackageDeclarationAS parse(Reader input, ILog log) {
        PackageDeclarationAS pd = this.getParser().parse(input, log, this.getDebug());
        if (log.hasErrors()) {
            return null;
        }
        return pd;
    }

    @Override
    public List analyse(PackageDeclarationAS pd) {
        return this.analyse(pd, this.getLog());
    }

    @Override
    public List analyse(PackageDeclarationAS pd, ILog log) {
        Environment env = this.environment();
        return this.analyse(pd, env, log);
    }

    @Override
    public List analyse(PackageDeclarationAS pd, Environment env, ILog log) {
        if (pd == null) {
            return null;
        }
        List contextDecls = this.getAnalyser().analyse(pd, env, log, this.getDebug());
        if (log.hasErrors()) {
            return null;
        }
        return contextDecls;
    }

    @Override
    public List analyse(String str) {
        return this.analyse(str, this.getLog());
    }

    @Override
    public List analyse(String str, ILog log) {
        PackageDeclarationAS pd = this.parse(str, log);
        return this.analyse(pd, log);
    }

    @Override
    public List analyse(Reader reader) {
        return this.analyse(reader, this.getLog());
    }

    @Override
    public List analyse(Reader reader, ILog log) {
        PackageDeclarationAS pd = this.parse(reader, log);
        return this.analyse(pd, log);
    }

    @Override
    public List analyse(String str, Environment env, ILog log) {
        PackageDeclarationAS pd = this.parse(str, log);
        return this.analyse(pd, env, log);
    }

    @Override
    public List analyse(Reader reader, Environment env, ILog log) {
        PackageDeclarationAS pd = this.parse(reader, log);
        return this.analyse(pd, env, log);
    }

    @Override
    public List evaluate(String str) {
        List cs;
        ILog log = this.getLog();
        if (!str.startsWith("context")) {
            str = "context OclVoid inv: " + str;
        }
        if ((cs = this.analyse(str)) == null) {
            return null;
        }
        Vector result = new Vector();
        for (ContextDeclaration decl : cs) {
            Map declRes = this.getEvaluator().evaluate(decl, this.runtimeEnvironment("self", this.getStdLibAdapter().Undefined()), log);
            result.addAll(declRes.values());
        }
        return result;
    }

    @Override
    public List evaluate(String str, Object self) {
        ILog log = this.getLog();
        return this.evaluate(str, self, log);
    }

    @Override
    public List evaluate(String str, Object self, ILog log) {
        List cs = this.analyse(str, log);
        if (cs == null) {
            return null;
        }
        Vector result = new Vector();
        for (ContextDeclaration decl : cs) {
            Map declRes = this.getEvaluator().evaluate(decl, this.runtimeEnvironment("self", self), log);
            result.addAll(declRes.values());
        }
        return result;
    }

    @Override
    public List evaluate(Reader reader, Object self, ILog log) {
        List cs = this.analyse(reader, log);
        if (cs == null) {
            return null;
        }
        Vector result = new Vector();
        for (ContextDeclaration decl : cs) {
            Map declRes = this.getEvaluator().evaluate(decl, this.runtimeEnvironment("self", self), log);
            result.addAll(declRes.values());
        }
        return result;
    }

    @Override
    public Map evaluateAll(Reader reader, Object self, ILog log) {
        List cs = this.analyse(reader, log);
        if (cs == null) {
            return null;
        }
        HashMap result = new HashMap();
        for (ContextDeclaration decl : cs) {
            Map declRes = this.getEvaluator().evaluate(decl, this.runtimeEnvironment("self", self), log);
            result.putAll(declRes);
        }
        return result;
    }

    @Override
    public List evaluate(Reader reader, Object self) {
        ILog log = this.getLog();
        return this.evaluate(reader, (Object)log);
    }

    @Override
    public List evaluate(String str, Environment env, RuntimeEnvironment renv, ILog log) {
        this.renv_ = renv;
        List cs = this.analyse(str, env, log);
        if (cs == null) {
            return null;
        }
        Vector result = new Vector();
        for (ContextDeclaration decl : cs) {
            Map declRes = this.getEvaluator().evaluate(decl, renv, log);
            result.addAll(declRes.values());
        }
        return result;
    }

    @Override
    public List evaluate_2(String str, Environment env, RuntimeEnvironment renv, ILog log) {
        return null;
    }

    @Override
    public List evaluate(Reader reader, Environment env, RuntimeEnvironment renv, ILog log) {
        this.renv_ = renv;
        List cs = this.analyse(reader, env, log);
        if (cs == null) {
            return null;
        }
        Vector result = new Vector();
        for (ContextDeclaration decl : cs) {
            Map declRes = this.getEvaluator().evaluate(decl, renv, log);
            result.addAll(declRes.values());
        }
        return result;
    }

    @Override
    public OclAny evaluateAsOCL(String str, Environment env, RuntimeEnvironment renv, ILog log) {
        List cs = this.analyse(str, env, log);
        if (cs == null) {
            return null;
        }
        Vector<OclAny> results = new Vector<OclAny>();
        for (ContextDeclaration decl : cs) {
            for (Constraint constraint : decl.getConstraint()) {
                if (ConstraintKind$Class.DEF.equals(constraint.getKind())) continue;
                OclAny x = this.getEvaluator().evaluateAsOCL(decl, renv, log);
                results.add(x);
            }
        }
        return (OclAny)results.get(0);
    }

    @Override
    public List generate(String str, String indent) {
        this.getLog();
        List cs = this.analyse(str);
        if (cs == null) {
            return null;
        }
        Vector result = new Vector();
        for (ContextDeclaration decl : cs) {
            List declRes = this.getGenerator().generate(decl, indent, (OclProcessor)this);
            result.addAll(declRes);
        }
        return result;
    }

    @Override
    public List generate(String str, String indent, ILog log) {
        List cs = this.analyse(str, log);
        if (cs == null) {
            return null;
        }
        Vector result = new Vector();
        for (ContextDeclaration decl : cs) {
            List declRes = this.getGenerator().generate(decl, indent, (OclProcessor)this);
            result.addAll(declRes);
        }
        return result;
    }

    @Override
    public List generate(Reader reader, String indent) {
        ILog log = this.getLog();
        List cs = this.analyse(reader, log);
        if (cs == null) {
            return null;
        }
        Vector result = new Vector();
        for (ContextDeclaration decl : cs) {
            List declRes = this.getGenerator().generate(decl, indent, (OclProcessor)this);
            result.addAll(declRes);
        }
        return result;
    }

    @Override
    public List generate(Reader reader, String indent, ILog log) {
        List cs = this.analyse(reader, log);
        if (cs == null) {
            return null;
        }
        Vector result = new Vector();
        for (ContextDeclaration decl : cs) {
            List declRes = this.getGenerator().generate(decl, indent, (OclProcessor)this);
            result.addAll(declRes);
        }
        return result;
    }

    @Override
    public List generate(String str, String indent, Environment env, ILog log) {
        List cs = this.analyse(str, env, log);
        if (cs == null) {
            return null;
        }
        Vector result = new Vector();
        for (ContextDeclaration decl : cs) {
            List declRes = this.getGenerator().generate(decl, indent, (OclProcessor)this);
            result.addAll(declRes);
        }
        return result;
    }

    @Override
    public List generate(Reader reader, String indent, Environment env, ILog log) {
        List cs = this.analyse(reader, env, log);
        if (cs == null) {
            return null;
        }
        Vector result = new Vector();
        for (ContextDeclaration decl : cs) {
            List declRes = this.getGenerator().generate(decl, indent, (OclProcessor)this);
            result.addAll(declRes);
        }
        return result;
    }

    @Override
    public void generate(Reader input, PrintWriter output, String pkgName, String outClassName, ILog log) {
        try {
            OclToStringVisitorImpl toStringVisitor = new OclToStringVisitorImpl();
            output.println("package " + pkgName + ";");
            output.println();
            output.println("public class " + outClassName + " {");
            output.println(this.defsMethod());
            int invCount = 0;
            String tab = "\t";
            try {
                List cs = this.analyse(input, log);
                if (cs != null) {
                    HashMap contexts = new HashMap();
                    HashMap defs = new HashMap();
                    for (ContextDeclaration decl : cs) {
                        if (decl == null || !(decl instanceof ClassifierContextDecl)) continue;
                        OclModelElementType selfType = (OclModelElementType)decl.getReferredNamespace();
                        if (contexts.get(selfType) == null) {
                            contexts.put(selfType, new Vector());
                        }
                        ((List)contexts.get(selfType)).add(decl);
                        for (Constraint cons : decl.getConstraint()) {
                            if (cons.getKind() != ConstraintKind$Class.DEF) continue;
                            if (defs.get(selfType) == null) {
                                defs.put(selfType, new Vector());
                            }
                            ((List)defs.get(selfType)).add(cons);
                        }
                    }
                    for (OclModelElementType selfType : defs.keySet()) {
                        List l = (List)defs.get(selfType);
                        for (Constraint cons : l) {
                            OclAnyImpl result;
                            Class selfCls;
                            Class retType;
                            String defName;
                            if (cons.getDefProperty() != null) {
                                defName = cons.getDefProperty().getName();
                                retType = (Class)cons.getDefProperty().getType().getDelegate();
                                selfCls = (Class)selfType.getDelegate();
                                result = (OclAnyImpl)this.getGenerator().generate(cons, String.valueOf(tab) + tab + tab + tab, (OclProcessor)this);
                                output.println(String.valueOf(tab) + "public static " + retType.getName() + " " + defName + "(" + selfCls.getName() + " self) {");
                                output.println(String.valueOf(tab) + tab + "/*\n " + cons.accept(toStringVisitor, new HashMap()) + "\n*/");
                                output.print(result.getInitialisation());
                                output.println(String.valueOf(tab) + tab + "return " + result.asJavaObject() + ";");
                                output.println(String.valueOf(tab) + "}");
                                continue;
                            }
                            if (cons.getDefOperation() == null) continue;
                            defName = cons.getDefOperation().getName();
                            retType = (Class)cons.getDefOperation().getReturnType().getDelegate();
                            selfCls = (Class)selfType.getDelegate();
                            result = (OclAnyImpl)this.getGenerator().generate(cons, String.valueOf(tab) + tab + tab + tab, (OclProcessor)this);
                            output.println(String.valueOf(tab) + "public static " + retType.getName() + " " + defName + "(" + selfCls.getName() + " self");
                            int pi = 0;
                            while (pi < cons.getDefOperation().getParameterNames().size()) {
                                String pName = (String)cons.getDefOperation().getParameterNames().get(pi);
                                Classifier pType = (Classifier)cons.getDefOperation().getParameterTypes().get(pi);
                                Class pClass = (Class)pType.getDelegate();
                                output.println(", " + pClass.getName() + " " + pName);
                                ++pi;
                            }
                            output.println(") {");
                            output.println(String.valueOf(tab) + tab + "/*\n " + cons.accept(toStringVisitor, new HashMap()) + "\n*/");
                            output.print(result.getInitialisation());
                            output.println(String.valueOf(tab) + tab + "return " + result.asJavaObject() + ";");
                            output.println(String.valueOf(tab) + "}");
                        }
                    }
                    output.println();
                    for (OclModelElementType selfType : contexts.keySet()) {
                        String selfTypeImplName = ((Class)selfType.getDelegate()).getName();
                        Vector<String> invNames = new Vector<String>();
                        String clsName = selfTypeImplName.substring(selfTypeImplName.lastIndexOf(".") + 1);
                        output.println(String.valueOf(tab) + "public static class " + clsName + " {");
                        List list = (List)contexts.get(selfType);
                        for (ContextDeclaration decl : list) {
                            List cons = decl.getConstraint();
                            for (Constraint con : cons) {
                                if (con.getKind() != ConstraintKind$Class.INV) continue;
                                String invName = con.getName();
                                if (invName == null || invName.length() == 0) {
                                    invName = "inv$" + invCount++;
                                }
                                con.setName(invName);
                                invNames.add(invName);
                                OclAnyImpl result = (OclAnyImpl)this.getGenerator().generate(con, String.valueOf(tab) + tab + tab + tab, (OclProcessor)this);
                                Class resType = (Class)con.getBodyExpression().getType().getDelegate();
                                output.println(String.valueOf(tab) + tab + "public static " + resType.getName() + " " + invName + "(" + selfTypeImplName + " self) {");
                                output.println(String.valueOf(tab) + tab + tab + "/*\n " + con.accept(toStringVisitor, new HashMap()) + "\n*/");
                                output.println(String.valueOf(tab) + tab + tab + "try {");
                                output.print(result.getInitialisation());
                                output.println(String.valueOf(tab) + tab + tab + tab + "return " + result.asJavaObject() + ";");
                                output.println(String.valueOf(tab) + tab + tab + "} catch (Exception e) {");
                                output.println(String.valueOf(tab) + tab + tab + tab + "return null;");
                                output.println(String.valueOf(tab) + tab + tab + "}");
                                output.println(String.valueOf(tab) + tab + "}");
                            }
                        }
                        output.println(String.valueOf(tab) + tab + "public static java.util.Map evaluateAll(" + selfTypeImplName + " self) {");
                        output.println(String.valueOf(tab) + tab + tab + "java.util.Map result = new java.util.HashMap();");
                        for (String invName : invNames) {
                            output.println(String.valueOf(tab) + tab + tab + "result.put(\"" + invName + "\"," + invName + "(self));");
                        }
                        output.println(String.valueOf(tab) + tab + tab + "return result;");
                        output.println(String.valueOf(tab) + tab + "}");
                        output.println(String.valueOf(tab) + "}");
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            output.println("}");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    String defsMethod() {
        String s = "static public Object def(String propertyName, Object[] args) {\njava.lang.reflect.Method m = null;\nObject res = null;\nClass[] types = uk.ac.kent.cs.kmf.util.reflection.BetterMethodFinder.getParameterTypesFrom(args);\ntry {\n\tm = new uk.ac.kent.cs.kmf.util.reflection.BetterMethodFinder(Invariants.class).findMethod(propertyName, types);\n} catch (NoSuchMethodException e) {\n\t//e.printStackTrace();\n\tSystem.err.println(\"Error: No property \"+propertyName+\" defined for \"+args[0].getClass());\n}\nif (m != null) {\n\ttry {\n\t\tres = m.invoke(null, args);\n\t} catch (IllegalArgumentException e1) {\n\t\t//e1.printStackTrace();\n\t} catch (IllegalAccessException e1) {\n\t\t//e1.printStackTrace();\n\t} catch (java.lang.reflect.InvocationTargetException e1) {\n\t\t//e1.printStackTrace();\n\t}\n}\nreturn res;\n}\n";
        return s;
    }

    @Override
    public Environment environment(String name, Object obj) {
        Classifier type = this.getBridgeFactory().buildClassifier(obj);
        Environment env = this.environment();
        return env.addVariableDeclaration(name, type, Boolean.TRUE);
    }

    @Override
    public Environment environment() {
        Environment env = this.getBridgeFactory().buildEnvironment();
        env = env.addElement("OclType", this.getTypeFactory().buildTypeType(null), Boolean.FALSE);
        env = env.addElement("OclAny", this.getTypeFactory().buildOclAnyType(), Boolean.FALSE);
        env = env.addElement("OclVoid", this.getTypeFactory().buildVoidType(), Boolean.FALSE);
        env = env.addElement("Real", this.getTypeFactory().buildRealType(), Boolean.FALSE);
        env = env.addElement("Integer", this.getTypeFactory().buildIntegerType(), Boolean.FALSE);
        env = env.addElement("String", this.getTypeFactory().buildStringType(), Boolean.FALSE);
        env = env.addElement("Boolean", this.getTypeFactory().buildBooleanType(), Boolean.FALSE);
        Iterator i = this.getModels().iterator();
        while (i.hasNext()) {
            Namespace ns = this.getBridgeFactory().buildNamespace(i.next());
            env = env.addNamespace(ns);
        }
        return env;
    }

    @Override
    public RuntimeEnvironment runtimeEnvironment(String name, Object eobj) {
        RuntimeEnvironmentImpl renv = new RuntimeEnvironmentImpl();
        renv.setValue(name, eobj);
        return renv;
    }

    @Override
    public RuntimeEnvironment runtimeEnvironment() {
        RuntimeEnvironmentImpl renv = new RuntimeEnvironmentImpl();
        return renv;
    }

    @Override
    public RuntimeEnvironment getRuntimeEnvironment() {
        return this.renv_;
    }
}

