/*
 * Decompiled with CFR 0.152.
 */
package org.oslo.ocl20.generation.lib;

import org.oslo.ocl20.generation.lib.OclAnyImpl;
import org.oslo.ocl20.generation.lib.OclBooleanImpl;
import org.oslo.ocl20.generation.lib.OclCollectionImpl;
import org.oslo.ocl20.generation.lib.OclOrderedSetImpl;
import org.oslo.ocl20.generation.lib.OclSetImpl;
import org.oslo.ocl20.generation.lib.OclTypeImpl;
import org.oslo.ocl20.generation.lib.StdLibGenerationAdapterImpl;
import org.oslo.ocl20.semantics.bridge.Classifier;
import org.oslo.ocl20.semantics.model.types.BagType;
import org.oslo.ocl20.semantics.model.types.CollectionType;
import org.oslo.ocl20.semantics.model.types.OclAnyType;
import org.oslo.ocl20.standard.lib.OclAny;
import org.oslo.ocl20.standard.lib.OclBag;
import org.oslo.ocl20.standard.lib.OclBoolean;
import org.oslo.ocl20.standard.lib.OclInteger;
import org.oslo.ocl20.standard.lib.OclOrderedSet;
import org.oslo.ocl20.standard.lib.OclSet;
import org.oslo.ocl20.standard.lib.OclType;
import org.oslo.ocl20.standard.lib.OclVisitor;
import org.oslo.ocl20.synthesis.OclCodeGeneratorVisitorImpl;

public class OclBagImpl
extends OclCollectionImpl
implements OclBag {
    protected OclBagImpl(Classifier eT, OclAny[] array, StdLibGenerationAdapterImpl adapter) {
        super(eT, adapter);
        this._currentVariableName = StdLibGenerationAdapterImpl.newTempVar();
        this._init = "java.util.Collection " + this._currentVariableName + " = new java.util.Vector();\n";
        super.addParts(array, eT);
    }

    protected OclBagImpl(Classifier eT, String bag, StdLibGenerationAdapterImpl adapter, boolean newVariable) {
        super(eT, adapter);
        if (newVariable) {
            this._currentVariableName = StdLibGenerationAdapterImpl.newTempVar("bag");
            this._init = "java.util.Collection " + this._currentVariableName + "=new java.util.Vector(" + bag + ");\n";
        } else {
            this._currentVariableName = bag;
        }
    }

    @Override
    protected String implementation() {
        return this._currentVariableName;
    }

    protected String bag_impl() {
        return this._currentVariableName;
    }

    @Override
    public OclType oclType() {
        BagType type = this.adapter.getProcessor().getTypeFactory().buildBagType(super.getElementType());
        OclTypeImpl ot = (OclTypeImpl)this.adapter.Type(type);
        ot.setInitialisation(String.valueOf(this.getInitialisation()) + ot.getInitialisation());
        return ot;
    }

    @Override
    public OclBoolean equalTo(OclBag bag2) {
        OclBooleanImpl result = (OclBooleanImpl)this.adapter.Boolean(false);
        if (bag2 instanceof OclBagImpl) {
            OclBagImpl s2 = (OclBagImpl)bag2;
            result = (OclBooleanImpl)this.adapter.Boolean("new java.lang.Boolean(" + this + ".size()==" + bag2 + ".size() && " + this + ".containsAll(" + bag2 + ") && " + bag2 + ".containsAll(" + this + "))", true);
            result._init = String.valueOf(this._init) + s2._init + result._init;
        }
        return result;
    }

    @Override
    public OclBoolean notEqualTo(OclBag bag2) {
        return this.equalTo(bag2).not();
    }

    @Override
    public OclBag union(OclBag bag2) {
        if (bag2 instanceof OclBagImpl) {
            OclBagImpl bag = (OclBagImpl)bag2;
            OclBagImpl result = (OclBagImpl)this.adapter.Bag(this.getElementType());
            result._init = String.valueOf(this._init) + bag._init + result._init;
            result._init = String.valueOf(result._init) + result + ".addAll(" + this + ");\n";
            result._init = String.valueOf(result._init) + result + ".addAll(" + bag + ");\n";
            return result;
        }
        return null;
    }

    @Override
    public OclBag union(OclSet s) {
        if (s instanceof OclSetImpl) {
            OclSetImpl set = (OclSetImpl)s;
            OclBagImpl result = (OclBagImpl)this.adapter.Bag(this.getElementType());
            result._init = String.valueOf(this._init) + set._init + result._init;
            result._init = String.valueOf(result._init) + result + ".addAll(" + this + ");\n";
            result._init = String.valueOf(result._init) + result + ".addAll(" + set + ");\n";
            return result;
        }
        return null;
    }

    @Override
    public OclBag union(OclOrderedSet s) {
        if (s instanceof OclOrderedSetImpl) {
            OclOrderedSetImpl set = (OclOrderedSetImpl)s;
            OclBagImpl result = (OclBagImpl)this.adapter.Bag(this.getElementType());
            result._init = String.valueOf(this._init) + set._init + result._init;
            result._init = String.valueOf(result._init) + result + ".addAll(" + this + ");\n";
            result._init = String.valueOf(result._init) + result + ".addAll(" + set + ");\n";
            return result;
        }
        return null;
    }

    @Override
    public OclBag intersection(OclBag bag2) {
        OclBagImpl result = (OclBagImpl)this.adapter.Bag(this.getElementType());
        result._init = String.valueOf(this._init) + ((OclBagImpl)bag2).getInitialisation() + "// intersection\n" + result._init;
        String it1 = StdLibGenerationAdapterImpl.newTempVar();
        result._init = String.valueOf(result._init) + "java.util.Iterator " + it1 + " = " + this + ".iterator();\n";
        result._init = String.valueOf(result._init) + "while (" + it1 + ".hasNext()) {\n";
        result._init = String.valueOf(result._init) + "  Object o = " + it1 + ".next();\n";
        result._init = String.valueOf(result._init) + "  if (" + bag2 + ".contains(o)) " + result + ".add(o);\n";
        result._init = String.valueOf(result._init) + "}\n";
        result._init = String.valueOf(result._init) + it1 + " = " + bag2 + ".iterator();\n";
        result._init = String.valueOf(result._init) + "while (" + it1 + ".hasNext()) {\n";
        result._init = String.valueOf(result._init) + "  Object o = " + it1 + ".next();\n";
        result._init = String.valueOf(result._init) + "  if (" + this + ".contains(o)) " + result + ".add(o);\n";
        result._init = String.valueOf(result._init) + "}\n";
        return result;
    }

    @Override
    public OclSet intersection(OclSet set) {
        return this.intersection(set.asBag()).asSet();
    }

    @Override
    public OclOrderedSet intersection(OclOrderedSet set) {
        return this.intersection(set.asOrderedSet());
    }

    @Override
    public OclBag including(OclAny object) {
        if (object instanceof OclAnyImpl) {
            OclAnyImpl obj = (OclAnyImpl)object;
            String resultVar = OclCodeGeneratorVisitorImpl.newTempVar();
            String str = "java.util.Collection " + resultVar + " = new java.util.Vector(" + this + ");\n";
            String t = StdLibGenerationAdapterImpl.newTempVar("obj");
            str = String.valueOf(str) + "Object " + t + "=" + obj.asJavaObject() + "\n;";
            str = String.valueOf(str) + "if (" + t + "!=null) " + resultVar + ".add(" + t + ");\n";
            OclBagImpl result = (OclBagImpl)this.adapter.Bag(this.getElementType(), resultVar);
            result._init = String.valueOf(this._init) + obj._init + str;
            return result;
        }
        return null;
    }

    @Override
    public OclBag excluding(OclAny object) {
        if (object instanceof OclAnyImpl) {
            OclAnyImpl obj = (OclAnyImpl)object;
            String resultVar = OclCodeGeneratorVisitorImpl.newTempVar();
            OclCodeGeneratorVisitorImpl.newTempVar();
            String str = "java.util.Collection " + resultVar + " = new java.util.Vector(" + this + ");\n";
            str = String.valueOf(str) + resultVar + ".remove(" + obj.asJavaObject() + ");\n";
            OclBagImpl result = (OclBagImpl)this.adapter.Bag(this.getElementType(), resultVar);
            result._init = String.valueOf(this._init) + obj._init + str;
            return result;
        }
        return null;
    }

    @Override
    public OclInteger count(OclAny object) {
        return super.count(object);
    }

    @Override
    public OclBag flatten() {
        OclBagImpl result = (OclBagImpl)this.adapter.Bag(this.getElementType());
        OclBagImpl col = (OclBagImpl)this.adapter.Bag(this.getElementType());
        OclAnyType oat = this.adapter.getProcessor().getTypeFactory().buildOclAnyType();
        if (this.getElementType() instanceof CollectionType || this.getElementType().equals(oat)) {
            return (OclBag)super.flatten(result, col);
        }
        return this.asBag();
    }

    public Object accept(OclVisitor v, Object obj) {
        return v.visit(this, obj);
    }

    public String toString() {
        return this._currentVariableName;
    }

    @Override
    public Object clone() {
        return this.adapter.Bag(this.getElementType(), this.implementation());
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof OclBag) {
            OclBoolean b = this.equalTo((OclBag)o);
            return (Boolean)b.asJavaObject();
        }
        return false;
    }

    @Override
    public Object asJavaObject() {
        return this.toString();
    }
}

