/*
 * Decompiled with CFR 0.152.
 */
package org.oslo.ocl20.generation.lib;

import org.oslo.ocl20.generation.lib.OclAnyImpl;
import org.oslo.ocl20.generation.lib.OclBooleanImpl;
import org.oslo.ocl20.generation.lib.OclRealImpl;
import org.oslo.ocl20.generation.lib.StdLibGenerationAdapterImpl;
import org.oslo.ocl20.standard.lib.OclAny;
import org.oslo.ocl20.standard.lib.OclBoolean;
import org.oslo.ocl20.standard.lib.OclInteger;
import org.oslo.ocl20.standard.lib.OclReal;
import org.oslo.ocl20.standard.lib.OclVisitor;

public class OclIntegerImpl
extends OclRealImpl
implements OclInteger {
    String _int_impl;

    public OclIntegerImpl(String i, StdLibGenerationAdapterImpl adapter, boolean newVariable) {
        super(i, adapter, newVariable);
        if (newVariable) {
            this._int_impl = StdLibGenerationAdapterImpl.newTempVar("int");
            this._init = "java.lang.Integer " + this._int_impl + "=" + i + ";\n";
        } else {
            this._int_impl = i;
        }
    }

    public String int_impl() {
        return this._int_impl;
    }

    public OclBoolean equalTo(OclInteger i2) {
        return super.equalTo(i2);
    }

    @Override
    public OclInteger inegate() {
        OclIntegerImpl res = (OclIntegerImpl)this.adapter.Integer("(-" + this + ")");
        res.setInitialisation(this.getInitialisation());
        return res;
    }

    @Override
    public OclInteger add(OclInteger i2) {
        OclIntegerImpl res = (OclIntegerImpl)this.adapter.Integer("(" + this + " + " + i2 + ")");
        res.setInitialisation(String.valueOf(this.getInitialisation()) + ((OclIntegerImpl)i2).getInitialisation());
        return res;
    }

    @Override
    public OclInteger subtract(OclInteger i2) {
        OclIntegerImpl res = (OclIntegerImpl)this.adapter.Integer("(" + this + " - " + i2 + ")");
        res.setInitialisation(String.valueOf(this.getInitialisation()) + ((OclIntegerImpl)i2).getInitialisation());
        return res;
    }

    @Override
    public OclInteger multiply(OclInteger i2) {
        OclIntegerImpl res = (OclIntegerImpl)this.adapter.Integer("(" + this + " * " + i2 + ")");
        res.setInitialisation(String.valueOf(this.getInitialisation()) + ((OclIntegerImpl)i2).getInitialisation());
        return res;
    }

    @Override
    public OclReal divide(OclInteger i2) {
        OclRealImpl res = (OclRealImpl)this.adapter.Real("(" + this + ".0 / " + i2 + ")");
        res.setInitialisation(String.valueOf(this.getInitialisation()) + ((OclIntegerImpl)i2).getInitialisation());
        return res;
    }

    public OclInteger iabs() {
        OclIntegerImpl res = (OclIntegerImpl)this.adapter.Integer("Math.abs(" + this + ")");
        res.setInitialisation(this.getInitialisation());
        return res;
    }

    @Override
    public OclInteger div(OclInteger i2) {
        OclIntegerImpl res = (OclIntegerImpl)this.adapter.Integer("(" + this + " / " + i2 + ")");
        res.setInitialisation(String.valueOf(this.getInitialisation()) + ((OclIntegerImpl)i2).getInitialisation());
        return res;
    }

    @Override
    public OclInteger mod(OclInteger i2) {
        OclIntegerImpl res = (OclIntegerImpl)this.adapter.Integer("(" + this + " % " + i2 + ")");
        res.setInitialisation(String.valueOf(this.getInitialisation()) + ((OclIntegerImpl)i2).getInitialisation());
        return res;
    }

    @Override
    public OclInteger max(OclInteger i2) {
        OclIntegerImpl res = (OclIntegerImpl)this.adapter.Integer("Math.max(" + this + ", " + i2 + ")");
        res.setInitialisation(String.valueOf(this.getInitialisation()) + ((OclIntegerImpl)i2).getInitialisation());
        return res;
    }

    @Override
    public OclInteger min(OclInteger i2) {
        OclIntegerImpl res = (OclIntegerImpl)this.adapter.Integer("Math.min(" + this + ", " + i2 + ")");
        res.setInitialisation(String.valueOf(this.getInitialisation()) + ((OclIntegerImpl)i2).getInitialisation());
        return res;
    }

    @Override
    public OclBoolean equalTo(OclAny i2) {
        OclBooleanImpl res = (OclBooleanImpl)super.equalTo((OclReal)i2);
        if (!(i2 instanceof OclReal)) {
            res = (OclBooleanImpl)this.adapter.Boolean(false);
        }
        res.setInitialisation(String.valueOf(this.getInitialisation()) + ((OclAnyImpl)i2).getInitialisation());
        return res;
    }

    @Override
    public Object asJavaObject() {
        return "new Integer(" + this.int_impl() + ")";
    }

    @Override
    public Object accept(OclVisitor v, Object obj) {
        return v.visit(this, obj);
    }

    @Override
    public String toString() {
        return this.int_impl();
    }

    @Override
    public boolean equals(Object i) {
        if (!(i instanceof OclIntegerImpl)) {
            return false;
        }
        return this.int_impl() == ((OclIntegerImpl)i).int_impl();
    }

    @Override
    public int hashCode() {
        return this.int_impl().hashCode();
    }

    @Override
    public Object clone() {
        return this.adapter.Integer(this.int_impl());
    }
}

