/*
 * Decompiled with CFR 0.152.
 */
package org.oslo.ocl20.generation.lib;

import org.oslo.ocl20.generation.lib.OclAnyImpl;
import org.oslo.ocl20.generation.lib.OclBooleanImpl;
import org.oslo.ocl20.generation.lib.OclIntegerImpl;
import org.oslo.ocl20.generation.lib.OclTypeImpl;
import org.oslo.ocl20.generation.lib.StdLibGenerationAdapterImpl;
import org.oslo.ocl20.semantics.model.types.RealType;
import org.oslo.ocl20.standard.lib.OclBoolean;
import org.oslo.ocl20.standard.lib.OclInteger;
import org.oslo.ocl20.standard.lib.OclReal;
import org.oslo.ocl20.standard.lib.OclType;
import org.oslo.ocl20.standard.lib.OclVisitor;

public class OclRealImpl
extends OclAnyImpl
implements OclReal {
    String _implementation;

    protected OclRealImpl(String r, StdLibGenerationAdapterImpl adapter, boolean newVariable) {
        super(adapter);
        if (newVariable) {
            this._implementation = StdLibGenerationAdapterImpl.newTempVar("real");
            this._init = "java.lang.Double " + this._implementation + "=" + r + ";\n";
        } else {
            this._implementation = r;
        }
    }

    public String implementation() {
        return this._implementation;
    }

    @Override
    public OclType oclType() {
        RealType type = this.adapter.getProcessor().getTypeFactory().buildRealType();
        OclTypeImpl ot = (OclTypeImpl)this.adapter.Type(type);
        ot.setInitialisation(String.valueOf(this.getInitialisation()) + ot.getInitialisation());
        return ot;
    }

    public OclBoolean equalTo(OclReal r2) {
        OclBooleanImpl res = (OclBooleanImpl)this.adapter.Boolean("new java.lang.Boolean(" + this.implementation() + " == " + r2 + ")", true);
        res.setInitialisation(String.valueOf(this.getInitialisation()) + ((OclRealImpl)r2).getInitialisation() + res._init);
        return res;
    }

    public OclBoolean notEqualTo(OclReal r2) {
        OclBooleanImpl res = (OclBooleanImpl)this.adapter.Boolean("new java.lang.Boolean(" + this.implementation() + " != " + r2 + ")", true);
        res.setInitialisation(String.valueOf(this.getInitialisation()) + ((OclRealImpl)r2).getInitialisation() + res._init);
        return res;
    }

    @Override
    public Object asJavaObject() {
        return "new Double(" + this.implementation() + ")";
    }

    @Override
    public OclReal add(OclReal r2) {
        OclRealImpl res = (OclRealImpl)this.adapter.Real("(" + this.implementation() + " + " + r2 + ")");
        res.setInitialisation(String.valueOf(this.getInitialisation()) + ((OclRealImpl)r2).getInitialisation());
        return res;
    }

    @Override
    public OclReal subtract(OclReal r2) {
        OclRealImpl res = (OclRealImpl)this.adapter.Real("(" + this.implementation() + " - " + r2 + ")");
        res.setInitialisation(String.valueOf(this.getInitialisation()) + ((OclRealImpl)r2).getInitialisation());
        return res;
    }

    @Override
    public OclReal multiply(OclReal r2) {
        OclRealImpl res = (OclRealImpl)this.adapter.Real("(" + this.implementation() + " * " + r2 + ")");
        res.setInitialisation(String.valueOf(this.getInitialisation()) + ((OclRealImpl)r2).getInitialisation());
        return res;
    }

    @Override
    public OclReal negate() {
        OclRealImpl res = (OclRealImpl)this.adapter.Real("(-" + this.implementation() + ")");
        res.setInitialisation(this.getInitialisation());
        return res;
    }

    @Override
    public OclReal divide(OclReal r2) {
        OclRealImpl res = (OclRealImpl)this.adapter.Real("(" + this.implementation() + " / " + r2 + ")");
        res.setInitialisation(String.valueOf(this.getInitialisation()) + ((OclRealImpl)r2).getInitialisation());
        return res;
    }

    @Override
    public OclReal abs() {
        OclRealImpl res = (OclRealImpl)this.adapter.Real("Math.abs(" + this.implementation() + ")");
        res.setInitialisation(this.getInitialisation());
        return res;
    }

    @Override
    public OclInteger floor() {
        OclIntegerImpl res = (OclIntegerImpl)this.adapter.Integer("((int) Math.floor(" + this.implementation() + "))");
        res.setInitialisation(this.getInitialisation());
        return res;
    }

    @Override
    public OclInteger round() {
        OclIntegerImpl res = (OclIntegerImpl)this.adapter.Integer("((int) Math.round(" + this.implementation() + "))");
        res.setInitialisation(this.getInitialisation());
        return res;
    }

    @Override
    public OclReal max(OclReal r2) {
        OclRealImpl res = (OclRealImpl)this.adapter.Real("Math.max(" + this.implementation() + ", " + r2 + ")");
        res.setInitialisation(String.valueOf(this.getInitialisation()) + ((OclRealImpl)r2).getInitialisation());
        return res;
    }

    @Override
    public OclReal min(OclReal r2) {
        OclRealImpl res = (OclRealImpl)this.adapter.Real("Math.min(" + this.implementation() + ", " + r2 + ")");
        res.setInitialisation(String.valueOf(this.getInitialisation()) + ((OclRealImpl)r2).getInitialisation());
        return res;
    }

    @Override
    public OclBoolean lessThan(OclReal r2) {
        OclBooleanImpl res = (OclBooleanImpl)this.adapter.Boolean("new java.lang.Boolean(" + this.implementation() + " < " + r2 + ")", true);
        res.setInitialisation(String.valueOf(this.getInitialisation()) + ((OclRealImpl)r2).getInitialisation() + res._init);
        return res;
    }

    @Override
    public OclBoolean greaterThan(OclReal r2) {
        OclBooleanImpl res = (OclBooleanImpl)this.adapter.Boolean("new java.lang.Boolean(" + this.implementation() + " > " + r2 + ")", true);
        res.setInitialisation(String.valueOf(this.getInitialisation()) + ((OclRealImpl)r2).getInitialisation() + res._init);
        return res;
    }

    @Override
    public OclBoolean lessThanOrEqualTo(OclReal r2) {
        OclBooleanImpl res = (OclBooleanImpl)this.adapter.Boolean("new java.lang.Boolean(" + this.implementation() + " <= " + r2 + ")", true);
        res.setInitialisation(String.valueOf(this.getInitialisation()) + ((OclRealImpl)r2).getInitialisation() + res._init);
        return res;
    }

    @Override
    public OclBoolean greaterThanOrEqualTo(OclReal r2) {
        OclBooleanImpl res = (OclBooleanImpl)this.adapter.Boolean("new java.lang.Boolean(" + this.implementation() + " >= " + r2 + ")", true);
        res.setInitialisation(String.valueOf(this.getInitialisation()) + ((OclRealImpl)r2).getInitialisation() + res._init);
        return res;
    }

    public Object accept(OclVisitor v, Object obj) {
        return v.visit(this, obj);
    }

    public String toString() {
        return this.implementation();
    }

    @Override
    public boolean equals(Object r) {
        return this == r;
    }

    @Override
    public int hashCode() {
        return this.implementation().hashCode();
    }

    @Override
    public Object clone() {
        return new OclRealImpl(this.implementation(), this.adapter, false);
    }
}

