/*
 * Decompiled with CFR 0.152.
 */
package org.oslo.ocl20.generation.lib;

import org.oslo.ocl20.generation.lib.OclAnyImpl;
import org.oslo.ocl20.generation.lib.OclBagImpl;
import org.oslo.ocl20.generation.lib.OclBooleanImpl;
import org.oslo.ocl20.generation.lib.OclCollectionImpl;
import org.oslo.ocl20.generation.lib.OclOrderedSetImpl;
import org.oslo.ocl20.generation.lib.OclTypeImpl;
import org.oslo.ocl20.generation.lib.StdLibGenerationAdapterImpl;
import org.oslo.ocl20.semantics.bridge.Classifier;
import org.oslo.ocl20.semantics.model.types.CollectionType;
import org.oslo.ocl20.semantics.model.types.OclAnyType;
import org.oslo.ocl20.semantics.model.types.SetType;
import org.oslo.ocl20.standard.lib.OclAny;
import org.oslo.ocl20.standard.lib.OclBag;
import org.oslo.ocl20.standard.lib.OclBoolean;
import org.oslo.ocl20.standard.lib.OclInteger;
import org.oslo.ocl20.standard.lib.OclOrderedSet;
import org.oslo.ocl20.standard.lib.OclSet;
import org.oslo.ocl20.standard.lib.OclType;
import org.oslo.ocl20.standard.lib.OclVisitor;
import org.oslo.ocl20.synthesis.OclCodeGeneratorVisitorImpl;

public class OclSetImpl
extends OclCollectionImpl
implements OclSet {
    public OclSetImpl(Classifier eT, OclAny[] array, StdLibGenerationAdapterImpl adapter) {
        super(eT, adapter);
        this._currentVariableName = StdLibGenerationAdapterImpl.newTempVar();
        this._init = "java.util.Set " + this._currentVariableName + " = new java.util.HashSet();\n";
        super.addParts(array, eT);
    }

    public OclSetImpl(Classifier eT, String set, StdLibGenerationAdapterImpl adapter, boolean newVariable) {
        super(eT, adapter);
        if (newVariable) {
            this._currentVariableName = StdLibGenerationAdapterImpl.newTempVar("set");
            this._init = "java.util.Set " + this._currentVariableName + "=new java.util.HashSet(" + set + ");\n";
        } else {
            this._currentVariableName = set;
        }
    }

    @Override
    public String implementation() {
        return this._currentVariableName;
    }

    protected String set_impl() {
        return this._currentVariableName;
    }

    @Override
    public OclType oclType() {
        SetType type = this.adapter.getProcessor().getTypeFactory().buildSetType(super.getElementType());
        OclTypeImpl ot = (OclTypeImpl)this.adapter.Type(type);
        ot.setInitialisation(String.valueOf(this.getInitialisation()) + ot.getInitialisation());
        return ot;
    }

    @Override
    public OclBoolean equalTo(OclSet set2) {
        OclBooleanImpl result = (OclBooleanImpl)this.adapter.Boolean(false);
        if (set2 instanceof OclSetImpl) {
            OclSetImpl s2 = (OclSetImpl)set2;
            result = (OclBooleanImpl)this.adapter.Boolean("new java.lang.Boolean(" + this + ".equals(" + set2 + "))", true);
            result._init = String.valueOf(this._init) + s2._init + result._init;
        }
        return result;
    }

    @Override
    public OclBoolean notEqualTo(OclSet set2) {
        return this.equalTo(set2).not();
    }

    @Override
    public OclSet union(OclSet s2) {
        if (s2 instanceof OclSetImpl) {
            OclSetImpl set2 = (OclSetImpl)s2;
            OclSetImpl result = (OclSetImpl)this.adapter.Set(this.getElementType());
            result._init = String.valueOf(this._init) + set2._init + result._init;
            result._init = String.valueOf(result._init) + result + ".addAll(" + this + ");\n";
            result._init = String.valueOf(result._init) + result + ".addAll(" + set2 + ");\n";
            return result;
        }
        return null;
    }

    @Override
    public OclBag union(OclBag b) {
        if (b instanceof OclBagImpl) {
            OclBagImpl bag = (OclBagImpl)b;
            OclBagImpl result = (OclBagImpl)this.adapter.Bag(this.getElementType());
            result._init = String.valueOf(this._init) + bag._init + result._init;
            result._init = String.valueOf(result._init) + result + ".addAll(" + this + ");\n";
            result._init = String.valueOf(result._init) + result + ".addAll(" + bag + ");\n";
            return result;
        }
        return null;
    }

    @Override
    public OclSet union(OclOrderedSet s2) {
        if (s2 instanceof OclOrderedSetImpl) {
            OclOrderedSetImpl set2 = (OclOrderedSetImpl)s2;
            OclSetImpl result = (OclSetImpl)this.adapter.Set(this.getElementType());
            result._init = String.valueOf(this._init) + set2._init + result._init;
            result._init = String.valueOf(result._init) + result + ".addAll(" + this + ");\n";
            result._init = String.valueOf(result._init) + result + ".addAll(" + set2 + ");\n";
            return result;
        }
        return null;
    }

    @Override
    public OclSet intersection(OclSet s2) {
        if (s2 instanceof OclSetImpl) {
            OclSetImpl set2 = (OclSetImpl)s2;
            OclSetImpl result = (OclSetImpl)this.adapter.Set(this.getElementType());
            result._init = String.valueOf(this._init) + set2.getInitialisation() + "// intersection\n" + result._init;
            String it1 = StdLibGenerationAdapterImpl.newTempVar();
            result._init = String.valueOf(result._init) + "java.util.Iterator " + it1 + " = " + this + ".iterator();\n";
            result._init = String.valueOf(result._init) + "while (" + it1 + ".hasNext()) {\n";
            result._init = String.valueOf(result._init) + "  Object o = " + it1 + ".next();\n";
            result._init = String.valueOf(result._init) + "  if (" + set2 + ".contains(o)) " + result + ".add(o);\n";
            result._init = String.valueOf(result._init) + "}\n";
            result._init = String.valueOf(result._init) + it1 + " = " + set2 + ".iterator();\n";
            result._init = String.valueOf(result._init) + "while (" + it1 + ".hasNext()) {\n";
            result._init = String.valueOf(result._init) + "  Object o = " + it1 + ".next();\n";
            result._init = String.valueOf(result._init) + "  if (" + this + ".contains(o)) " + result + ".add(o);\n";
            result._init = String.valueOf(result._init) + "}\n";
            return result;
        }
        return null;
    }

    @Override
    public OclSet intersection(OclBag bag) {
        return this.intersection(bag.asSet());
    }

    @Override
    public OclSet intersection(OclOrderedSet set2) {
        return this.intersection(set2.asSet());
    }

    @Override
    public OclSet subtract(OclSet s2) {
        if (s2 instanceof OclSetImpl) {
            OclSetImpl set2 = (OclSetImpl)s2;
            OclSetImpl result = (OclSetImpl)this.adapter.Set(this.getElementType());
            String itVar1 = OclCodeGeneratorVisitorImpl.newTempVar();
            result._init = String.valueOf(result._init) + this.getInitialisation() + set2.getInitialisation();
            result._init = String.valueOf(result._init) + "java.util.Iterator " + itVar1 + " = " + this + ".iterator();\n";
            result._init = String.valueOf(result._init) + "while (" + itVar1 + ".hasNext()) {\n";
            result._init = String.valueOf(result._init) + "  Object o = " + itVar1 + ".next();\n";
            result._init = String.valueOf(result._init) + "  if ( !" + set2 + ".contains(o) ) " + result + ".add(o);\n";
            result._init = String.valueOf(result._init) + "}\n";
            return result;
        }
        return null;
    }

    @Override
    public OclSet including(OclAny object) {
        if (object instanceof OclAnyImpl) {
            OclAnyImpl obj = (OclAnyImpl)object;
            OclSetImpl result = (OclSetImpl)this.adapter.Set(this.getElementType(), this.toString(), true);
            String str = result._init;
            String t = StdLibGenerationAdapterImpl.newTempVar("obj");
            str = String.valueOf(str) + "Object " + t + "=" + obj.asJavaObject() + "\n;";
            str = String.valueOf(str) + "if (" + t + "!=null) " + result + ".add(" + t + ");\n";
            result._init = String.valueOf(this._init) + obj._init + str;
            return result;
        }
        return null;
    }

    @Override
    public OclSet excluding(OclAny object) {
        if (object instanceof OclAnyImpl) {
            OclAnyImpl obj = (OclAnyImpl)object;
            OclSetImpl result = (OclSetImpl)this.adapter.Set(this.getElementType());
            OclCodeGeneratorVisitorImpl.newTempVar();
            String str = result._init;
            str = String.valueOf(str) + result + ".remove(" + obj.asJavaObject() + ");\n";
            result._init = String.valueOf(this._init) + obj._init + str;
            return result;
        }
        return null;
    }

    @Override
    public OclSet symmetricDifference(OclSet s2) {
        if (s2 instanceof OclSetImpl) {
            OclSetImpl set2 = (OclSetImpl)s2;
            OclSetImpl result = (OclSetImpl)this.adapter.Set(this.getElementType());
            String itVar1 = OclCodeGeneratorVisitorImpl.newTempVar();
            result._init = String.valueOf(result._init) + this.getInitialisation() + set2.getInitialisation();
            result._init = String.valueOf(result._init) + "java.util.Iterator " + itVar1 + " = " + this + ".iterator();\n";
            result._init = String.valueOf(result._init) + "while (" + itVar1 + ".hasNext()) {\n";
            result._init = String.valueOf(result._init) + "  Object o = " + itVar1 + ".next();\n";
            result._init = String.valueOf(result._init) + "  if ( ! " + set2 + ".contains(o) ) " + result + ".add(o);\n";
            result._init = String.valueOf(result._init) + "}\n";
            result._init = String.valueOf(result._init) + itVar1 + " = " + set2 + ".iterator();\n";
            result._init = String.valueOf(result._init) + "while (" + itVar1 + ".hasNext()) {\n";
            result._init = String.valueOf(result._init) + "  Object o = " + itVar1 + ".next();\n";
            result._init = String.valueOf(result._init) + "  if ( ! " + this + ".contains(o) ) " + result + ".add(o);\n";
            result._init = String.valueOf(result._init) + "}\n";
            return result;
        }
        return null;
    }

    @Override
    public OclInteger count(OclAny object) {
        return super.count(object);
    }

    @Override
    public OclSet flatten() {
        OclSetImpl result = (OclSetImpl)this.adapter.Set(this.getElementType());
        OclSetImpl col = (OclSetImpl)this.adapter.Set(this.getElementType());
        OclAnyType oat = this.adapter.getProcessor().getTypeFactory().buildOclAnyType();
        if (this.getElementType() instanceof CollectionType || this.getElementType().equals(oat)) {
            return (OclSet)super.flatten(result, col);
        }
        return this.asSet();
    }

    public String toString() {
        return this._currentVariableName;
    }

    @Override
    public Object clone() {
        return this.adapter.Set(this.getElementType(), this.set_impl());
    }

    @Override
    public boolean equals(Object o) {
        return this == o;
    }

    public Object accept(OclVisitor v, Object obj) {
        return v.visit(this, obj);
    }

    @Override
    public Object asJavaObject() {
        return this.toString();
    }
}

