/*
 * Decompiled with CFR 0.152.
 */
package org.oslo.ocl20.generation.lib;

import org.oslo.ocl20.generation.lib.OclAnyImpl;
import org.oslo.ocl20.generation.lib.OclBooleanImpl;
import org.oslo.ocl20.generation.lib.OclTypeImpl;
import org.oslo.ocl20.generation.lib.StdLibGenerationAdapterImpl;
import org.oslo.ocl20.semantics.model.types.StringType;
import org.oslo.ocl20.standard.lib.OclBoolean;
import org.oslo.ocl20.standard.lib.OclInteger;
import org.oslo.ocl20.standard.lib.OclReal;
import org.oslo.ocl20.standard.lib.OclString;
import org.oslo.ocl20.standard.lib.OclType;
import org.oslo.ocl20.standard.lib.OclVisitor;

public class OclStringImpl
extends OclAnyImpl
implements OclString {
    String _implementation;

    public OclStringImpl(String s, StdLibGenerationAdapterImpl adapter, boolean newVariable) {
        super(adapter);
        if (newVariable) {
            this._implementation = StdLibGenerationAdapterImpl.newTempVar("str");
            this._init = "java.lang.String " + this._implementation + "=" + s + ";\n";
        } else {
            this._implementation = s;
        }
    }

    public String implementation() {
        return this._implementation;
    }

    @Override
    public Object asJavaObject() {
        String x = "\\\\";
        String y = "\\\\\\\\";
        return this.implementation().replaceAll(x, y);
    }

    @Override
    public OclType oclType() {
        StringType type = this.adapter.getProcessor().getTypeFactory().buildStringType();
        OclTypeImpl ot = (OclTypeImpl)this.adapter.Type(type);
        ot.setInitialisation(String.valueOf(this.getInitialisation()) + ot.getInitialisation());
        return ot;
    }

    public OclBoolean equalTo(OclString string2) {
        OclBooleanImpl res = (OclBooleanImpl)this.adapter.Boolean("new java.lang.Boolean(" + this + ".equals(" + string2 + "))", true);
        res._init = String.valueOf(this._init) + ((OclStringImpl)string2)._init + res._init;
        return res;
    }

    @Override
    public OclInteger size() {
        return this.adapter.Integer(this + ".length()");
    }

    @Override
    public OclString concat(OclString string2) {
        return this.adapter.String(this + " + " + string2);
    }

    @Override
    public OclString substring(OclInteger lower, OclInteger upper) {
        return this.adapter.String(this + ".substring(" + lower + "-1, " + upper + ")");
    }

    @Override
    public OclInteger toInteger() {
        return this.adapter.Integer("Integer.parseInt(" + this + ")");
    }

    @Override
    public OclReal toReal() {
        return this.adapter.Real("Double.parseDouble(" + this + ")");
    }

    public Object accept(OclVisitor v, Object obj) {
        return v.visit(this, obj);
    }

    public String toString() {
        return this._implementation;
    }

    @Override
    public boolean equals(Object o) {
        return this == o;
    }

    @Override
    public int hashCode() {
        return this.implementation().hashCode();
    }

    @Override
    public Object clone() {
        return this.adapter.String(this._implementation);
    }
}

