/*
 * Decompiled with CFR 0.152.
 */
package org.oslo.ocl20.generation.lib;

import java.util.HashMap;
import java.util.Map;
import org.oslo.ocl20.generation.lib.OclAnyImpl;
import org.oslo.ocl20.generation.lib.OclTypeImpl;
import org.oslo.ocl20.generation.lib.StdLibGenerationAdapterImpl;
import org.oslo.ocl20.semantics.bridge.Classifier;
import org.oslo.ocl20.semantics.model.types.TupleType;
import org.oslo.ocl20.standard.lib.OclAny;
import org.oslo.ocl20.standard.lib.OclString;
import org.oslo.ocl20.standard.lib.OclTuple;
import org.oslo.ocl20.standard.lib.OclType;
import org.oslo.ocl20.standard.lib.OclVisitor;
import org.oslo.ocl20.synthesis.OclCodeGeneratorVisitorImpl;

public class OclTupleImpl
extends OclAnyImpl
implements OclTuple {
    TupleType type;
    String[] _keys;
    Classifier[] _types;
    private String _implementation;
    Map _elementTypes = new HashMap();

    protected OclTupleImpl(TupleType tT, String m, StdLibGenerationAdapterImpl adapter, boolean newVariable) {
        super(adapter);
        this.type = tT;
        this._types = tT.getTypes().toArray(new Classifier[0]);
        this._keys = tT.getNames().toArray(new String[0]);
        int i = 0;
        while (i < this._keys.length) {
            this._elementTypes.put(this._keys[i], this._types[i]);
            ++i;
        }
        if (newVariable) {
            this._implementation = StdLibGenerationAdapterImpl.newTempVar("tuple");
            this._init = "java.util.Map " + this._implementation + "=" + m + ";\n";
        } else {
            this._implementation = m;
        }
    }

    protected OclTupleImpl(TupleType tT, OclAny[] arr, StdLibGenerationAdapterImpl adapter) {
        super(adapter);
        this.type = tT;
        this._types = tT.getTypes().toArray(new Classifier[0]);
        this._keys = tT.getNames().toArray(new String[0]);
        this._implementation = StdLibGenerationAdapterImpl.newTempVar();
        this._init = "java.util.Map " + this._implementation + " = new java.util.HashMap();\n";
        int i = 0;
        while (i < arr.length) {
            this._elementTypes.put(this._keys[i], this._types[i]);
            this._init = String.valueOf(this._init) + ((OclAnyImpl)arr[i])._init;
            this._init = String.valueOf(this._init) + this._implementation + ".put(\"" + this._keys[i] + "\", " + arr[i].asJavaObject() + ");\n";
            ++i;
        }
    }

    protected String implementation() {
        return this._implementation;
    }

    @Override
    public Object asJavaObject() {
        return this.implementation();
    }

    @Override
    public OclType oclType() {
        TupleType type = this.adapter.getProcessor().getTypeFactory().buildTupleType(this._keys, this._types);
        OclTypeImpl ot = (OclTypeImpl)this.adapter.Type(type);
        ot.setInitialisation(String.valueOf(this.getInitialisation()) + ot.getInitialisation());
        return ot;
    }

    @Override
    public OclAny property(OclString s) {
        String key = (String)s.asJavaObject();
        Classifier eT = (Classifier)this._elementTypes.get(key);
        String part = OclCodeGeneratorVisitorImpl.unBox(eT, this + ".get(\"" + key + "\")");
        OclAnyImpl result = (OclAnyImpl)this.adapter.OclAny(eT, part);
        result._init = String.valueOf(this._init) + result._init;
        return result;
    }

    public OclAny property(OclString s, Object[] pobjs) {
        return this.adapter.Undefined();
    }

    @Override
    public void setProperty(OclString name, Object value) {
    }

    public String toString() {
        return this._implementation;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof OclTupleImpl) {
            OclTupleImpl tuple = (OclTupleImpl)o;
            return this._implementation.equals(tuple._implementation);
        }
        return false;
    }

    @Override
    public Object clone() {
        return new OclTupleImpl(this.type, this._implementation, this.adapter, false);
    }

    public Object accept(OclVisitor v, Object obj) {
        return v.visit(this, obj);
    }
}

